/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.commons.configuration;

import java.util.Iterator;
import org.apache.pulsar.shade.org.apache.commons.collections.Transformer;
import org.apache.pulsar.shade.org.apache.commons.collections.iterators.TransformIterator;
import org.apache.pulsar.shade.org.apache.commons.configuration.AbstractConfiguration;
import org.apache.pulsar.shade.org.apache.commons.configuration.Configuration;

public class SubsetConfiguration
extends AbstractConfiguration {
    protected Configuration parent;
    protected String prefix;
    protected String delimiter;

    public SubsetConfiguration(Configuration parent, String prefix) {
        this.parent = parent;
        this.prefix = prefix;
    }

    public SubsetConfiguration(Configuration parent, String prefix, String delimiter) {
        this.parent = parent;
        this.prefix = prefix;
        this.delimiter = delimiter;
    }

    protected String getParentKey(String key) {
        if ("".equals(key) || key == null) {
            return this.prefix;
        }
        return this.delimiter == null ? this.prefix + key : this.prefix + this.delimiter + key;
    }

    protected String getChildKey(String key) {
        if (!key.startsWith(this.prefix)) {
            throw new IllegalArgumentException("The parent key '" + key + "' is not in the subset.");
        }
        String modifiedKey = null;
        if (key.length() == this.prefix.length()) {
            modifiedKey = "";
        } else {
            int i = this.prefix.length() + (this.delimiter != null ? this.delimiter.length() : 0);
            modifiedKey = key.substring(i);
        }
        return modifiedKey;
    }

    public Configuration getParent() {
        return this.parent;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public Configuration subset(String prefix) {
        return this.parent.subset(this.getParentKey(prefix));
    }

    public boolean isEmpty() {
        return !this.getKeys().hasNext();
    }

    public boolean containsKey(String key) {
        return this.parent.containsKey(this.getParentKey(key));
    }

    public void addPropertyDirect(String key, Object value) {
        this.parent.addProperty(this.getParentKey(key), value);
    }

    public void setProperty(String key, Object value) {
        this.parent.setProperty(this.getParentKey(key), value);
    }

    public void clearProperty(String key) {
        this.parent.clearProperty(this.getParentKey(key));
    }

    public Object getProperty(String key) {
        return this.parent.getProperty(this.getParentKey(key));
    }

    public Iterator getKeys(String prefix) {
        return new TransformIterator(this.parent.getKeys(this.getParentKey(prefix)), new Transformer(){

            public Object transform(Object obj) {
                return SubsetConfiguration.this.getChildKey((String)obj);
            }
        });
    }

    public Iterator getKeys() {
        return new TransformIterator(this.parent.getKeys(this.prefix), new Transformer(){

            public Object transform(Object obj) {
                return SubsetConfiguration.this.getChildKey((String)obj);
            }
        });
    }

    protected Object interpolate(Object base) {
        if (this.delimiter == null && "".equals(this.prefix)) {
            return super.interpolate(base);
        }
        SubsetConfiguration config = new SubsetConfiguration(this.parent, "");
        return config.interpolate(base);
    }

    protected String interpolate(String base) {
        return super.interpolate(base);
    }

    public void setThrowExceptionOnMissing(boolean throwExceptionOnMissing) {
        if (this.parent instanceof AbstractConfiguration) {
            ((AbstractConfiguration)this.parent).setThrowExceptionOnMissing(throwExceptionOnMissing);
        } else {
            super.setThrowExceptionOnMissing(throwExceptionOnMissing);
        }
    }

    public boolean isThrowExceptionOnMissing() {
        if (this.parent instanceof AbstractConfiguration) {
            return ((AbstractConfiguration)this.parent).isThrowExceptionOnMissing();
        }
        return super.isThrowExceptionOnMissing();
    }

    public char getListDelimiter() {
        return this.parent instanceof AbstractConfiguration ? ((AbstractConfiguration)this.parent).getListDelimiter() : super.getListDelimiter();
    }

    public void setListDelimiter(char delim) {
        if (this.parent instanceof AbstractConfiguration) {
            ((AbstractConfiguration)this.parent).setListDelimiter(delim);
        } else {
            super.setListDelimiter(delim);
        }
    }

    public boolean isDelimiterParsingDisabled() {
        return this.parent instanceof AbstractConfiguration ? ((AbstractConfiguration)this.parent).isDelimiterParsingDisabled() : super.isDelimiterParsingDisabled();
    }

    public void setDelimiterParsingDisabled(boolean delimiterParsingDisabled) {
        if (this.parent instanceof AbstractConfiguration) {
            ((AbstractConfiguration)this.parent).setDelimiterParsingDisabled(delimiterParsingDisabled);
        } else {
            super.setDelimiterParsingDisabled(delimiterParsingDisabled);
        }
    }
}

