/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.asynchttpclient.netty.timeout;

import org.apache.pulsar.shade.io.netty.util.Timeout;
import org.apache.pulsar.shade.org.asynchttpclient.netty.NettyResponseFuture;
import org.apache.pulsar.shade.org.asynchttpclient.netty.request.NettyRequestSender;
import org.apache.pulsar.shade.org.asynchttpclient.netty.timeout.TimeoutTimerTask;
import org.apache.pulsar.shade.org.asynchttpclient.netty.timeout.TimeoutsHolder;
import org.apache.pulsar.shade.org.asynchttpclient.util.DateUtils;
import org.apache.pulsar.shade.org.asynchttpclient.util.StringBuilderPool;

public class RequestTimeoutTimerTask
extends TimeoutTimerTask {
    private final long requestTimeout;

    RequestTimeoutTimerTask(NettyResponseFuture<?> nettyResponseFuture, NettyRequestSender requestSender, TimeoutsHolder timeoutsHolder, int requestTimeout) {
        super(nettyResponseFuture, requestSender, timeoutsHolder);
        this.requestTimeout = requestTimeout;
    }

    @Override
    public void run(Timeout timeout) {
        if (this.done.getAndSet(true) || this.requestSender.isClosed()) {
            return;
        }
        this.timeoutsHolder.cancel();
        if (this.nettyResponseFuture.isDone()) {
            return;
        }
        StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder().append("Request timeout to ");
        this.appendRemoteAddress(sb);
        String message = sb.append(" after ").append(this.requestTimeout).append(" ms").toString();
        long age = DateUtils.unpreciseMillisTime() - this.nettyResponseFuture.getStart();
        this.expire(message, age);
    }
}

