/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

public class ByteSchema
implements Schema<Byte> {
    private static final ByteSchema INSTANCE = new ByteSchema();
    private static final SchemaInfo SCHEMA_INFO = new SchemaInfo().setName("INT8").setType(SchemaType.INT8).setSchema(new byte[0]);

    public static ByteSchema of() {
        return INSTANCE;
    }

    public void validate(byte[] message) {
        if (message.length != 1) {
            throw new SchemaSerializationException("Size of data received by ByteSchema is not 1");
        }
    }

    public byte[] encode(Byte message) {
        if (null == message) {
            return null;
        }
        return new byte[]{message};
    }

    public Byte decode(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        this.validate(bytes);
        return bytes[0];
    }

    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }
}

