/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.util.Date;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.schema.LongSchema;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

public class DateSchema
implements Schema<Date> {
    private static final DateSchema INSTANCE = new DateSchema();
    private static final SchemaInfo SCHEMA_INFO = new SchemaInfo().setName("Date").setType(SchemaType.DATE).setSchema(new byte[0]);

    public static DateSchema of() {
        return INSTANCE;
    }

    public byte[] encode(Date message) {
        if (null == message) {
            return null;
        }
        Long date = message.getTime();
        return LongSchema.of().encode(date);
    }

    public Date decode(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        Long decode = LongSchema.of().decode(bytes);
        return new Date(decode);
    }

    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }
}

