/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema.generic;

import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.schema.SchemaInfoProvider;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.shade.com.google.common.cache.CacheBuilder;
import org.apache.pulsar.shade.com.google.common.cache.CacheLoader;
import org.apache.pulsar.shade.com.google.common.cache.LoadingCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiVersionSchemaInfoProvider
implements SchemaInfoProvider {
    private static final Logger LOG = LoggerFactory.getLogger(MultiVersionSchemaInfoProvider.class);
    private final TopicName topicName;
    private final PulsarClientImpl pulsarClient;
    private final LoadingCache<byte[], SchemaInfo> cache = CacheBuilder.newBuilder().maximumSize(100000L).expireAfterAccess(30L, TimeUnit.MINUTES).build(new CacheLoader<byte[], SchemaInfo>(){

        @Override
        public SchemaInfo load(byte[] schemaVersion) throws Exception {
            return MultiVersionSchemaInfoProvider.this.loadSchema(schemaVersion);
        }
    });

    public MultiVersionSchemaInfoProvider(TopicName topicName, PulsarClientImpl pulsarClient) {
        this.topicName = topicName;
        this.pulsarClient = pulsarClient;
    }

    public SchemaInfo getSchemaByVersion(byte[] schemaVersion) {
        try {
            if (null == schemaVersion) {
                return null;
            }
            return this.cache.get(schemaVersion);
        }
        catch (ExecutionException e) {
            LOG.error("Can't get generic schema for topic {} schema version {}", new Object[]{this.topicName.toString(), new String(schemaVersion, StandardCharsets.UTF_8), e});
            throw new RuntimeException("Can't get generic schema for topic " + this.topicName.toString());
        }
    }

    public SchemaInfo getLatestSchema() {
        try {
            Optional<SchemaInfo> optional = this.pulsarClient.getLookup().getSchema(this.topicName).get();
            return optional.orElse(null);
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Can't get current schema for topic {}", (Object)this.topicName.toString(), (Object)e);
            throw new RuntimeException("Can't get current schema for topic " + this.topicName.toString());
        }
    }

    public String getTopicName() {
        return this.topicName.getLocalName();
    }

    private SchemaInfo loadSchema(byte[] schemaVersion) throws ExecutionException, InterruptedException {
        Optional<SchemaInfo> optional = this.pulsarClient.getLookup().getSchema(this.topicName, schemaVersion).get();
        return optional.orElse(null);
    }

    public PulsarClientImpl getPulsarClient() {
        return this.pulsarClient;
    }
}

