/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.auth;

import java.security.KeyManagementException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.common.util.FileModifiedTimeUpdater;
import org.apache.pulsar.common.util.SecurityUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationDataTls
implements AuthenticationDataProvider {
    protected X509Certificate[] tlsCertificates;
    protected PrivateKey tlsPrivateKey;
    protected FileModifiedTimeUpdater certFile;
    protected FileModifiedTimeUpdater keyFile;
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationDataTls.class);

    public AuthenticationDataTls(String certFilePath, String keyFilePath) throws KeyManagementException {
        if (certFilePath == null) {
            throw new IllegalArgumentException("certFilePath must not be null");
        }
        if (keyFilePath == null) {
            throw new IllegalArgumentException("keyFilePath must not be null");
        }
        this.certFile = new FileModifiedTimeUpdater(certFilePath);
        this.keyFile = new FileModifiedTimeUpdater(keyFilePath);
        this.tlsCertificates = SecurityUtility.loadCertificatesFromPemFile(certFilePath);
        this.tlsPrivateKey = SecurityUtility.loadPrivateKeyFromPemFile(keyFilePath);
    }

    public boolean hasDataForTls() {
        return true;
    }

    public Certificate[] getTlsCertificates() {
        if (this.certFile.checkAndRefresh()) {
            try {
                this.tlsCertificates = SecurityUtility.loadCertificatesFromPemFile(this.certFile.getFileName());
            }
            catch (KeyManagementException e) {
                LOG.error("Unable to refresh authData for cert {}: ", (Object)this.certFile.getFileName(), (Object)e);
            }
        }
        return this.tlsCertificates;
    }

    public PrivateKey getTlsPrivateKey() {
        if (this.keyFile.checkAndRefresh()) {
            try {
                this.tlsPrivateKey = SecurityUtility.loadPrivateKeyFromPemFile(this.keyFile.getFileName());
            }
            catch (KeyManagementException e) {
                LOG.error("Unable to refresh authData for cert {}: ", (Object)this.keyFile.getFileName(), (Object)e);
            }
        }
        return this.tlsPrivateKey;
    }
}

