/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Provider;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.apache.pulsar.common.util.BCLoader;
import org.apache.pulsar.common.util.BcNarDefinition;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchBcNarUtils {
    private static final Logger log = LoggerFactory.getLogger(SearchBcNarUtils.class);
    private static final String BC_DEF_NAME = "bouncy-castle.yaml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Provider getBcProvider(String loaderDirectory) throws IOException {
        Path path = Paths.get(loaderDirectory, new String[0]).toAbsolutePath();
        log.info("Searching for Bouncy Castle Loader in {}", (Object)path);
        if (!path.toFile().exists()) {
            log.warn("Bouncy Castle Loader archive directory not found");
            return null;
        }
        Throwable throwable = null;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path, "*.nar");){
            Provider provider;
            Iterator<Path> iterator = stream.iterator();
            String narPath = iterator.next().toString();
            NarClassLoader ncl = NarClassLoader.getFromArchive(new File(narPath), Collections.emptySet(), BCLoader.class.getClassLoader());
            String configStr = ncl.getServiceDefinition(BC_DEF_NAME);
            BcNarDefinition nar = ObjectMapperFactory.getThreadLocalYaml().readValue(configStr, BcNarDefinition.class);
            if (StringUtils.isEmpty(nar.getBcLoaderClass())) {
                throw new IOException(String.format("The '%s' not provided a Bouncy Castle Loader in nar yaml file", nar.getName()));
            }
            Class<?> loaderClass = ncl.loadClass(nar.getBcLoaderClass());
            CompletableFuture loadFuture = new CompletableFuture();
            Thread loadingThread = new Thread(() -> {
                Thread.currentThread().setContextClassLoader(ncl);
                try {
                    Object loader = loaderClass.newInstance();
                    if (!(loader instanceof BCLoader)) {
                        throw new IOException("Class " + nar.getBcLoaderClass() + " not a impl of " + BCLoader.class.getName());
                    }
                    Provider provider = ((BCLoader)loader).getProvider();
                    log.info("Found Bouncy Castle loader {} from {}, provider: {}", new Object[]{loader.getClass().getCanonicalName(), path, provider.getName()});
                    loadFuture.complete(provider);
                }
                catch (Throwable t) {
                    log.error("Failed to load Bouncy Castle Provider ", t);
                    loadFuture.completeExceptionally(t);
                }
            }, "load-factory-" + loaderClass);
            try {
                loadingThread.start();
                Provider ret = (Provider)loadFuture.get();
                if (iterator.hasNext()) {
                    throw new RuntimeException("Should only have 1 Bouncy Castle Provider nar provided");
                }
                provider = ret;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        loadingThread.join();
                        throw throwable2;
                    }
                    catch (Throwable t) {
                        log.error("Failed to load Bouncy Castle Provider with error", t);
                        throw new RuntimeException(t);
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            loadingThread.join();
            return provider;
        }
    }
}

