/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Collection;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.pulsar.common.util.DefaultSslContextBuilder;
import org.apache.pulsar.common.util.KeyStoreHolder;
import org.apache.pulsar.common.util.SearchBcNarUtils;
import org.apache.pulsar.shade.io.netty.handler.ssl.ClientAuth;
import org.apache.pulsar.shade.io.netty.handler.ssl.SslContext;
import org.apache.pulsar.shade.io.netty.handler.ssl.SslContextBuilder;
import org.apache.pulsar.shade.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import org.apache.pulsar.shade.org.eclipse.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityUtility {
    private static final Logger log = LoggerFactory.getLogger(SecurityUtility.class);
    public static final Provider BC_PROVIDER = SecurityUtility.getProvider();
    public static final String BC_FIPS_PROVIDER_CLASS = "org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider";
    public static final String BC_NON_FIPS_PROVIDER_CLASS = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    public static final String BC_FIPS = "BCFIPS";
    public static final String BC = "BC";

    public static boolean isBCFIPS() {
        return BC_PROVIDER.getClass().getCanonicalName().equals(BC_FIPS_PROVIDER_CLASS);
    }

    public static Provider getProvider() {
        boolean isProviderInstalled;
        boolean bl = isProviderInstalled = Security.getProvider(BC) != null || Security.getProvider(BC_FIPS) != null;
        if (isProviderInstalled) {
            Provider provider = Security.getProvider(BC) != null ? Security.getProvider(BC) : Security.getProvider(BC_FIPS);
            log.info("Already instantiated Bouncy Castle provider {}", (Object)provider.getName());
            return provider;
        }
        try {
            return SecurityUtility.getBCProviderFromClassPath();
        }
        catch (Exception e) {
            log.warn("Not able to get Bouncy Castle provider for both FIPS and Non-FIPS from class path:", (Throwable)e);
            try {
                return SearchBcNarUtils.getBcProvider(System.getProperty("BcPath"));
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }

    public static Provider getBCProviderFromClassPath() throws Exception {
        Class<?> clazz;
        try {
            clazz = Class.forName(BC_NON_FIPS_PROVIDER_CLASS);
        }
        catch (ClassNotFoundException cnf) {
            log.warn("Not able to get Bouncy Castle provider: {}, try to get FIPS provider {}", (Object)BC_NON_FIPS_PROVIDER_CLASS, (Object)BC_FIPS_PROVIDER_CLASS);
            clazz = Class.forName(BC_FIPS_PROVIDER_CLASS);
        }
        Provider provider = (Provider)clazz.newInstance();
        Security.addProvider(provider);
        log.info("Found and Instantiated Bouncy Castle provider in classpath {}", (Object)provider.getName());
        return provider;
    }

    public static SSLContext createSslContext(boolean allowInsecureConnection, Certificate[] trustCertificates) throws GeneralSecurityException {
        return SecurityUtility.createSslContext(allowInsecureConnection, trustCertificates, (Certificate[])null, (PrivateKey)null);
    }

    public static SslContext createNettySslContextForClient(boolean allowInsecureConnection, String trustCertsFilePath) throws GeneralSecurityException, SSLException, FileNotFoundException, IOException {
        return SecurityUtility.createNettySslContextForClient(allowInsecureConnection, trustCertsFilePath, (Certificate[])null, (PrivateKey)null);
    }

    public static SSLContext createSslContext(boolean allowInsecureConnection, String trustCertsFilePath, String certFilePath, String keyFilePath) throws GeneralSecurityException {
        Certificate[] trustCertificates = SecurityUtility.loadCertificatesFromPemFile(trustCertsFilePath);
        Certificate[] certificates = SecurityUtility.loadCertificatesFromPemFile(certFilePath);
        PrivateKey privateKey = SecurityUtility.loadPrivateKeyFromPemFile(keyFilePath);
        return SecurityUtility.createSslContext(allowInsecureConnection, trustCertificates, certificates, privateKey);
    }

    public static SslContext createNettySslContextForClient(boolean allowInsecureConnection, String trustCertsFilePath, String certFilePath, String keyFilePath) throws GeneralSecurityException, SSLException, FileNotFoundException, IOException {
        Certificate[] certificates = SecurityUtility.loadCertificatesFromPemFile(certFilePath);
        PrivateKey privateKey = SecurityUtility.loadPrivateKeyFromPemFile(keyFilePath);
        return SecurityUtility.createNettySslContextForClient(allowInsecureConnection, trustCertsFilePath, certificates, privateKey);
    }

    public static SslContext createNettySslContextForClient(boolean allowInsecureConnection, String trustCertsFilePath, Certificate[] certificates, PrivateKey privateKey) throws GeneralSecurityException, SSLException, FileNotFoundException, IOException {
        SslContextBuilder builder = SslContextBuilder.forClient();
        SecurityUtility.setupTrustCerts(builder, allowInsecureConnection, trustCertsFilePath);
        SecurityUtility.setupKeyManager(builder, privateKey, (X509Certificate[])certificates);
        return builder.build();
    }

    public static SslContext createNettySslContextForServer(boolean allowInsecureConnection, String trustCertsFilePath, String certFilePath, String keyFilePath, Set<String> ciphers, Set<String> protocols, boolean requireTrustedClientCertOnConnect) throws GeneralSecurityException, SSLException, FileNotFoundException, IOException {
        X509Certificate[] certificates = SecurityUtility.loadCertificatesFromPemFile(certFilePath);
        PrivateKey privateKey = SecurityUtility.loadPrivateKeyFromPemFile(keyFilePath);
        SslContextBuilder builder = SslContextBuilder.forServer(privateKey, certificates);
        SecurityUtility.setupCiphers(builder, ciphers);
        SecurityUtility.setupProtocols(builder, protocols);
        SecurityUtility.setupTrustCerts(builder, allowInsecureConnection, trustCertsFilePath);
        SecurityUtility.setupKeyManager(builder, privateKey, certificates);
        SecurityUtility.setupClientAuthentication(builder, requireTrustedClientCertOnConnect);
        return builder.build();
    }

    public static SSLContext createSslContext(boolean allowInsecureConnection, Certificate[] trustCertficates, Certificate[] certificates, PrivateKey privateKey) throws GeneralSecurityException {
        KeyStoreHolder ksh = new KeyStoreHolder();
        TrustManager[] trustManagers = null;
        KeyManager[] keyManagers = null;
        trustManagers = SecurityUtility.setupTrustCerts(ksh, allowInsecureConnection, trustCertficates);
        keyManagers = SecurityUtility.setupKeyManager(ksh, privateKey, certificates);
        SSLContext sslCtx = SSLContext.getInstance("TLS");
        sslCtx.init(keyManagers, trustManagers, new SecureRandom());
        sslCtx.getDefaultSSLParameters();
        return sslCtx;
    }

    private static KeyManager[] setupKeyManager(KeyStoreHolder ksh, PrivateKey privateKey, Certificate[] certificates) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyManager[] keyManagers = null;
        if (certificates != null && privateKey != null) {
            ksh.setPrivateKey("private", privateKey, certificates);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ksh.getKeyStore(), "".toCharArray());
            keyManagers = kmf.getKeyManagers();
        }
        return keyManagers;
    }

    private static TrustManager[] setupTrustCerts(KeyStoreHolder ksh, boolean allowInsecureConnection, Certificate[] trustCertficates) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManager[] trustManagers;
        if (allowInsecureConnection) {
            trustManagers = InsecureTrustManagerFactory.INSTANCE.getTrustManagers();
        } else {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            if (trustCertficates == null || trustCertficates.length == 0) {
                tmf.init((KeyStore)null);
            } else {
                for (int i = 0; i < trustCertficates.length; ++i) {
                    ksh.setCertificate("trust" + i, trustCertficates[i]);
                }
                tmf.init(ksh.getKeyStore());
            }
            trustManagers = tmf.getTrustManagers();
        }
        return trustManagers;
    }

    public static X509Certificate[] loadCertificatesFromPemFile(String certFilePath) throws KeyManagementException {
        X509Certificate[] certificates = null;
        if (certFilePath == null || certFilePath.isEmpty()) {
            return certificates;
        }
        try (FileInputStream input = new FileInputStream(certFilePath);){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> collection = cf.generateCertificates(input);
            certificates = collection.toArray(new X509Certificate[collection.size()]);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new KeyManagementException("Certificate loading error", e);
        }
        return certificates;
    }

    public static PrivateKey loadPrivateKeyFromPemFile(String keyFilePath) throws KeyManagementException {
        PrivateKey privateKey = null;
        if (keyFilePath == null || keyFilePath.isEmpty()) {
            return privateKey;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(keyFilePath));){
            StringBuilder sb = new StringBuilder();
            String previousLine = "";
            String currentLine = null;
            reader.readLine();
            while ((currentLine = reader.readLine()) != null) {
                sb.append(previousLine);
                previousLine = currentLine;
            }
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(sb.toString()));
            privateKey = kf.generatePrivate(keySpec);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new KeyManagementException("Private key loading error", e);
        }
        return privateKey;
    }

    private static void setupTrustCerts(SslContextBuilder builder, boolean allowInsecureConnection, String trustCertsFilePath) throws IOException, FileNotFoundException {
        if (allowInsecureConnection) {
            builder.trustManager(InsecureTrustManagerFactory.INSTANCE);
        } else if (trustCertsFilePath != null && trustCertsFilePath.length() != 0) {
            try (FileInputStream input = new FileInputStream(trustCertsFilePath);){
                builder.trustManager(input);
            }
        } else {
            builder.trustManager((File)null);
        }
    }

    private static void setupKeyManager(SslContextBuilder builder, PrivateKey privateKey, X509Certificate[] certificates) {
        builder.keyManager(privateKey, certificates);
    }

    private static void setupCiphers(SslContextBuilder builder, Set<String> ciphers) {
        if (ciphers != null && ciphers.size() > 0) {
            builder.ciphers(ciphers);
        }
    }

    private static void setupProtocols(SslContextBuilder builder, Set<String> protocols) {
        if (protocols != null && protocols.size() > 0) {
            builder.protocols(protocols.toArray(new String[protocols.size()]));
        }
    }

    private static void setupClientAuthentication(SslContextBuilder builder, boolean requireTrustedClientCertOnConnect) {
        if (requireTrustedClientCertOnConnect) {
            builder.clientAuth(ClientAuth.REQUIRE);
        } else {
            builder.clientAuth(ClientAuth.OPTIONAL);
        }
    }

    public static SslContextFactory createSslContextFactory(boolean tlsAllowInsecureConnection, String tlsTrustCertsFilePath, String tlsCertificateFilePath, String tlsKeyFilePath, boolean tlsRequireTrustedClientCertOnConnect, boolean autoRefresh, long certRefreshInSec) throws GeneralSecurityException, SSLException, FileNotFoundException, IOException {
        SslContextFactory sslCtxFactory = null;
        if (autoRefresh) {
            sslCtxFactory = new SslContextFactoryWithAutoRefresh(tlsAllowInsecureConnection, tlsTrustCertsFilePath, tlsCertificateFilePath, tlsKeyFilePath, tlsRequireTrustedClientCertOnConnect, 0L);
        } else {
            sslCtxFactory = new SslContextFactory();
            SSLContext sslCtx = SecurityUtility.createSslContext(tlsAllowInsecureConnection, tlsTrustCertsFilePath, tlsCertificateFilePath, tlsKeyFilePath);
            sslCtxFactory.setSslContext(sslCtx);
        }
        if (tlsRequireTrustedClientCertOnConnect) {
            sslCtxFactory.setNeedClientAuth(true);
        } else {
            sslCtxFactory.setWantClientAuth(true);
        }
        sslCtxFactory.setTrustAll(true);
        return sslCtxFactory;
    }

    static class SslContextFactoryWithAutoRefresh
    extends SslContextFactory {
        private final DefaultSslContextBuilder sslCtxRefresher;

        public SslContextFactoryWithAutoRefresh(boolean tlsAllowInsecureConnection, String tlsTrustCertsFilePath, String tlsCertificateFilePath, String tlsKeyFilePath, boolean tlsRequireTrustedClientCertOnConnect, long certRefreshInSec) throws SSLException, FileNotFoundException, GeneralSecurityException, IOException {
            this.sslCtxRefresher = new DefaultSslContextBuilder(tlsAllowInsecureConnection, tlsTrustCertsFilePath, tlsCertificateFilePath, tlsKeyFilePath, tlsRequireTrustedClientCertOnConnect, certRefreshInSec);
        }

        @Override
        public SSLContext getSslContext() {
            return (SSLContext)this.sslCtxRefresher.get();
        }
    }
}

