/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import java.util.List;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.policies.data.ConsumerStats;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.Lists;

public class SubscriptionStats {
    public double msgRateOut;
    public double msgThroughputOut;
    public long bytesOutCounter;
    public long msgOutCounter;
    public double msgRateRedeliver;
    public long msgBacklog;
    public long msgBacklogNoDelayed;
    public boolean blockedSubscriptionOnUnackedMsgs;
    public long msgDelayed;
    public long unackedMessages;
    public PulsarApi.CommandSubscribe.SubType type;
    public String activeConsumerName;
    public double msgRateExpired;
    public long lastExpireTimestamp;
    public long lastConsumedFlowTimestamp;
    public long lastConsumedTimestamp;
    public long lastAckedTimestamp;
    public List<ConsumerStats> consumers = Lists.newArrayList();
    public boolean isReplicated;

    public void reset() {
        this.msgRateOut = 0.0;
        this.msgThroughputOut = 0.0;
        this.bytesOutCounter = 0L;
        this.msgOutCounter = 0L;
        this.msgRateRedeliver = 0.0;
        this.msgBacklog = 0L;
        this.msgBacklogNoDelayed = 0L;
        this.unackedMessages = 0L;
        this.msgRateExpired = 0.0;
        this.lastExpireTimestamp = 0L;
        this.consumers.clear();
    }

    public SubscriptionStats add(SubscriptionStats stats) {
        Preconditions.checkNotNull(stats);
        this.msgRateOut += stats.msgRateOut;
        this.msgThroughputOut += stats.msgThroughputOut;
        this.bytesOutCounter += stats.bytesOutCounter;
        this.msgOutCounter += stats.msgOutCounter;
        this.msgRateRedeliver += stats.msgRateRedeliver;
        this.msgBacklog += stats.msgBacklog;
        this.msgBacklogNoDelayed += stats.msgBacklogNoDelayed;
        this.unackedMessages += stats.unackedMessages;
        this.msgRateExpired += stats.msgRateExpired;
        this.isReplicated |= stats.isReplicated;
        if (this.consumers.size() != stats.consumers.size()) {
            for (int i = 0; i < stats.consumers.size(); ++i) {
                ConsumerStats consumerStats = new ConsumerStats();
                this.consumers.add(consumerStats.add(stats.consumers.get(i)));
            }
        } else {
            for (int i = 0; i < stats.consumers.size(); ++i) {
                this.consumers.get(i).add(stats.consumers.get(i));
            }
        }
        return this;
    }
}

