/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.client.impl.ClientCnx;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.schema.KeyValueSchema;
import org.apache.pulsar.common.api.EncryptionContext;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.schema.KeyValueEncodingType;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.Maps;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;
import org.apache.pulsar.shade.io.netty.util.Recycler;

public class MessageImpl<T>
implements Message<T> {
    protected MessageId messageId;
    private PulsarApi.MessageMetadata.Builder msgMetadataBuilder;
    private ClientCnx cnx;
    private ByteBuf payload;
    private Schema<T> schema;
    private SchemaState schemaState = SchemaState.None;
    private Optional<EncryptionContext> encryptionCtx = Optional.empty();
    private String topic;
    private transient Map<String, String> properties;
    private final int redeliveryCount;
    private Recycler.Handle<MessageImpl<?>> recyclerHandle;
    private static final Recycler<MessageImpl<?>> RECYCLER = new Recycler<MessageImpl<?>>(){

        @Override
        protected MessageImpl<?> newObject(Recycler.Handle<MessageImpl<?>> handle) {
            return new MessageImpl(handle);
        }
    };

    public static <T> MessageImpl<T> create(PulsarApi.MessageMetadata.Builder msgMetadataBuilder, ByteBuffer payload, Schema<T> schema) {
        MessageImpl<?> msg = RECYCLER.get();
        msg.msgMetadataBuilder = msgMetadataBuilder;
        msg.messageId = null;
        msg.topic = null;
        msg.cnx = null;
        msg.payload = Unpooled.wrappedBuffer(payload);
        msg.properties = null;
        msg.schema = schema;
        return msg;
    }

    MessageImpl(String topic, MessageIdImpl messageId, PulsarApi.MessageMetadata msgMetadata, ByteBuf payload, ClientCnx cnx, Schema<T> schema) {
        this(topic, messageId, msgMetadata, payload, Optional.empty(), cnx, schema);
    }

    MessageImpl(String topic, MessageIdImpl messageId, PulsarApi.MessageMetadata msgMetadata, ByteBuf payload, Optional<EncryptionContext> encryptionCtx, ClientCnx cnx, Schema<T> schema) {
        this(topic, messageId, msgMetadata, payload, encryptionCtx, cnx, schema, 0);
    }

    MessageImpl(String topic, MessageIdImpl messageId, PulsarApi.MessageMetadata msgMetadata, ByteBuf payload, Optional<EncryptionContext> encryptionCtx, ClientCnx cnx, Schema<T> schema, int redeliveryCount) {
        this.msgMetadataBuilder = PulsarApi.MessageMetadata.newBuilder(msgMetadata);
        this.messageId = messageId;
        this.topic = topic;
        this.cnx = cnx;
        this.redeliveryCount = redeliveryCount;
        this.payload = Unpooled.copiedBuffer(payload);
        this.encryptionCtx = encryptionCtx;
        this.properties = msgMetadata.getPropertiesCount() > 0 ? Collections.unmodifiableMap(this.msgMetadataBuilder.getPropertiesList().stream().collect(Collectors.toMap(PulsarApi.KeyValue::getKey, PulsarApi.KeyValue::getValue, (oldValue, newValue) -> newValue))) : Collections.emptyMap();
        this.schema = schema;
    }

    MessageImpl(String topic, BatchMessageIdImpl batchMessageIdImpl, PulsarApi.MessageMetadata msgMetadata, PulsarApi.SingleMessageMetadata singleMessageMetadata, ByteBuf payload, Optional<EncryptionContext> encryptionCtx, ClientCnx cnx, Schema<T> schema) {
        this(topic, batchMessageIdImpl, msgMetadata, singleMessageMetadata, payload, encryptionCtx, cnx, schema, 0);
    }

    MessageImpl(String topic, BatchMessageIdImpl batchMessageIdImpl, PulsarApi.MessageMetadata msgMetadata, PulsarApi.SingleMessageMetadata singleMessageMetadata, ByteBuf payload, Optional<EncryptionContext> encryptionCtx, ClientCnx cnx, Schema<T> schema, int redeliveryCount) {
        this.msgMetadataBuilder = PulsarApi.MessageMetadata.newBuilder(msgMetadata);
        this.messageId = batchMessageIdImpl;
        this.topic = topic;
        this.cnx = cnx;
        this.redeliveryCount = redeliveryCount;
        this.payload = Unpooled.copiedBuffer(payload);
        this.encryptionCtx = encryptionCtx;
        if (singleMessageMetadata.getPropertiesCount() > 0) {
            TreeMap<String, String> properties = Maps.newTreeMap();
            for (PulsarApi.KeyValue entry : singleMessageMetadata.getPropertiesList()) {
                properties.put(entry.getKey(), entry.getValue());
            }
            this.properties = Collections.unmodifiableMap(properties);
        } else {
            this.properties = Collections.emptyMap();
        }
        if (singleMessageMetadata.hasPartitionKey()) {
            this.msgMetadataBuilder.setPartitionKeyB64Encoded(singleMessageMetadata.getPartitionKeyB64Encoded());
            this.msgMetadataBuilder.setPartitionKey(singleMessageMetadata.getPartitionKey());
        }
        if (singleMessageMetadata.hasEventTime()) {
            this.msgMetadataBuilder.setEventTime(singleMessageMetadata.getEventTime());
        }
        if (singleMessageMetadata.hasSequenceId()) {
            this.msgMetadataBuilder.setSequenceId(singleMessageMetadata.getSequenceId());
        }
        if (singleMessageMetadata.hasNullValue()) {
            this.msgMetadataBuilder.setNullValue(singleMessageMetadata.hasNullValue());
        }
        if (singleMessageMetadata.hasNullPartitionKey()) {
            this.msgMetadataBuilder.setNullPartitionKey(singleMessageMetadata.hasNullPartitionKey());
        }
        this.schema = schema;
    }

    public MessageImpl(String topic, String msgId, Map<String, String> properties, byte[] payload, Schema<T> schema, PulsarApi.MessageMetadata.Builder msgMetadataBuilder) {
        this(topic, msgId, properties, Unpooled.wrappedBuffer(payload), schema, msgMetadataBuilder);
    }

    public MessageImpl(String topic, String msgId, Map<String, String> properties, ByteBuf payload, Schema<T> schema, PulsarApi.MessageMetadata.Builder msgMetadataBuilder) {
        String[] data = msgId.split(":");
        long ledgerId = Long.parseLong(data[0]);
        long entryId = Long.parseLong(data[1]);
        this.messageId = data.length == 3 ? new BatchMessageIdImpl(ledgerId, entryId, -1, Integer.parseInt(data[2])) : new MessageIdImpl(ledgerId, entryId, -1);
        this.topic = topic;
        this.cnx = null;
        this.payload = payload;
        this.properties = Collections.unmodifiableMap(properties);
        this.schema = schema;
        this.redeliveryCount = 0;
        this.msgMetadataBuilder = msgMetadataBuilder;
    }

    public static MessageImpl<byte[]> deserialize(ByteBuf headersAndPayload) throws IOException {
        MessageImpl<byte[]> msg = RECYCLER.get();
        PulsarApi.MessageMetadata msgMetadata = Commands.parseMessageMetadata(headersAndPayload);
        msg.msgMetadataBuilder = PulsarApi.MessageMetadata.newBuilder(msgMetadata);
        msgMetadata.recycle();
        msg.payload = headersAndPayload;
        msg.messageId = null;
        msg.topic = null;
        msg.cnx = null;
        msg.properties = Collections.emptyMap();
        return msg;
    }

    public void setReplicatedFrom(String cluster) {
        Preconditions.checkNotNull(this.msgMetadataBuilder);
        this.msgMetadataBuilder.setReplicatedFrom(cluster);
    }

    public boolean isReplicated() {
        Preconditions.checkNotNull(this.msgMetadataBuilder);
        return this.msgMetadataBuilder.hasReplicatedFrom();
    }

    public String getReplicatedFrom() {
        Preconditions.checkNotNull(this.msgMetadataBuilder);
        return this.msgMetadataBuilder.getReplicatedFrom();
    }

    public long getPublishTime() {
        Preconditions.checkNotNull(this.msgMetadataBuilder);
        return this.msgMetadataBuilder.getPublishTime();
    }

    public long getEventTime() {
        Preconditions.checkNotNull(this.msgMetadataBuilder);
        if (this.msgMetadataBuilder.hasEventTime()) {
            return this.msgMetadataBuilder.getEventTime();
        }
        return 0L;
    }

    public boolean isExpired(int messageTTLInSeconds) {
        return messageTTLInSeconds != 0 && System.currentTimeMillis() > this.getPublishTime() + TimeUnit.SECONDS.toMillis(messageTTLInSeconds);
    }

    public byte[] getData() {
        Preconditions.checkNotNull(this.msgMetadataBuilder);
        if (this.msgMetadataBuilder.hasNullValue()) {
            return null;
        }
        if (this.payload.arrayOffset() == 0 && this.payload.capacity() == this.payload.array().length) {
            return this.payload.array();
        }
        byte[] data = new byte[this.payload.readableBytes()];
        this.payload.readBytes(data);
        return data;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public byte[] getSchemaVersion() {
        if (this.msgMetadataBuilder != null && this.msgMetadataBuilder.hasSchemaVersion()) {
            return this.msgMetadataBuilder.getSchemaVersion().toByteArray();
        }
        return null;
    }

    public T getValue() {
        Preconditions.checkNotNull(this.msgMetadataBuilder);
        if (this.schema.getSchemaInfo() != null && SchemaType.KEY_VALUE == this.schema.getSchemaInfo().getType()) {
            if (this.schema.supportSchemaVersioning()) {
                return this.getKeyValueBySchemaVersion();
            }
            return this.getKeyValue();
        }
        if (this.msgMetadataBuilder.hasNullValue()) {
            return null;
        }
        if (this.schema.supportSchemaVersioning()) {
            byte[] schemaVersion = this.getSchemaVersion();
            if (null == schemaVersion) {
                return (T)this.schema.decode(this.getData());
            }
            return (T)this.schema.decode(this.getData(), schemaVersion);
        }
        return (T)this.schema.decode(this.getData());
    }

    private T getKeyValueBySchemaVersion() {
        KeyValueSchema kvSchema = (KeyValueSchema)this.schema;
        byte[] schemaVersion = this.getSchemaVersion();
        if (kvSchema.getKeyValueEncodingType() == KeyValueEncodingType.SEPARATED) {
            return (T)kvSchema.decode(this.msgMetadataBuilder.hasNullPartitionKey() ? null : this.getKeyBytes(), this.msgMetadataBuilder.hasNullValue() ? null : this.getData(), schemaVersion);
        }
        return (T)this.schema.decode(this.getData(), schemaVersion);
    }

    private T getKeyValue() {
        KeyValueSchema kvSchema = (KeyValueSchema)this.schema;
        if (kvSchema.getKeyValueEncodingType() == KeyValueEncodingType.SEPARATED) {
            return (T)kvSchema.decode(this.msgMetadataBuilder.hasNullPartitionKey() ? null : this.getKeyBytes(), this.msgMetadataBuilder.hasNullValue() ? null : this.getData(), null);
        }
        return (T)this.schema.decode(this.getData());
    }

    public long getSequenceId() {
        Preconditions.checkNotNull(this.msgMetadataBuilder);
        if (this.msgMetadataBuilder.hasSequenceId()) {
            return this.msgMetadataBuilder.getSequenceId();
        }
        return -1L;
    }

    public String getProducerName() {
        Preconditions.checkNotNull(this.msgMetadataBuilder);
        if (this.msgMetadataBuilder.hasProducerName()) {
            return this.msgMetadataBuilder.getProducerName();
        }
        return null;
    }

    public ByteBuf getDataBuffer() {
        return this.payload;
    }

    public MessageId getMessageId() {
        Preconditions.checkNotNull(this.messageId, "Cannot get the message id of a message that was not received");
        return this.messageId;
    }

    public synchronized Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = this.msgMetadataBuilder.getPropertiesCount() > 0 ? Collections.unmodifiableMap(this.msgMetadataBuilder.getPropertiesList().stream().collect(Collectors.toMap(PulsarApi.KeyValue::getKey, PulsarApi.KeyValue::getValue, (oldValue, newValue) -> newValue))) : Collections.emptyMap();
        }
        return this.properties;
    }

    public boolean hasProperty(String name) {
        return this.getProperties().containsKey(name);
    }

    public String getProperty(String name) {
        return this.getProperties().get(name);
    }

    public PulsarApi.MessageMetadata.Builder getMessageBuilder() {
        return this.msgMetadataBuilder;
    }

    public boolean hasKey() {
        Preconditions.checkNotNull(this.msgMetadataBuilder);
        return this.msgMetadataBuilder.hasPartitionKey();
    }

    public String getTopicName() {
        return this.topic;
    }

    public String getKey() {
        Preconditions.checkNotNull(this.msgMetadataBuilder);
        return this.msgMetadataBuilder.getPartitionKey();
    }

    public boolean hasBase64EncodedKey() {
        Preconditions.checkNotNull(this.msgMetadataBuilder);
        return this.msgMetadataBuilder.getPartitionKeyB64Encoded();
    }

    public byte[] getKeyBytes() {
        Preconditions.checkNotNull(this.msgMetadataBuilder);
        if (this.hasBase64EncodedKey()) {
            return Base64.getDecoder().decode(this.getKey());
        }
        return this.getKey().getBytes(StandardCharsets.UTF_8);
    }

    public boolean hasOrderingKey() {
        Preconditions.checkNotNull(this.msgMetadataBuilder);
        return this.msgMetadataBuilder.hasOrderingKey();
    }

    public byte[] getOrderingKey() {
        Preconditions.checkNotNull(this.msgMetadataBuilder);
        return this.msgMetadataBuilder.getOrderingKey().toByteArray();
    }

    public ClientCnx getCnx() {
        return this.cnx;
    }

    public void recycle() {
        this.msgMetadataBuilder = null;
        this.messageId = null;
        this.topic = null;
        this.payload = null;
        this.properties = null;
        this.schema = null;
        this.schemaState = SchemaState.None;
        if (this.recyclerHandle != null) {
            this.recyclerHandle.recycle(this);
        }
    }

    private MessageImpl(Recycler.Handle<MessageImpl<?>> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
        this.redeliveryCount = 0;
    }

    public boolean hasReplicateTo() {
        Preconditions.checkNotNull(this.msgMetadataBuilder);
        return this.msgMetadataBuilder.getReplicateToCount() > 0;
    }

    public List<String> getReplicateTo() {
        Preconditions.checkNotNull(this.msgMetadataBuilder);
        return this.msgMetadataBuilder.getReplicateToList();
    }

    void setMessageId(MessageIdImpl messageId) {
        this.messageId = messageId;
    }

    public Optional<EncryptionContext> getEncryptionCtx() {
        return this.encryptionCtx;
    }

    public int getRedeliveryCount() {
        return this.redeliveryCount;
    }

    SchemaState getSchemaState() {
        return this.schemaState;
    }

    void setSchemaState(SchemaState schemaState) {
        this.schemaState = schemaState;
    }

    static enum SchemaState {
        None,
        Ready,
        Broken;

    }
}

