/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import java.util.LinkedHashSet;
import java.util.Objects;
import org.apache.pulsar.client.api.ProxyProtocol;
import org.apache.pulsar.shade.com.google.common.base.MoreObjects;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.io.swagger.annotations.ApiModel;
import org.apache.pulsar.shade.io.swagger.annotations.ApiModelProperty;

@ApiModel(value="ClusterData", description="The configuration data for a cluster")
public class ClusterData {
    @ApiModelProperty(name="serviceUrl", value="The HTTP rest service URL (for admin operations)", example="http://pulsar.example.com:8080")
    private String serviceUrl;
    @ApiModelProperty(name="serviceUrlTls", value="The HTTPS rest service URL (for admin operations)", example="https://pulsar.example.com:8443")
    private String serviceUrlTls;
    @ApiModelProperty(name="brokerServiceUrl", value="The broker service url (for produce and consume operations)", example="pulsar://pulsar.example.com:6650")
    private String brokerServiceUrl;
    @ApiModelProperty(name="brokerServiceUrlTls", value="The secured broker service url (for produce and consume operations)", example="pulsar+ssl://pulsar.example.com:6651")
    private String brokerServiceUrlTls;
    @ApiModelProperty(name="proxyServiceUrl", value="Proxy-service url when client would like to connect to broker via proxy.", example="pulsar+ssl://ats-proxy.example.com:4443 or pulsar://ats-proxy.example.com:4080")
    private String proxyServiceUrl;
    @ApiModelProperty(name="proxyProtocol", value="protocol to decide type of proxy routing eg: SNI-routing", example="SNI")
    private ProxyProtocol proxyProtocol;
    @ApiModelProperty(name="peerClusterNames", value="A set of peer cluster names")
    private LinkedHashSet<String> peerClusterNames;

    public ClusterData() {
    }

    public ClusterData(String serviceUrl) {
        this(serviceUrl, "");
    }

    public ClusterData(String serviceUrl, String serviceUrlTls) {
        this.serviceUrl = serviceUrl;
        this.serviceUrlTls = serviceUrlTls;
    }

    public ClusterData(String serviceUrl, String serviceUrlTls, String brokerServiceUrl, String brokerServiceUrlTls) {
        this.serviceUrl = serviceUrl;
        this.serviceUrlTls = serviceUrlTls;
        this.brokerServiceUrl = brokerServiceUrl;
        this.brokerServiceUrlTls = brokerServiceUrlTls;
    }

    public ClusterData(String serviceUrl, String serviceUrlTls, String brokerServiceUrl, String brokerServiceUrlTls, String proxyServiceUrl, ProxyProtocol proxyProtocol) {
        this.serviceUrl = serviceUrl;
        this.serviceUrlTls = serviceUrlTls;
        this.brokerServiceUrl = brokerServiceUrl;
        this.brokerServiceUrlTls = brokerServiceUrlTls;
        this.proxyServiceUrl = proxyServiceUrl;
        this.proxyProtocol = proxyProtocol;
    }

    public void update(ClusterData other) {
        Preconditions.checkNotNull(other);
        this.serviceUrl = other.serviceUrl;
        this.serviceUrlTls = other.serviceUrlTls;
        this.brokerServiceUrl = other.brokerServiceUrl;
        this.brokerServiceUrlTls = other.brokerServiceUrlTls;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getServiceUrlTls() {
        return this.serviceUrlTls;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public void setServiceUrlTls(String serviceUrlTls) {
        this.serviceUrlTls = serviceUrlTls;
    }

    public String getBrokerServiceUrl() {
        return this.brokerServiceUrl;
    }

    public void setBrokerServiceUrl(String brokerServiceUrl) {
        this.brokerServiceUrl = brokerServiceUrl;
    }

    public String getBrokerServiceUrlTls() {
        return this.brokerServiceUrlTls;
    }

    public void setBrokerServiceUrlTls(String brokerServiceUrlTls) {
        this.brokerServiceUrlTls = brokerServiceUrlTls;
    }

    public String getProxyServiceUrl() {
        return this.proxyServiceUrl;
    }

    public void setProxyServiceUrl(String proxyServiceUrl) {
        this.proxyServiceUrl = proxyServiceUrl;
    }

    public ProxyProtocol getProxyProtocol() {
        return this.proxyProtocol;
    }

    public void setProxyProtocol(ProxyProtocol proxyProtocol) {
        this.proxyProtocol = proxyProtocol;
    }

    public LinkedHashSet<String> getPeerClusterNames() {
        return this.peerClusterNames;
    }

    public void setPeerClusterNames(LinkedHashSet<String> peerClusterNames) {
        this.peerClusterNames = peerClusterNames;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClusterData) {
            ClusterData other = (ClusterData)obj;
            return Objects.equals(this.serviceUrl, other.serviceUrl) && Objects.equals(this.serviceUrlTls, other.serviceUrlTls) && Objects.equals(this.brokerServiceUrl, other.brokerServiceUrl) && Objects.equals(this.brokerServiceUrlTls, other.brokerServiceUrlTls) && Objects.equals(this.proxyServiceUrl, other.proxyServiceUrl) && Objects.equals(this.proxyProtocol, other.proxyProtocol);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.toString());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("serviceUrl", this.serviceUrl).add("serviceUrlTls", this.serviceUrlTls).add("brokerServiceUrl", this.brokerServiceUrl).add("brokerServiceUrlTls", this.brokerServiceUrlTls).add("proxyServiceUrl", this.proxyServiceUrl).add("proxyProtocol", this.proxyProtocol).add("peerClusterNames", this.peerClusterNames).toString();
    }
}

