/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.auth.oauth2;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.auth.oauth2.FlowBase;
import org.apache.pulsar.client.impl.auth.oauth2.KeyFile;
import org.apache.pulsar.client.impl.auth.oauth2.protocol.ClientCredentialsExchangeRequest;
import org.apache.pulsar.client.impl.auth.oauth2.protocol.ClientCredentialsExchanger;
import org.apache.pulsar.client.impl.auth.oauth2.protocol.TokenClient;
import org.apache.pulsar.client.impl.auth.oauth2.protocol.TokenExchangeException;
import org.apache.pulsar.client.impl.auth.oauth2.protocol.TokenResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClientCredentialsFlow
extends FlowBase {
    private static final Logger log = LoggerFactory.getLogger(ClientCredentialsFlow.class);
    public static final String CONFIG_PARAM_ISSUER_URL = "issuerUrl";
    public static final String CONFIG_PARAM_AUDIENCE = "audience";
    public static final String CONFIG_PARAM_KEY_FILE = "privateKey";
    private static final long serialVersionUID = 1L;
    private final String audience;
    private final String privateKey;
    private transient ClientCredentialsExchanger exchanger;

    public ClientCredentialsFlow(URL issuerUrl, String audience, String privateKey) {
        super(issuerUrl);
        this.audience = audience;
        this.privateKey = privateKey;
    }

    @Override
    public void initialize() throws PulsarClientException {
        super.initialize();
        assert (this.metadata != null);
        URL tokenUrl = this.metadata.getTokenEndpoint();
        this.exchanger = new TokenClient(tokenUrl);
    }

    @Override
    public TokenResult authenticate() throws PulsarClientException {
        TokenResult tr;
        KeyFile keyFile;
        try {
            keyFile = ClientCredentialsFlow.loadPrivateKey(this.privateKey);
        }
        catch (IOException e) {
            throw new PulsarClientException.AuthenticationException("Unable to read private key: " + e.getMessage());
        }
        ClientCredentialsExchangeRequest req = ClientCredentialsExchangeRequest.builder().clientId(keyFile.getClientId()).clientSecret(keyFile.getClientSecret()).audience(this.audience).build();
        try {
            tr = this.exchanger.exchangeClientCredentials(req);
        }
        catch (IOException | TokenExchangeException e) {
            throw new PulsarClientException.AuthenticationException("Unable to obtain an access token: " + e.getMessage());
        }
        return tr;
    }

    @Override
    public void close() throws Exception {
        this.exchanger.close();
    }

    public static ClientCredentialsFlow fromParameters(Map<String, String> params) {
        URL issuerUrl = ClientCredentialsFlow.parseParameterUrl(params, CONFIG_PARAM_ISSUER_URL);
        String audience = ClientCredentialsFlow.parseParameterString(params, CONFIG_PARAM_AUDIENCE);
        String privateKeyUrl = ClientCredentialsFlow.parseParameterString(params, CONFIG_PARAM_KEY_FILE);
        return ClientCredentialsFlow.builder().issuerUrl(issuerUrl).audience(audience).privateKey(privateKeyUrl).build();
    }

    private static KeyFile loadPrivateKey(String privateKeyURL) throws IOException {
        try {
            KeyFile privateKey;
            URLConnection urlConnection = new org.apache.pulsar.client.api.url.URL(privateKeyURL).openConnection();
            String protocol = urlConnection.getURL().getProtocol();
            String contentType = urlConnection.getContentType();
            if ("data".equals(protocol) && !"application/json".equals(contentType)) {
                throw new IllegalArgumentException("Unsupported media type or encoding format: " + urlConnection.getContentType());
            }
            try (InputStreamReader r = new InputStreamReader((InputStream)urlConnection.getContent(), StandardCharsets.UTF_8);){
                privateKey = KeyFile.fromJson(r);
            }
            return privateKey;
        }
        catch (IllegalAccessException | InstantiationException | URISyntaxException e) {
            throw new IOException("Invalid privateKey format", e);
        }
    }

    public static ClientCredentialsFlowBuilder builder() {
        return new ClientCredentialsFlowBuilder();
    }

    public static class ClientCredentialsFlowBuilder {
        private URL issuerUrl;
        private String audience;
        private String privateKey;

        ClientCredentialsFlowBuilder() {
        }

        public ClientCredentialsFlowBuilder issuerUrl(URL issuerUrl) {
            this.issuerUrl = issuerUrl;
            return this;
        }

        public ClientCredentialsFlowBuilder audience(String audience) {
            this.audience = audience;
            return this;
        }

        public ClientCredentialsFlowBuilder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public ClientCredentialsFlow build() {
            return new ClientCredentialsFlow(this.issuerUrl, this.audience, this.privateKey);
        }

        public String toString() {
            return "ClientCredentialsFlow.ClientCredentialsFlowBuilder(issuerUrl=" + this.issuerUrl + ", audience=" + this.audience + ", privateKey=" + this.privateKey + ")";
        }
    }
}

