/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.pulsar.common.policies.data.AuthPolicies;
import org.apache.pulsar.common.policies.data.AutoSubscriptionCreationOverride;
import org.apache.pulsar.common.policies.data.AutoTopicCreationOverride;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.common.policies.data.DelayedDeliveryPolicies;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.InactiveTopicPolicies;
import org.apache.pulsar.common.policies.data.OffloadPolicies;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SchemaAutoUpdateCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.common.policies.data.SubscriptionAuthMode;
import org.apache.pulsar.shade.com.google.common.base.MoreObjects;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.com.google.common.collect.Maps;
import org.apache.pulsar.shade.com.google.common.collect.Sets;

public class Policies {
    public final AuthPolicies auth_policies = new AuthPolicies();
    public Set<String> replication_clusters = Sets.newHashSet();
    public BundlesData bundles;
    public Map<BacklogQuota.BacklogQuotaType, BacklogQuota> backlog_quota_map = Maps.newHashMap();
    @Deprecated
    public Map<String, DispatchRate> clusterDispatchRate = Maps.newHashMap();
    public Map<String, DispatchRate> topicDispatchRate = Maps.newHashMap();
    public Map<String, DispatchRate> subscriptionDispatchRate = Maps.newHashMap();
    public Map<String, DispatchRate> replicatorDispatchRate = Maps.newHashMap();
    public Map<String, SubscribeRate> clusterSubscribeRate = Maps.newHashMap();
    public PersistencePolicies persistence = null;
    public Boolean deduplicationEnabled = null;
    public AutoTopicCreationOverride autoTopicCreationOverride = null;
    public AutoSubscriptionCreationOverride autoSubscriptionCreationOverride = null;
    public Map<String, PublishRate> publishMaxMessageRate = Maps.newHashMap();
    public Map<String, Integer> latency_stats_sample_rate = Maps.newHashMap();
    public int message_ttl_in_seconds = 0;
    public int subscription_expiration_time_minutes = 0;
    public RetentionPolicies retention_policies = null;
    public boolean deleted = false;
    public String antiAffinityGroup;
    public static final String FIRST_BOUNDARY = "0x00000000";
    public static final String LAST_BOUNDARY = "0xffffffff";
    public boolean encryption_required = false;
    public DelayedDeliveryPolicies delayed_delivery_policies = null;
    public InactiveTopicPolicies inactive_topic_policies = null;
    public SubscriptionAuthMode subscription_auth_mode = SubscriptionAuthMode.None;
    public int max_producers_per_topic = 0;
    public int max_consumers_per_topic = 0;
    public int max_consumers_per_subscription = 0;
    public int max_unacked_messages_per_consumer = -1;
    public int max_unacked_messages_per_subscription = -1;
    public long compaction_threshold = 0L;
    public long offload_threshold = -1L;
    public Long offload_deletion_lag_ms = null;
    @Deprecated
    public SchemaAutoUpdateCompatibilityStrategy schema_auto_update_compatibility_strategy = SchemaAutoUpdateCompatibilityStrategy.Full;
    public SchemaCompatibilityStrategy schema_compatibility_strategy = SchemaCompatibilityStrategy.UNDEFINED;
    public boolean is_allow_auto_update_schema = true;
    public boolean schema_validation_enforced = false;
    public OffloadPolicies offload_policies = null;

    public int hashCode() {
        return Objects.hash(new Object[]{this.auth_policies, this.replication_clusters, this.backlog_quota_map, this.publishMaxMessageRate, this.clusterDispatchRate, this.topicDispatchRate, this.subscriptionDispatchRate, this.replicatorDispatchRate, this.clusterSubscribeRate, this.deduplicationEnabled, this.autoTopicCreationOverride, this.autoSubscriptionCreationOverride, this.persistence, this.bundles, this.latency_stats_sample_rate, this.message_ttl_in_seconds, this.subscription_expiration_time_minutes, this.retention_policies, this.encryption_required, this.delayed_delivery_policies, this.inactive_topic_policies, this.subscription_auth_mode, this.antiAffinityGroup, this.max_producers_per_topic, this.max_consumers_per_topic, this.max_consumers_per_subscription, this.max_unacked_messages_per_consumer, this.max_unacked_messages_per_subscription, this.compaction_threshold, this.offload_threshold, this.offload_deletion_lag_ms, this.schema_auto_update_compatibility_strategy, this.schema_validation_enforced, this.schema_compatibility_strategy, this.is_allow_auto_update_schema, this.offload_policies});
    }

    public boolean equals(Object obj) {
        if (obj instanceof Policies) {
            Policies other = (Policies)obj;
            return Objects.equals(this.auth_policies, other.auth_policies) && Objects.equals(this.replication_clusters, other.replication_clusters) && Objects.equals(this.backlog_quota_map, other.backlog_quota_map) && Objects.equals(this.clusterDispatchRate, other.clusterDispatchRate) && Objects.equals(this.topicDispatchRate, other.topicDispatchRate) && Objects.equals(this.subscriptionDispatchRate, other.subscriptionDispatchRate) && Objects.equals(this.replicatorDispatchRate, other.replicatorDispatchRate) && Objects.equals(this.clusterSubscribeRate, other.clusterSubscribeRate) && Objects.equals(this.publishMaxMessageRate, other.publishMaxMessageRate) && Objects.equals(this.deduplicationEnabled, other.deduplicationEnabled) && Objects.equals(this.autoTopicCreationOverride, other.autoTopicCreationOverride) && Objects.equals(this.autoSubscriptionCreationOverride, other.autoSubscriptionCreationOverride) && Objects.equals(this.persistence, other.persistence) && Objects.equals(this.bundles, other.bundles) && Objects.equals(this.latency_stats_sample_rate, other.latency_stats_sample_rate) && Objects.equals(this.message_ttl_in_seconds, other.message_ttl_in_seconds) && Objects.equals(this.subscription_expiration_time_minutes, other.subscription_expiration_time_minutes) && Objects.equals(this.retention_policies, other.retention_policies) && Objects.equals(this.encryption_required, other.encryption_required) && Objects.equals(this.delayed_delivery_policies, other.delayed_delivery_policies) && Objects.equals(this.inactive_topic_policies, other.inactive_topic_policies) && Objects.equals((Object)this.subscription_auth_mode, (Object)other.subscription_auth_mode) && Objects.equals(this.antiAffinityGroup, other.antiAffinityGroup) && this.max_producers_per_topic == other.max_producers_per_topic && this.max_consumers_per_topic == other.max_consumers_per_topic && this.max_consumers_per_subscription == other.max_consumers_per_subscription && this.max_unacked_messages_per_consumer == other.max_unacked_messages_per_consumer && this.max_unacked_messages_per_subscription == other.max_unacked_messages_per_subscription && this.compaction_threshold == other.compaction_threshold && this.offload_threshold == other.offload_threshold && Objects.equals(this.offload_deletion_lag_ms, other.offload_deletion_lag_ms) && this.schema_auto_update_compatibility_strategy == other.schema_auto_update_compatibility_strategy && this.schema_validation_enforced == other.schema_validation_enforced && this.schema_compatibility_strategy == other.schema_compatibility_strategy && this.is_allow_auto_update_schema == other.is_allow_auto_update_schema && Objects.equals(this.offload_policies, other.offload_policies);
        }
        return false;
    }

    public static BundlesData defaultBundle() {
        BundlesData bundle = new BundlesData(1);
        ArrayList<String> boundaries = Lists.newArrayList();
        boundaries.add(FIRST_BOUNDARY);
        boundaries.add(LAST_BOUNDARY);
        bundle.setBoundaries(boundaries);
        return bundle;
    }

    public static void setStorageQuota(Policies polices, BacklogQuota quota) {
        if (polices == null) {
            return;
        }
        polices.backlog_quota_map.put(BacklogQuota.BacklogQuotaType.destination_storage, quota);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("auth_policies", this.auth_policies).add("replication_clusters", this.replication_clusters).add("bundles", this.bundles).add("backlog_quota_map", this.backlog_quota_map).add("persistence", this.persistence).add("deduplicationEnabled", this.deduplicationEnabled).add("autoTopicCreationOverride", this.autoTopicCreationOverride).add("autoSubscriptionCreationOverride", this.autoSubscriptionCreationOverride).add("clusterDispatchRate", this.clusterDispatchRate).add("topicDispatchRate", this.topicDispatchRate).add("subscriptionDispatchRate", this.subscriptionDispatchRate).add("replicatorDispatchRate", this.replicatorDispatchRate).add("clusterSubscribeRate", this.clusterSubscribeRate).add("publishMaxMessageRate", this.publishMaxMessageRate).add("latency_stats_sample_rate", this.latency_stats_sample_rate).add("antiAffinityGroup", this.antiAffinityGroup).add("message_ttl_in_seconds", this.message_ttl_in_seconds).add("subscription_expiration_time_minutes", this.subscription_expiration_time_minutes).add("retention_policies", this.retention_policies).add("deleted", this.deleted).add("encryption_required", this.encryption_required).add("delayed_delivery_policies", this.delayed_delivery_policies).add("inactive_topic_policies", this.inactive_topic_policies).add("subscription_auth_mode", (Object)this.subscription_auth_mode).add("max_producers_per_topic", this.max_producers_per_topic).add("max_consumers_per_topic", this.max_consumers_per_topic).add("max_consumers_per_subscription", this.max_consumers_per_topic).add("max_unacked_messages_per_consumer", this.max_unacked_messages_per_consumer).add("max_unacked_messages_per_subscription", this.max_unacked_messages_per_subscription).add("compaction_threshold", this.compaction_threshold).add("offload_threshold", this.offload_threshold).add("offload_deletion_lag_ms", this.offload_deletion_lag_ms).add("schema_auto_update_compatibility_strategy", (Object)this.schema_auto_update_compatibility_strategy).add("schema_validation_enforced", this.schema_validation_enforced).add("schema_compatibility_Strategy", (Object)this.schema_compatibility_strategy).add("is_allow_auto_update_Schema", this.is_allow_auto_update_schema).add("offload_policies", this.offload_policies).toString();
    }
}

