/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import com.scurrilous.circe.checksum.Crc32cIntChecksum;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ConsumerCryptoFailureAction;
import org.apache.pulsar.client.api.ConsumerStats;
import org.apache.pulsar.client.api.DeadLetterPolicy;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageCrypto;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Messages;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.SubscriptionMode;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.api.TypedMessageBuilder;
import org.apache.pulsar.client.impl.AcknowledgmentsGroupingTracker;
import org.apache.pulsar.client.impl.Backoff;
import org.apache.pulsar.client.impl.BackoffBuilder;
import org.apache.pulsar.client.impl.BatchMessageAcker;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.client.impl.ClientCnx;
import org.apache.pulsar.client.impl.CompletableFutureCancellationHandler;
import org.apache.pulsar.client.impl.ConnectionHandler;
import org.apache.pulsar.client.impl.ConsumerBase;
import org.apache.pulsar.client.impl.ConsumerInterceptors;
import org.apache.pulsar.client.impl.ConsumerStatsDisabled;
import org.apache.pulsar.client.impl.ConsumerStatsRecorder;
import org.apache.pulsar.client.impl.ConsumerStatsRecorderImpl;
import org.apache.pulsar.client.impl.HandlerState;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.client.impl.MessagesImpl;
import org.apache.pulsar.client.impl.NegativeAcksTracker;
import org.apache.pulsar.client.impl.NonPersistentAcknowledgmentGroupingTracker;
import org.apache.pulsar.client.impl.PersistentAcknowledgmentsGroupingTracker;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.TopicMessageIdImpl;
import org.apache.pulsar.client.impl.TopicMessageImpl;
import org.apache.pulsar.client.impl.UnAckedMessageTracker;
import org.apache.pulsar.client.impl.ZeroQueueConsumerImpl;
import org.apache.pulsar.client.impl.conf.ConsumerConfigurationData;
import org.apache.pulsar.client.impl.crypto.MessageCryptoBc;
import org.apache.pulsar.client.impl.transaction.TransactionImpl;
import org.apache.pulsar.common.api.EncryptionContext;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.compression.CompressionCodec;
import org.apache.pulsar.common.compression.CompressionCodecProvider;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.SafeCollectionUtils;
import org.apache.pulsar.common.util.collections.BitSetRecyclable;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashMap;
import org.apache.pulsar.common.util.collections.GrowableArrayBlockingQueue;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.Iterables;
import org.apache.pulsar.shade.com.google.common.collect.Queues;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;
import org.apache.pulsar.shade.io.netty.util.Recycler;
import org.apache.pulsar.shade.io.netty.util.ReferenceCountUtil;
import org.apache.pulsar.shade.io.netty.util.Timeout;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerImpl<T>
extends ConsumerBase<T>
implements ConnectionHandler.Connection {
    private static final int MAX_REDELIVER_UNACKNOWLEDGED = 1000;
    final long consumerId;
    private static final AtomicIntegerFieldUpdater<ConsumerImpl> AVAILABLE_PERMITS_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ConsumerImpl.class, "availablePermits");
    private volatile int availablePermits = 0;
    protected volatile MessageId lastDequeuedMessageId = MessageId.earliest;
    private volatile MessageId lastMessageIdInBroker = MessageId.earliest;
    private long subscribeTimeout;
    private final int partitionIndex;
    private final boolean hasParentConsumer;
    private final int receiverQueueRefillThreshold;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final UnAckedMessageTracker unAckedMessageTracker;
    private final AcknowledgmentsGroupingTracker acknowledgmentsGroupingTracker;
    private final NegativeAcksTracker negativeAcksTracker;
    protected final ConsumerStatsRecorder stats;
    private final int priorityLevel;
    private final SubscriptionMode subscriptionMode;
    private volatile BatchMessageIdImpl startMessageId;
    private volatile BatchMessageIdImpl seekMessageId;
    private final AtomicBoolean duringSeek;
    private final BatchMessageIdImpl initialStartMessageId;
    private final long startMessageRollbackDurationInSec;
    private volatile boolean hasReachedEndOfTopic;
    private final MessageCrypto msgCrypto;
    private final Map<String, String> metadata;
    private final boolean readCompacted;
    private final boolean resetIncludeHead;
    private final SubscriptionInitialPosition subscriptionInitialPosition;
    private final ConnectionHandler connectionHandler;
    private final TopicName topicName;
    private final String topicNameWithoutPartition;
    private final Map<MessageIdImpl, List<MessageImpl<T>>> possibleSendToDeadLetterTopicMessages;
    private final DeadLetterPolicy deadLetterPolicy;
    private Producer<T> deadLetterProducer;
    private volatile Producer<T> retryLetterProducer;
    private final ReadWriteLock createProducerLock = new ReentrantReadWriteLock();
    protected volatile boolean paused;
    protected ConcurrentOpenHashMap<String, ChunkedMessageCtx> chunkedMessagesMap = new ConcurrentOpenHashMap();
    private int pendingChunckedMessageCount = 0;
    protected long expireTimeOfIncompleteChunkedMessageMillis = 0L;
    private boolean expireChunkMessageTaskScheduled = false;
    private int maxPendingChuckedMessage;
    private boolean autoAckOldestChunkedMessageOnQueueFull;
    private final BlockingQueue<String> pendingChunckedMessageUuidQueue;
    private final boolean createTopicIfDoesNotExist;
    private final AtomicReference<ClientCnx> clientCnxUsedForConsumerRegistration = new AtomicReference();
    private static final Logger log = LoggerFactory.getLogger(ConsumerImpl.class);

    static <T> ConsumerImpl<T> newConsumerImpl(PulsarClientImpl client, String topic, ConsumerConfigurationData<T> conf, ExecutorService listenerExecutor, int partitionIndex, boolean hasParentConsumer, CompletableFuture<Consumer<T>> subscribeFuture, MessageId startMessageId, Schema<T> schema, ConsumerInterceptors<T> interceptors, boolean createTopicIfDoesNotExist) {
        if (conf.getReceiverQueueSize() == 0) {
            return new ZeroQueueConsumerImpl<T>(client, topic, conf, listenerExecutor, partitionIndex, hasParentConsumer, subscribeFuture, startMessageId, schema, interceptors, createTopicIfDoesNotExist);
        }
        return new ConsumerImpl<T>(client, topic, conf, listenerExecutor, partitionIndex, hasParentConsumer, subscribeFuture, startMessageId, 0L, schema, interceptors, createTopicIfDoesNotExist);
    }

    protected ConsumerImpl(PulsarClientImpl client, String topic, ConsumerConfigurationData<T> conf, ExecutorService listenerExecutor, int partitionIndex, boolean hasParentConsumer, CompletableFuture<Consumer<T>> subscribeFuture, MessageId startMessageId, long startMessageRollbackDurationInSec, Schema<T> schema, ConsumerInterceptors<T> interceptors, boolean createTopicIfDoesNotExist) {
        super(client, topic, conf, conf.getReceiverQueueSize(), listenerExecutor, subscribeFuture, schema, interceptors);
        this.consumerId = client.newConsumerId();
        this.subscriptionMode = conf.getSubscriptionMode();
        this.initialStartMessageId = this.startMessageId = startMessageId != null ? new BatchMessageIdImpl((MessageIdImpl)startMessageId) : null;
        this.startMessageRollbackDurationInSec = startMessageRollbackDurationInSec;
        AVAILABLE_PERMITS_UPDATER.set(this, 0);
        this.subscribeTimeout = System.currentTimeMillis() + client.getConfiguration().getOperationTimeoutMs();
        this.partitionIndex = partitionIndex;
        this.hasParentConsumer = hasParentConsumer;
        this.receiverQueueRefillThreshold = conf.getReceiverQueueSize() / 2;
        this.priorityLevel = conf.getPriorityLevel();
        this.readCompacted = conf.isReadCompacted();
        this.subscriptionInitialPosition = conf.getSubscriptionInitialPosition();
        this.negativeAcksTracker = new NegativeAcksTracker(this, conf);
        this.resetIncludeHead = conf.isResetIncludeHead();
        this.createTopicIfDoesNotExist = createTopicIfDoesNotExist;
        this.maxPendingChuckedMessage = conf.getMaxPendingChuckedMessage();
        this.pendingChunckedMessageUuidQueue = new GrowableArrayBlockingQueue<String>();
        this.expireTimeOfIncompleteChunkedMessageMillis = conf.getExpireTimeOfIncompleteChunkedMessageMillis();
        this.autoAckOldestChunkedMessageOnQueueFull = conf.isAutoAckOldestChunkedMessageOnQueueFull();
        this.stats = client.getConfiguration().getStatsIntervalSeconds() > 0L ? new ConsumerStatsRecorderImpl(client, conf, this) : ConsumerStatsDisabled.INSTANCE;
        this.duringSeek = new AtomicBoolean(false);
        this.unAckedMessageTracker = conf.getAckTimeoutMillis() != 0L ? (conf.getTickDurationMillis() > 0L ? new UnAckedMessageTracker(client, this, conf.getAckTimeoutMillis(), Math.min(conf.getTickDurationMillis(), conf.getAckTimeoutMillis())) : new UnAckedMessageTracker(client, this, conf.getAckTimeoutMillis())) : UnAckedMessageTracker.UNACKED_MESSAGE_TRACKER_DISABLED;
        if (conf.getCryptoKeyReader() != null) {
            if (conf.getMessageCrypto() != null) {
                this.msgCrypto = conf.getMessageCrypto();
            } else {
                MessageCryptoBc msgCryptoBc;
                try {
                    msgCryptoBc = new MessageCryptoBc(String.format("[%s] [%s]", topic, this.subscription), false);
                }
                catch (Exception e) {
                    log.error("MessageCryptoBc may not included in the jar. e:", (Throwable)e);
                    msgCryptoBc = null;
                }
                this.msgCrypto = msgCryptoBc;
            }
        } else {
            this.msgCrypto = null;
        }
        this.metadata = conf.getProperties().isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, String>(conf.getProperties()));
        this.connectionHandler = new ConnectionHandler(this, new BackoffBuilder().setInitialTime(client.getConfiguration().getInitialBackoffIntervalNanos(), TimeUnit.NANOSECONDS).setMax(client.getConfiguration().getMaxBackoffIntervalNanos(), TimeUnit.NANOSECONDS).setMandatoryStop(0L, TimeUnit.MILLISECONDS).create(), this);
        this.topicName = TopicName.get(topic);
        this.acknowledgmentsGroupingTracker = this.topicName.isPersistent() ? new PersistentAcknowledgmentsGroupingTracker(this, conf, client.eventLoopGroup()) : NonPersistentAcknowledgmentGroupingTracker.of();
        if (conf.getDeadLetterPolicy() != null) {
            this.possibleSendToDeadLetterTopicMessages = new ConcurrentHashMap<MessageIdImpl, List<MessageImpl<T>>>();
            this.deadLetterPolicy = StringUtils.isNotBlank(conf.getDeadLetterPolicy().getDeadLetterTopic()) ? DeadLetterPolicy.builder().maxRedeliverCount(conf.getDeadLetterPolicy().getMaxRedeliverCount()).deadLetterTopic(conf.getDeadLetterPolicy().getDeadLetterTopic()).build() : DeadLetterPolicy.builder().maxRedeliverCount(conf.getDeadLetterPolicy().getMaxRedeliverCount()).deadLetterTopic(String.format("%s-%s-DLQ", topic, this.subscription)).build();
            if (StringUtils.isNotBlank(conf.getDeadLetterPolicy().getRetryLetterTopic())) {
                this.deadLetterPolicy.setRetryLetterTopic(conf.getDeadLetterPolicy().getRetryLetterTopic());
            } else {
                this.deadLetterPolicy.setRetryLetterTopic(String.format("%s-%s-RETRY", topic, this.subscription));
            }
        } else {
            this.deadLetterPolicy = null;
            this.possibleSendToDeadLetterTopicMessages = null;
        }
        this.topicNameWithoutPartition = this.topicName.getPartitionedTopicName();
        this.grabCnx();
    }

    public ConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }

    public UnAckedMessageTracker getUnAckedMessageTracker() {
        return this.unAckedMessageTracker;
    }

    @Override
    public CompletableFuture<Void> unsubscribeAsync() {
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException("Consumer was already closed"));
        }
        CompletableFuture<Void> unsubscribeFuture = new CompletableFuture<Void>();
        if (this.isConnected()) {
            this.setState(HandlerState.State.Closing);
            long requestId = this.client.newRequestId();
            ByteBuf unsubscribe = Commands.newUnsubscribe(this.consumerId, requestId);
            ClientCnx cnx = this.cnx();
            ((CompletableFuture)cnx.sendRequestWithId(unsubscribe, requestId).thenRun(() -> {
                this.closeConsumerTasks();
                this.deregisterFromClientCnx();
                this.client.cleanupConsumer(this);
                log.info("[{}][{}] Successfully unsubscribed from topic", (Object)this.topic, (Object)this.subscription);
                this.setState(HandlerState.State.Closed);
                unsubscribeFuture.complete(null);
            })).exceptionally(e -> {
                log.error("[{}][{}] Failed to unsubscribe: {}", new Object[]{this.topic, this.subscription, e.getCause().getMessage()});
                this.setState(HandlerState.State.Ready);
                unsubscribeFuture.completeExceptionally(PulsarClientException.wrap((Throwable)e.getCause(), (String)String.format("Failed to unsubscribe the subscription %s of topic %s", this.topicName.toString(), this.subscription)));
                return null;
            });
        } else {
            unsubscribeFuture.completeExceptionally(new PulsarClientException(String.format("The client is not connected to the broker when unsubscribing the subscription %s of the topic %s", this.subscription, this.topicName.toString())));
        }
        return unsubscribeFuture;
    }

    @Override
    protected Message<T> internalReceive() throws PulsarClientException {
        try {
            Message message = (Message)this.incomingMessages.take();
            this.messageProcessed(message);
            return this.beforeConsume(message);
        }
        catch (InterruptedException e) {
            this.stats.incrementNumReceiveFailed();
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CompletableFuture<Message<T>> internalReceiveAsync() {
        CompletableFutureCancellationHandler cancellationHandler = new CompletableFutureCancellationHandler();
        CompletableFuture result = cancellationHandler.createFuture();
        Message message = null;
        try {
            this.lock.writeLock().lock();
            message = (Message)this.incomingMessages.poll(0L, TimeUnit.MILLISECONDS);
            if (message == null) {
                this.pendingReceives.add(result);
                cancellationHandler.setCancelAction(() -> this.pendingReceives.remove(result));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            result.completeExceptionally(e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (message != null) {
            this.messageProcessed(message);
            result.complete(this.beforeConsume(message));
        }
        return result;
    }

    @Override
    protected Message<T> internalReceive(int timeout, TimeUnit unit) throws PulsarClientException {
        try {
            Message message = (Message)this.incomingMessages.poll(timeout, unit);
            if (message == null) {
                return null;
            }
            this.messageProcessed(message);
            return this.beforeConsume(message);
        }
        catch (InterruptedException e) {
            HandlerState.State state = this.getState();
            if (state != HandlerState.State.Closing && state != HandlerState.State.Closed) {
                this.stats.incrementNumReceiveFailed();
                throw PulsarClientException.unwrap((Throwable)e);
            }
            return null;
        }
    }

    @Override
    protected Messages<T> internalBatchReceive() throws PulsarClientException {
        try {
            return this.internalBatchReceiveAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            HandlerState.State state = this.getState();
            if (state != HandlerState.State.Closing && state != HandlerState.State.Closed) {
                this.stats.incrementNumBatchReceiveFailed();
                throw PulsarClientException.unwrap((Throwable)e);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CompletableFuture<Messages<T>> internalBatchReceiveAsync() {
        CompletableFutureCancellationHandler cancellationHandler = new CompletableFutureCancellationHandler();
        CompletableFuture result = cancellationHandler.createFuture();
        try {
            this.lock.writeLock().lock();
            if (this.pendingBatchReceives == null) {
                this.pendingBatchReceives = Queues.newConcurrentLinkedQueue();
            }
            if (this.hasEnoughMessagesForBatchReceive()) {
                MessagesImpl messages = this.getNewMessagesImpl();
                Message msgPeeked = (Message)this.incomingMessages.peek();
                while (msgPeeked != null && messages.canAdd(msgPeeked)) {
                    Message msg = (Message)this.incomingMessages.poll();
                    if (msg != null) {
                        this.messageProcessed(msg);
                        Message interceptMsg = this.beforeConsume(msg);
                        messages.add(interceptMsg);
                    }
                    msgPeeked = (Message)this.incomingMessages.peek();
                }
                result.complete(messages);
            } else {
                ConsumerBase.OpBatchReceive opBatchReceive = ConsumerBase.OpBatchReceive.of(result);
                this.pendingBatchReceives.add(opBatchReceive);
                cancellationHandler.setCancelAction(() -> this.pendingBatchReceives.remove(opBatchReceive));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return result;
    }

    boolean markAckForBatchMessage(BatchMessageIdImpl batchMessageId, PulsarApi.CommandAck.AckType ackType, Map<String, Long> properties) {
        boolean isAllMsgsAcked = ackType == PulsarApi.CommandAck.AckType.Individual ? batchMessageId.ackIndividual() : batchMessageId.ackCumulative();
        int outstandingAcks = 0;
        if (log.isDebugEnabled()) {
            outstandingAcks = batchMessageId.getOutstandingAcksInSameBatch();
        }
        int batchSize = batchMessageId.getBatchSize();
        if (isAllMsgsAcked) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] can ack message to broker {}, acktype {}, cardinality {}, length {}", new Object[]{this.subscription, this.consumerName, batchMessageId, ackType, outstandingAcks, batchSize});
            }
            return true;
        }
        if (PulsarApi.CommandAck.AckType.Cumulative == ackType && !batchMessageId.getAcker().isPrevBatchCumulativelyAcked()) {
            this.sendAcknowledge(batchMessageId.prevBatchMessageId(), PulsarApi.CommandAck.AckType.Cumulative, properties, null);
            batchMessageId.getAcker().setPrevBatchCumulativelyAcked(true);
        } else {
            this.onAcknowledge(batchMessageId, null);
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] [{}] cannot ack message to broker {}, acktype {}, pending acks - {}", new Object[]{this.subscription, this.consumerName, batchMessageId, ackType, outstandingAcks});
        }
        return false;
    }

    @Override
    protected CompletableFuture<Void> doAcknowledge(MessageId messageId, PulsarApi.CommandAck.AckType ackType, Map<String, Long> properties, TransactionImpl txnImpl) {
        Preconditions.checkArgument(messageId instanceof MessageIdImpl);
        if (this.getState() != HandlerState.State.Ready && this.getState() != HandlerState.State.Connecting) {
            this.stats.incrementNumAcksFailed();
            PulsarClientException exception = new PulsarClientException("Consumer not ready. State: " + (Object)((Object)this.getState()));
            if (PulsarApi.CommandAck.AckType.Individual.equals((Object)ackType)) {
                this.onAcknowledge(messageId, exception);
            } else if (PulsarApi.CommandAck.AckType.Cumulative.equals((Object)ackType)) {
                this.onAcknowledgeCumulative(messageId, exception);
            }
            return FutureUtil.failedFuture(exception);
        }
        if (messageId instanceof BatchMessageIdImpl) {
            if (this.markAckForBatchMessage((BatchMessageIdImpl)messageId, ackType, properties)) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] [{}] acknowledging message - {}, acktype {}", new Object[]{this.subscription, this.consumerName, messageId, ackType});
                }
            } else {
                if (this.conf.isBatchIndexAckEnabled()) {
                    BatchMessageIdImpl batchMessageId = (BatchMessageIdImpl)messageId;
                    this.acknowledgmentsGroupingTracker.addBatchIndexAcknowledgment(batchMessageId, batchMessageId.getBatchIndex(), batchMessageId.getBatchSize(), ackType, properties);
                }
                return CompletableFuture.completedFuture(null);
            }
        }
        return this.sendAcknowledge(messageId, ackType, properties, txnImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CompletableFuture<Void> doReconsumeLater(Message<?> message, PulsarApi.CommandAck.AckType ackType, Map<String, Long> properties, long delayTime, TimeUnit unit) {
        block35: {
            MessageId messageId = message.getMessageId();
            if (messageId instanceof TopicMessageIdImpl) {
                messageId = ((TopicMessageIdImpl)messageId).getInnerMessageId();
            }
            Preconditions.checkArgument(messageId instanceof MessageIdImpl);
            if (this.getState() != HandlerState.State.Ready && this.getState() != HandlerState.State.Connecting) {
                this.stats.incrementNumAcksFailed();
                PulsarClientException exception = new PulsarClientException("Consumer not ready. State: " + (Object)((Object)this.getState()));
                if (PulsarApi.CommandAck.AckType.Individual.equals((Object)ackType)) {
                    this.onAcknowledge(messageId, exception);
                } else if (PulsarApi.CommandAck.AckType.Cumulative.equals((Object)ackType)) {
                    this.onAcknowledgeCumulative(messageId, exception);
                }
                return FutureUtil.failedFuture(exception);
            }
            if (delayTime < 0L) {
                delayTime = 0L;
            }
            if (this.retryLetterProducer == null) {
                try {
                    this.createProducerLock.writeLock().lock();
                    if (this.retryLetterProducer == null) {
                        this.retryLetterProducer = this.client.newProducer(this.schema).topic(this.deadLetterPolicy.getRetryLetterTopic()).enableBatching(false).blockIfQueueFull(false).create();
                    }
                }
                catch (Exception e) {
                    log.error("Create retry letter producer exception with topic: {}", (Object)this.deadLetterPolicy.getRetryLetterTopic(), (Object)e);
                }
                finally {
                    this.createProducerLock.writeLock().unlock();
                }
            }
            if (this.retryLetterProducer != null) {
                try {
                    MessageImpl retryMessage = null;
                    String originMessageIdStr = null;
                    String originTopicNameStr = null;
                    if (message instanceof TopicMessageImpl) {
                        retryMessage = (MessageImpl)((TopicMessageImpl)message).getMessage();
                        originMessageIdStr = ((TopicMessageIdImpl)message.getMessageId()).getInnerMessageId().toString();
                        originTopicNameStr = ((TopicMessageIdImpl)message.getMessageId()).getTopicName();
                    } else if (message instanceof MessageImpl) {
                        retryMessage = (MessageImpl)message;
                        originMessageIdStr = ((MessageImpl)message).getMessageId().toString();
                        originTopicNameStr = ((MessageImpl)message).getTopicName();
                    }
                    TreeMap<String, String> propertiesMap = new TreeMap<String, String>();
                    int reconsumetimes = 1;
                    if (message.getProperties() != null) {
                        propertiesMap.putAll(message.getProperties());
                    }
                    if (propertiesMap.containsKey("RECONSUMETIMES")) {
                        reconsumetimes = Integer.valueOf((String)propertiesMap.get("RECONSUMETIMES"));
                        ++reconsumetimes;
                    } else {
                        propertiesMap.put("REAL_TOPIC", originTopicNameStr);
                        propertiesMap.put("ORIGIN_MESSAGE_IDY_TIME", originMessageIdStr);
                    }
                    propertiesMap.put("RECONSUMETIMES", String.valueOf(reconsumetimes));
                    propertiesMap.put("DELAY_TIME", String.valueOf(unit.toMillis(delayTime)));
                    if (reconsumetimes > this.deadLetterPolicy.getMaxRedeliverCount()) {
                        this.processPossibleToDLQ((MessageIdImpl)messageId);
                        if (this.deadLetterProducer == null) {
                            try {
                                if (this.deadLetterProducer == null) {
                                    this.createProducerLock.writeLock().lock();
                                    this.deadLetterProducer = this.client.newProducer(this.schema).topic(this.deadLetterPolicy.getDeadLetterTopic()).blockIfQueueFull(false).create();
                                }
                            }
                            catch (Exception e) {
                                log.error("Create dead letter producer exception with topic: {}", (Object)this.deadLetterPolicy.getDeadLetterTopic(), (Object)e);
                            }
                            finally {
                                this.createProducerLock.writeLock().unlock();
                            }
                        }
                        if (this.deadLetterProducer != null) {
                            propertiesMap.put("REAL_TOPIC", originTopicNameStr);
                            propertiesMap.put("ORIGIN_MESSAGE_IDY_TIME", originMessageIdStr);
                            TypedMessageBuilder typedMessageBuilderNew = this.deadLetterProducer.newMessage().value(retryMessage.getValue()).properties(propertiesMap);
                            typedMessageBuilderNew.send();
                            return this.doAcknowledge(messageId, ackType, properties, null);
                        }
                        break block35;
                    }
                    TypedMessageBuilder typedMessageBuilderNew = this.retryLetterProducer.newMessage().value(retryMessage.getValue()).properties(propertiesMap);
                    if (delayTime > 0L) {
                        typedMessageBuilderNew.deliverAfter(delayTime, unit);
                    }
                    if (message.hasKey()) {
                        typedMessageBuilderNew.key(message.getKey());
                    }
                    typedMessageBuilderNew.send();
                    return this.doAcknowledge(messageId, ackType, properties, null);
                }
                catch (Exception e) {
                    log.error("Send to retry letter topic exception with topic: {}, messageId: {}", new Object[]{this.deadLetterProducer.getTopic(), messageId, e});
                    HashSet<MessageId> messageIds = new HashSet<MessageId>();
                    messageIds.add(messageId);
                    this.unAckedMessageTracker.remove(messageId);
                    this.redeliverUnacknowledgedMessages(messageIds);
                }
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<Void> sendAcknowledge(MessageId messageId, PulsarApi.CommandAck.AckType ackType, Map<String, Long> properties, TransactionImpl txnImpl) {
        MessageIdImpl msgId = (MessageIdImpl)messageId;
        if (ackType == PulsarApi.CommandAck.AckType.Individual) {
            if (messageId instanceof BatchMessageIdImpl) {
                BatchMessageIdImpl batchMessageId = (BatchMessageIdImpl)messageId;
                this.stats.incrementNumAcksSent(batchMessageId.getBatchSize());
                this.unAckedMessageTracker.remove(new MessageIdImpl(batchMessageId.getLedgerId(), batchMessageId.getEntryId(), batchMessageId.getPartitionIndex()));
                if (this.possibleSendToDeadLetterTopicMessages != null) {
                    this.possibleSendToDeadLetterTopicMessages.remove(new MessageIdImpl(batchMessageId.getLedgerId(), batchMessageId.getEntryId(), batchMessageId.getPartitionIndex()));
                }
            } else {
                this.unAckedMessageTracker.remove(msgId);
                if (this.possibleSendToDeadLetterTopicMessages != null) {
                    this.possibleSendToDeadLetterTopicMessages.remove(msgId);
                }
                this.stats.incrementNumAcksSent(1L);
            }
            this.onAcknowledge(messageId, null);
        } else if (ackType == PulsarApi.CommandAck.AckType.Cumulative) {
            this.onAcknowledgeCumulative(messageId, null);
            this.stats.incrementNumAcksSent(this.unAckedMessageTracker.removeMessagesTill(msgId));
        }
        this.acknowledgmentsGroupingTracker.addAcknowledgment(msgId, ackType, properties);
        return CompletableFuture.completedFuture(null);
    }

    public void negativeAcknowledge(MessageId messageId) {
        this.negativeAcksTracker.add(messageId);
        this.unAckedMessageTracker.remove(messageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionOpened(ClientCnx cnx) {
        int currentSize;
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            this.setState(HandlerState.State.Closed);
            this.closeConsumerTasks();
            this.deregisterFromClientCnx();
            this.client.cleanupConsumer(this);
            this.failPendingReceive();
            this.clearReceiverQueue();
            return;
        }
        this.setClientCnx(cnx);
        log.info("[{}][{}] Subscribing to topic on cnx {}", new Object[]{this.topic, this.subscription, cnx.ctx().channel()});
        long requestId = this.client.newRequestId();
        ConsumerImpl consumerImpl = this;
        synchronized (consumerImpl) {
            currentSize = this.incomingMessages.size();
            this.startMessageId = this.clearReceiverQueue();
            if (this.possibleSendToDeadLetterTopicMessages != null) {
                this.possibleSendToDeadLetterTopicMessages.clear();
            }
        }
        boolean isDurable = this.subscriptionMode == SubscriptionMode.Durable;
        PulsarApi.MessageIdData startMessageIdData = null;
        if (isDurable) {
            startMessageIdData = null;
        } else if (this.startMessageId != null) {
            PulsarApi.MessageIdData.Builder builder = PulsarApi.MessageIdData.newBuilder();
            builder.setLedgerId(this.startMessageId.getLedgerId());
            builder.setEntryId(this.startMessageId.getEntryId());
            if (this.startMessageId instanceof BatchMessageIdImpl) {
                builder.setBatchIndex(this.startMessageId.getBatchIndex());
            }
            startMessageIdData = builder.build();
            builder.recycle();
        }
        SchemaInfo si = this.schema.getSchemaInfo();
        if (si != null && (SchemaType.BYTES == si.getType() || SchemaType.NONE == si.getType())) {
            si = null;
        }
        long startMessageRollbackDuration = this.startMessageRollbackDurationInSec > 0L && this.startMessageId != null && this.startMessageId.equals(this.initialStartMessageId) ? this.startMessageRollbackDurationInSec : 0L;
        ByteBuf request = Commands.newSubscribe(this.topic, this.subscription, this.consumerId, requestId, this.getSubType(), this.priorityLevel, this.consumerName, isDurable, startMessageIdData, this.metadata, this.readCompacted, this.conf.isReplicateSubscriptionState(), PulsarApi.CommandSubscribe.InitialPosition.valueOf(this.subscriptionInitialPosition.getValue()), startMessageRollbackDuration, si, this.createTopicIfDoesNotExist, this.conf.getKeySharedPolicy());
        if (startMessageIdData != null) {
            startMessageIdData.recycle();
        }
        ((CompletableFuture)cnx.sendRequestWithId(request, requestId).thenRun(() -> {
            ConsumerImpl consumerImpl = this;
            synchronized (consumerImpl) {
                if (!this.changeToReadyState()) {
                    this.setState(HandlerState.State.Closed);
                    this.deregisterFromClientCnx();
                    this.client.cleanupConsumer(this);
                    cnx.channel().close();
                    return;
                }
                this.consumerIsReconnectedToBroker(cnx, currentSize);
            }
            this.resetBackoff();
            boolean firstTimeConnect = this.subscribeFuture.complete(this);
            if (!(firstTimeConnect && this.hasParentConsumer && isDurable || this.conf.getReceiverQueueSize() == 0)) {
                this.increaseAvailablePermits(cnx, this.conf.getReceiverQueueSize());
            }
        })).exceptionally(e -> {
            this.deregisterFromClientCnx();
            if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
                cnx.channel().close();
                return null;
            }
            log.warn("[{}][{}] Failed to subscribe to topic on {}", new Object[]{this.topic, this.subscription, cnx.channel().remoteAddress()});
            if (e.getCause() instanceof PulsarClientException && PulsarClientException.isRetriableError((Throwable)e.getCause()) && System.currentTimeMillis() < this.subscribeTimeout) {
                this.reconnectLater(e.getCause());
            } else if (!this.subscribeFuture.isDone()) {
                this.setState(HandlerState.State.Failed);
                this.closeConsumerTasks();
                this.subscribeFuture.completeExceptionally(PulsarClientException.wrap((Throwable)e, (String)String.format("Failed to subscribe the topic %s with subscription name %s when connecting to the broker", this.topicName.toString(), this.subscription)));
                this.client.cleanupConsumer(this);
            } else if (e.getCause() instanceof PulsarClientException.TopicDoesNotExistException) {
                this.setState(HandlerState.State.Failed);
                this.closeConsumerTasks();
                this.client.cleanupConsumer(this);
                log.warn("[{}][{}] Closed consumer because topic does not exist anymore {}", new Object[]{this.topic, this.subscription, cnx.channel().remoteAddress()});
            } else {
                this.reconnectLater(e.getCause());
            }
            return null;
        });
    }

    protected void consumerIsReconnectedToBroker(ClientCnx cnx, int currentQueueSize) {
        log.info("[{}][{}] Subscribed to topic on {} -- consumer: {}", new Object[]{this.topic, this.subscription, cnx.channel().remoteAddress(), this.consumerId});
        AVAILABLE_PERMITS_UPDATER.set(this, 0);
    }

    private BatchMessageIdImpl clearReceiverQueue() {
        ArrayList currentMessageQueue = new ArrayList(this.incomingMessages.size());
        this.incomingMessages.drainTo(currentMessageQueue);
        INCOMING_MESSAGES_SIZE_UPDATER.set(this, 0L);
        if (this.duringSeek.compareAndSet(true, false)) {
            return this.seekMessageId;
        }
        if (this.subscriptionMode == SubscriptionMode.Durable) {
            return this.startMessageId;
        }
        if (!currentMessageQueue.isEmpty()) {
            MessageIdImpl nextMessageInQueue = (MessageIdImpl)((Message)currentMessageQueue.get(0)).getMessageId();
            BatchMessageIdImpl previousMessage = nextMessageInQueue instanceof BatchMessageIdImpl ? new BatchMessageIdImpl(nextMessageInQueue.getLedgerId(), nextMessageInQueue.getEntryId(), nextMessageInQueue.getPartitionIndex(), ((BatchMessageIdImpl)nextMessageInQueue).getBatchIndex() - 1) : new BatchMessageIdImpl(nextMessageInQueue.getLedgerId(), nextMessageInQueue.getEntryId() - 1L, nextMessageInQueue.getPartitionIndex(), -1);
            return previousMessage;
        }
        if (!this.lastDequeuedMessageId.equals(MessageId.earliest)) {
            return new BatchMessageIdImpl((MessageIdImpl)this.lastDequeuedMessageId);
        }
        return this.startMessageId;
    }

    private void sendFlowPermitsToBroker(ClientCnx cnx, int numMessages) {
        if (cnx != null) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] Adding {} additional permits", new Object[]{this.topic, this.subscription, numMessages});
            }
            cnx.ctx().writeAndFlush(Commands.newFlow(this.consumerId, numMessages), cnx.ctx().voidPromise());
        }
    }

    @Override
    public void connectionFailed(PulsarClientException exception) {
        boolean timeout;
        boolean nonRetriableError = !PulsarClientException.isRetriableError((Throwable)exception);
        boolean bl = timeout = System.currentTimeMillis() > this.subscribeTimeout;
        if ((nonRetriableError || timeout) && this.subscribeFuture.completeExceptionally(exception)) {
            this.setState(HandlerState.State.Failed);
            if (nonRetriableError) {
                log.info("[{}] Consumer creation failed for consumer {} with unretriableError {}", new Object[]{this.topic, this.consumerId, exception});
            } else {
                log.info("[{}] Consumer creation failed for consumer {} after timeout", (Object)this.topic, (Object)this.consumerId);
            }
            this.closeConsumerTasks();
            this.deregisterFromClientCnx();
            this.client.cleanupConsumer(this);
        }
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            this.closeConsumerTasks();
            return CompletableFuture.completedFuture(null);
        }
        if (!this.isConnected()) {
            log.info("[{}] [{}] Closed Consumer (not connected)", (Object)this.topic, (Object)this.subscription);
            this.setState(HandlerState.State.Closed);
            this.closeConsumerTasks();
            this.deregisterFromClientCnx();
            this.client.cleanupConsumer(this);
            return CompletableFuture.completedFuture(null);
        }
        this.stats.getStatTimeout().ifPresent(Timeout::cancel);
        this.setState(HandlerState.State.Closing);
        this.closeConsumerTasks();
        long requestId = this.client.newRequestId();
        CompletableFuture<Void> closeFuture = new CompletableFuture<Void>();
        ClientCnx cnx = this.cnx();
        if (null == cnx) {
            this.cleanupAtClose(closeFuture, null);
        } else {
            ByteBuf cmd = Commands.newCloseConsumer(this.consumerId, requestId);
            cnx.sendRequestWithId(cmd, requestId).handle((v, exception) -> {
                boolean ignoreException;
                boolean bl = ignoreException = !cnx.ctx().channel().isActive();
                if (ignoreException && exception != null) {
                    log.debug("Exception ignored in closing consumer", exception);
                }
                this.cleanupAtClose(closeFuture, ignoreException ? null : exception);
                return null;
            });
        }
        return closeFuture;
    }

    private void cleanupAtClose(CompletableFuture<Void> closeFuture, Throwable exception) {
        log.info("[{}] [{}] Closed consumer", (Object)this.topic, (Object)this.subscription);
        this.setState(HandlerState.State.Closed);
        this.closeConsumerTasks();
        if (exception != null) {
            closeFuture.completeExceptionally(exception);
        } else {
            closeFuture.complete(null);
        }
        this.deregisterFromClientCnx();
        this.client.cleanupConsumer(this);
        this.failPendingReceive();
    }

    private void closeConsumerTasks() {
        this.unAckedMessageTracker.close();
        if (this.possibleSendToDeadLetterTopicMessages != null) {
            this.possibleSendToDeadLetterTopicMessages.clear();
        }
        this.acknowledgmentsGroupingTracker.close();
        if (this.batchReceiveTimeout != null) {
            this.batchReceiveTimeout.cancel();
        }
        this.stats.getStatTimeout().ifPresent(Timeout::cancel);
    }

    private void failPendingReceive() {
        this.lock.readLock().lock();
        try {
            if (this.listenerExecutor != null && !this.listenerExecutor.isShutdown()) {
                this.failPendingReceives(this.pendingReceives);
                this.failPendingBatchReceives(this.pendingBatchReceives);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    void activeConsumerChanged(boolean isActive) {
        if (this.consumerEventListener == null) {
            return;
        }
        this.listenerExecutor.execute(() -> {
            if (isActive) {
                this.consumerEventListener.becameActive((Consumer)this, this.partitionIndex);
            } else {
                this.consumerEventListener.becameInactive((Consumer)this, this.partitionIndex);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void messageReceived(PulsarApi.MessageIdData messageId, int redeliveryCount, List<Long> ackSet, ByteBuf headersAndPayload, ClientCnx cnx) {
        if (ConsumerImpl.log.isDebugEnabled()) {
            ConsumerImpl.log.debug("[{}][{}] Received message: {}/{}", new Object[]{this.topic, this.subscription, messageId.getLedgerId(), messageId.getEntryId()});
        }
        if (!this.verifyChecksum(headersAndPayload, messageId)) {
            this.discardCorruptedMessage(messageId, cnx, PulsarApi.CommandAck.ValidationError.ChecksumMismatch);
            return;
        }
        try {
            msgMetadata = Commands.parseMessageMetadata(headersAndPayload);
        }
        catch (Throwable t) {
            this.discardCorruptedMessage(messageId, cnx, PulsarApi.CommandAck.ValidationError.ChecksumMismatch);
            return;
        }
        numMessages = msgMetadata.getNumMessagesInBatch();
        isChunkedMessage = msgMetadata.getNumChunksFromMsg() > 1 && this.conf.getSubscriptionType() != SubscriptionType.Shared;
        msgId = new MessageIdImpl(messageId.getLedgerId(), messageId.getEntryId(), this.getPartitionIndex());
        if (this.acknowledgmentsGroupingTracker.isDuplicate(msgId)) {
            if (ConsumerImpl.log.isDebugEnabled()) {
                ConsumerImpl.log.debug("[{}] [{}] Ignoring message as it was already being acked earlier by same consumer {}/{}", new Object[]{this.topic, this.subscription, this.consumerName, msgId});
            }
            this.increaseAvailablePermits(cnx, numMessages);
            return;
        }
        decryptedPayload = this.decryptPayloadIfNeeded(messageId, msgMetadata, headersAndPayload, cnx);
        isMessageUndecryptable = this.isMessageUndecryptable(msgMetadata);
        if (decryptedPayload == null) {
            return;
        }
        uncompressedPayload = isMessageUndecryptable != false || isChunkedMessage != false ? decryptedPayload.retain() : this.uncompressPayloadIfNeeded(messageId, msgMetadata, decryptedPayload, cnx, true);
        decryptedPayload.release();
        if (uncompressedPayload == null) {
            return;
        }
        if (isMessageUndecryptable || numMessages == 1 && !msgMetadata.hasNumMessagesInBatch()) {
            if (isChunkedMessage && (uncompressedPayload = this.processMessageChunk(uncompressedPayload, msgMetadata, msgId, messageId, cnx)) == null) {
                msgMetadata.recycle();
                return;
            }
            if (this.isSameEntry(messageId) && this.isPriorEntryIndex(messageId.getEntryId())) {
                if (ConsumerImpl.log.isDebugEnabled()) {
                    ConsumerImpl.log.debug("[{}] [{}] Ignoring message from before the startMessageId: {}", new Object[]{this.subscription, this.consumerName, this.startMessageId});
                }
                uncompressedPayload.release();
                msgMetadata.recycle();
                return;
            }
            message = new MessageImpl<T>(this.topicName.toString(), msgId, msgMetadata, uncompressedPayload, this.createEncryptionContext(msgMetadata), cnx, this.schema, redeliveryCount);
            uncompressedPayload.release();
            msgMetadata.recycle();
            this.lock.readLock().lock();
            try {
                if (this.deadLetterPolicy != null && this.possibleSendToDeadLetterTopicMessages != null && redeliveryCount >= this.deadLetterPolicy.getMaxRedeliverCount()) {
                    this.possibleSendToDeadLetterTopicMessages.put((MessageIdImpl)message.getMessageId(), Collections.singletonList(message));
                }
                if (this.peekPendingReceive() != null) {
                    this.notifyPendingReceivedCallback(message, null);
                }
                if (!this.enqueueMessageAndCheckBatchReceive(message) || !this.hasPendingBatchReceive()) ** GOTO lbl62
                this.notifyPendingBatchReceivedCallBack();
            }
            finally {
                this.lock.readLock().unlock();
            }
        } else {
            this.receiveIndividualMessagesFromBatch(msgMetadata, redeliveryCount, ackSet, uncompressedPayload, messageId, cnx);
            uncompressedPayload.release();
            msgMetadata.recycle();
        }
lbl62:
        // 4 sources

        if (this.listener != null) {
            this.triggerListener(numMessages);
        }
    }

    private ByteBuf processMessageChunk(ByteBuf compressedPayload, PulsarApi.MessageMetadata msgMetadata, MessageIdImpl msgId, PulsarApi.MessageIdData messageId, ClientCnx cnx) {
        ChunkedMessageCtx chunkedMsgCtx;
        if (!this.expireChunkMessageTaskScheduled && this.expireTimeOfIncompleteChunkedMessageMillis > 0L) {
            ((ScheduledExecutorService)this.listenerExecutor).scheduleAtFixedRate(() -> this.removeExpireIncompleteChunkedMessages(), this.expireTimeOfIncompleteChunkedMessageMillis, this.expireTimeOfIncompleteChunkedMessageMillis, TimeUnit.MILLISECONDS);
            this.expireChunkMessageTaskScheduled = true;
        }
        if (msgMetadata.getChunkId() == 0) {
            ByteBuf chunkedMsgBuffer = Unpooled.directBuffer(msgMetadata.getTotalChunkMsgSize(), msgMetadata.getTotalChunkMsgSize());
            int totalChunks = msgMetadata.getNumChunksFromMsg();
            this.chunkedMessagesMap.computeIfAbsent(msgMetadata.getUuid(), key -> ChunkedMessageCtx.get(totalChunks, chunkedMsgBuffer));
            ++this.pendingChunckedMessageCount;
            if (this.maxPendingChuckedMessage > 0 && this.pendingChunckedMessageCount > this.maxPendingChuckedMessage) {
                this.removeOldestPendingChunkedMessage();
            }
            this.pendingChunckedMessageUuidQueue.add(msgMetadata.getUuid());
        }
        if ((chunkedMsgCtx = this.chunkedMessagesMap.get(msgMetadata.getUuid())) == null || chunkedMsgCtx.chunkedMsgBuffer == null || msgMetadata.getChunkId() != chunkedMsgCtx.lastChunkedMessageId + 1 || msgMetadata.getChunkId() >= msgMetadata.getTotalChunkMsgSize()) {
            log.info("Received unexpected chunk messageId {}, last-chunk-id{}, chunkId = {}, total-chunks {}", new Object[]{msgId, chunkedMsgCtx != null ? Integer.valueOf(chunkedMsgCtx.lastChunkedMessageId) : null, msgMetadata.getChunkId(), msgMetadata.getTotalChunkMsgSize()});
            if (chunkedMsgCtx != null) {
                if (chunkedMsgCtx.chunkedMsgBuffer != null) {
                    ReferenceCountUtil.safeRelease(chunkedMsgCtx.chunkedMsgBuffer);
                }
                chunkedMsgCtx.recycle();
            }
            this.chunkedMessagesMap.remove(msgMetadata.getUuid());
            compressedPayload.release();
            this.increaseAvailablePermits(cnx);
            if (this.expireTimeOfIncompleteChunkedMessageMillis > 0L && System.currentTimeMillis() > msgMetadata.getPublishTime() + this.expireTimeOfIncompleteChunkedMessageMillis) {
                this.doAcknowledge(msgId, PulsarApi.CommandAck.AckType.Individual, Collections.emptyMap(), null);
            } else {
                this.trackMessage(msgId);
            }
            return null;
        }
        chunkedMsgCtx.chunkedMessageIds[msgMetadata.getChunkId()] = msgId;
        chunkedMsgCtx.chunkedMsgBuffer.writeBytes(compressedPayload);
        chunkedMsgCtx.lastChunkedMessageId = msgMetadata.getChunkId();
        if (msgMetadata.getChunkId() != msgMetadata.getNumChunksFromMsg() - 1) {
            compressedPayload.release();
            this.increaseAvailablePermits(cnx);
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Chunked message completed chunkId {}, total-chunks {}, msgId {} sequenceId {}", new Object[]{msgMetadata.getChunkId(), msgMetadata.getNumChunksFromMsg(), msgId, msgMetadata.getSequenceId()});
        }
        this.chunkedMessagesMap.remove(msgMetadata.getUuid());
        this.unAckedChunckedMessageIdSequenceMap.put(msgId, chunkedMsgCtx.chunkedMessageIds);
        --this.pendingChunckedMessageCount;
        compressedPayload.release();
        compressedPayload = chunkedMsgCtx.chunkedMsgBuffer;
        chunkedMsgCtx.recycle();
        ByteBuf uncompressedPayload = this.uncompressPayloadIfNeeded(messageId, msgMetadata, compressedPayload, cnx, false);
        compressedPayload.release();
        return uncompressedPayload;
    }

    protected void triggerListener(int numMessages) {
        this.listenerExecutor.execute(() -> {
            for (int i = 0; i < numMessages; ++i) {
                try {
                    Message<T> msg = this.internalReceive(0, TimeUnit.MILLISECONDS);
                    if (msg == null) {
                        if (!log.isDebugEnabled()) break;
                        log.debug("[{}] [{}] Message has been cleared from the queue", (Object)this.topic, (Object)this.subscription);
                        break;
                    }
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug("[{}][{}] Calling message listener for message {}", new Object[]{this.topic, this.subscription, msg.getMessageId()});
                        }
                        this.listener.received((Consumer)this, msg);
                    }
                    catch (Throwable t) {
                        log.error("[{}][{}] Message listener error in processing message: {}", new Object[]{this.topic, this.subscription, msg.getMessageId(), t});
                    }
                    continue;
                }
                catch (PulsarClientException e) {
                    log.warn("[{}] [{}] Failed to dequeue the message for listener", new Object[]{this.topic, this.subscription, e});
                    return;
                }
            }
        });
    }

    void notifyPendingReceivedCallback(Message<T> message, Exception exception) {
        if (this.pendingReceives.isEmpty()) {
            return;
        }
        CompletableFuture receivedFuture = this.pollPendingReceive();
        if (receivedFuture == null) {
            return;
        }
        if (exception != null) {
            this.listenerExecutor.execute(() -> receivedFuture.completeExceptionally(exception));
            return;
        }
        if (message == null) {
            IllegalStateException e = new IllegalStateException("received message can't be null");
            this.listenerExecutor.execute(() -> receivedFuture.completeExceptionally(e));
            return;
        }
        if (this.conf.getReceiverQueueSize() == 0) {
            this.trackMessage(message);
            this.interceptAndComplete(message, receivedFuture);
            return;
        }
        this.messageProcessed(message);
        this.interceptAndComplete(message, receivedFuture);
    }

    private void interceptAndComplete(Message<T> message, CompletableFuture<Message<T>> receivedFuture) {
        Message<T> interceptMessage = this.beforeConsume(message);
        this.completePendingReceive(receivedFuture, interceptMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveIndividualMessagesFromBatch(PulsarApi.MessageMetadata msgMetadata, int redeliveryCount, List<Long> ackSet, ByteBuf uncompressedPayload, PulsarApi.MessageIdData messageId, ClientCnx cnx) {
        int batchSize = msgMetadata.getNumMessagesInBatch();
        MessageIdImpl batchMessage = new MessageIdImpl(messageId.getLedgerId(), messageId.getEntryId(), this.getPartitionIndex());
        BatchMessageAcker acker = BatchMessageAcker.newAcker(batchSize);
        ArrayList possibleToDeadLetter = null;
        if (this.deadLetterPolicy != null && redeliveryCount >= this.deadLetterPolicy.getMaxRedeliverCount()) {
            possibleToDeadLetter = new ArrayList();
        }
        int skippedMessages = 0;
        BitSetRecyclable ackBitSet = null;
        if (ackSet != null && ackSet.size() > 0) {
            ackBitSet = BitSetRecyclable.valueOf(SafeCollectionUtils.longListToArray(ackSet));
        }
        try {
            for (int i = 0; i < batchSize; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] [{}] processing message num - {} in batch", new Object[]{this.subscription, this.consumerName, i});
                }
                PulsarApi.SingleMessageMetadata.Builder singleMessageMetadataBuilder = PulsarApi.SingleMessageMetadata.newBuilder();
                ByteBuf singleMessagePayload = Commands.deSerializeSingleMessageInBatch(uncompressedPayload, singleMessageMetadataBuilder, i, batchSize);
                if (this.isSameEntry(messageId) && this.isPriorBatchIndex(i)) {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] [{}] Ignoring message from before the startMessageId: {}", new Object[]{this.subscription, this.consumerName, this.startMessageId});
                    }
                    singleMessagePayload.release();
                    singleMessageMetadataBuilder.recycle();
                    ++skippedMessages;
                    continue;
                }
                if (singleMessageMetadataBuilder.getCompactedOut()) {
                    singleMessagePayload.release();
                    singleMessageMetadataBuilder.recycle();
                    ++skippedMessages;
                    continue;
                }
                if (ackBitSet != null && !ackBitSet.get(i)) {
                    singleMessagePayload.release();
                    singleMessageMetadataBuilder.recycle();
                    ++skippedMessages;
                    continue;
                }
                BatchMessageIdImpl batchMessageIdImpl = new BatchMessageIdImpl(messageId.getLedgerId(), messageId.getEntryId(), this.getPartitionIndex(), i, batchSize, acker);
                MessageImpl message = new MessageImpl(this.topicName.toString(), batchMessageIdImpl, msgMetadata, singleMessageMetadataBuilder.build(), singleMessagePayload, this.createEncryptionContext(msgMetadata), cnx, this.schema, redeliveryCount);
                if (possibleToDeadLetter != null) {
                    possibleToDeadLetter.add(message);
                }
                this.lock.readLock().lock();
                try {
                    if (this.peekPendingReceive() != null) {
                        this.notifyPendingReceivedCallback(message, null);
                    } else if (this.enqueueMessageAndCheckBatchReceive(message) && this.hasPendingBatchReceive()) {
                        this.notifyPendingBatchReceivedCallBack();
                    }
                }
                finally {
                    this.lock.readLock().unlock();
                }
                singleMessagePayload.release();
                singleMessageMetadataBuilder.recycle();
            }
            if (ackBitSet != null) {
                ackBitSet.recycle();
            }
        }
        catch (IOException e) {
            log.warn("[{}] [{}] unable to obtain message in batch", (Object)this.subscription, (Object)this.consumerName);
            this.discardCorruptedMessage(messageId, cnx, PulsarApi.CommandAck.ValidationError.BatchDeSerializeError);
        }
        if (possibleToDeadLetter != null && this.possibleSendToDeadLetterTopicMessages != null) {
            this.possibleSendToDeadLetterTopicMessages.put(batchMessage, possibleToDeadLetter);
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] [{}] enqueued messages in batch. queue size - {}, available queue size - {}", new Object[]{this.subscription, this.consumerName, this.incomingMessages.size(), this.incomingMessages.remainingCapacity()});
        }
        if (skippedMessages > 0) {
            this.increaseAvailablePermits(cnx, skippedMessages);
        }
    }

    private boolean isPriorEntryIndex(long idx) {
        return this.resetIncludeHead ? idx < this.startMessageId.getEntryId() : idx <= this.startMessageId.getEntryId();
    }

    private boolean isPriorBatchIndex(long idx) {
        return this.resetIncludeHead ? idx < (long)this.startMessageId.getBatchIndex() : idx <= (long)this.startMessageId.getBatchIndex();
    }

    private boolean isSameEntry(PulsarApi.MessageIdData messageId) {
        return this.startMessageId != null && messageId.getLedgerId() == this.startMessageId.getLedgerId() && messageId.getEntryId() == this.startMessageId.getEntryId();
    }

    @Override
    protected synchronized void messageProcessed(Message<?> msg) {
        ClientCnx currentCnx = this.cnx();
        ClientCnx msgCnx = ((MessageImpl)msg).getCnx();
        this.lastDequeuedMessageId = msg.getMessageId();
        if (msgCnx != currentCnx) {
            return;
        }
        this.increaseAvailablePermits(currentCnx);
        this.stats.updateNumMsgsReceived(msg);
        this.trackMessage(msg);
        INCOMING_MESSAGES_SIZE_UPDATER.addAndGet(this, msg.getData() == null ? 0L : (long)(-msg.getData().length));
    }

    protected void trackMessage(Message<?> msg) {
        if (msg != null) {
            this.trackMessage(msg.getMessageId());
        }
    }

    protected void trackMessage(MessageId messageId) {
        if (this.conf.getAckTimeoutMillis() > 0L && messageId instanceof MessageIdImpl) {
            MessageIdImpl id = (MessageIdImpl)messageId;
            if (id instanceof BatchMessageIdImpl) {
                id = new MessageIdImpl(id.getLedgerId(), id.getEntryId(), this.getPartitionIndex());
            }
            if (this.hasParentConsumer) {
                this.unAckedMessageTracker.remove(id);
            } else {
                this.unAckedMessageTracker.add(id);
            }
        }
    }

    void increaseAvailablePermits(ClientCnx currentCnx) {
        this.increaseAvailablePermits(currentCnx, 1);
    }

    protected void increaseAvailablePermits(ClientCnx currentCnx, int delta) {
        int available = AVAILABLE_PERMITS_UPDATER.addAndGet(this, delta);
        while (available >= this.receiverQueueRefillThreshold && !this.paused) {
            if (AVAILABLE_PERMITS_UPDATER.compareAndSet(this, available, 0)) {
                this.sendFlowPermitsToBroker(currentCnx, available);
                break;
            }
            available = AVAILABLE_PERMITS_UPDATER.get(this);
        }
    }

    public void pause() {
        this.paused = true;
    }

    public void resume() {
        if (this.paused) {
            this.paused = false;
            this.increaseAvailablePermits(this.cnx(), 0);
        }
    }

    private ByteBuf decryptPayloadIfNeeded(PulsarApi.MessageIdData messageId, PulsarApi.MessageMetadata msgMetadata, ByteBuf payload, ClientCnx currentCnx) {
        ByteBuf decryptedData;
        if (msgMetadata.getEncryptionKeysCount() == 0) {
            return payload.retain();
        }
        if (this.conf.getCryptoKeyReader() == null) {
            switch (this.conf.getCryptoFailureAction()) {
                case CONSUME: {
                    log.warn("[{}][{}][{}] CryptoKeyReader interface is not implemented. Consuming encrypted message.", new Object[]{this.topic, this.subscription, this.consumerName});
                    return payload.retain();
                }
                case DISCARD: {
                    log.warn("[{}][{}][{}] Skipping decryption since CryptoKeyReader interface is not implemented and config is set to discard", new Object[]{this.topic, this.subscription, this.consumerName});
                    this.discardMessage(messageId, currentCnx, PulsarApi.CommandAck.ValidationError.DecryptionError);
                    return null;
                }
                case FAIL: {
                    MessageIdImpl m = new MessageIdImpl(messageId.getLedgerId(), messageId.getEntryId(), this.partitionIndex);
                    log.error("[{}][{}][{}][{}] Message delivery failed since CryptoKeyReader interface is not implemented to consume encrypted message", new Object[]{this.topic, this.subscription, this.consumerName, m});
                    this.unAckedMessageTracker.add(m);
                    return null;
                }
            }
        }
        if ((decryptedData = this.msgCrypto.decrypt(() -> msgMetadata, payload, this.conf.getCryptoKeyReader())) != null) {
            return decryptedData;
        }
        switch (this.conf.getCryptoFailureAction()) {
            case CONSUME: {
                log.warn("[{}][{}][{}][{}] Decryption failed. Consuming encrypted message since config is set to consume.", new Object[]{this.topic, this.subscription, this.consumerName, messageId});
                return payload.retain();
            }
            case DISCARD: {
                log.warn("[{}][{}][{}][{}] Discarding message since decryption failed and config is set to discard", new Object[]{this.topic, this.subscription, this.consumerName, messageId});
                this.discardMessage(messageId, currentCnx, PulsarApi.CommandAck.ValidationError.DecryptionError);
                return null;
            }
            case FAIL: {
                MessageIdImpl m = new MessageIdImpl(messageId.getLedgerId(), messageId.getEntryId(), this.partitionIndex);
                log.error("[{}][{}][{}][{}] Message delivery failed since unable to decrypt incoming message", new Object[]{this.topic, this.subscription, this.consumerName, m});
                this.unAckedMessageTracker.add(m);
                return null;
            }
        }
        return null;
    }

    private ByteBuf uncompressPayloadIfNeeded(PulsarApi.MessageIdData messageId, PulsarApi.MessageMetadata msgMetadata, ByteBuf payload, ClientCnx currentCnx, boolean checkMaxMessageSize) {
        PulsarApi.CompressionType compressionType = msgMetadata.getCompression();
        CompressionCodec codec = CompressionCodecProvider.getCompressionCodec(compressionType);
        int uncompressedSize = msgMetadata.getUncompressedSize();
        int payloadSize = payload.readableBytes();
        if (checkMaxMessageSize && payloadSize > ClientCnx.getMaxMessageSize()) {
            log.error("[{}][{}] Got corrupted payload message size {} at {}", new Object[]{this.topic, this.subscription, payloadSize, messageId});
            this.discardCorruptedMessage(messageId, currentCnx, PulsarApi.CommandAck.ValidationError.UncompressedSizeCorruption);
            return null;
        }
        try {
            ByteBuf uncompressedPayload = codec.decode(payload, uncompressedSize);
            return uncompressedPayload;
        }
        catch (IOException e) {
            log.error("[{}][{}] Failed to decompress message with {} at {}: {}", new Object[]{this.topic, this.subscription, compressionType, messageId, e.getMessage(), e});
            this.discardCorruptedMessage(messageId, currentCnx, PulsarApi.CommandAck.ValidationError.DecompressionError);
            return null;
        }
    }

    private boolean verifyChecksum(ByteBuf headersAndPayload, PulsarApi.MessageIdData messageId) {
        int computedChecksum;
        int checksum;
        if (Commands.hasChecksum(headersAndPayload) && (checksum = Commands.readChecksum(headersAndPayload)) != (computedChecksum = Crc32cIntChecksum.computeChecksum(headersAndPayload))) {
            log.error("[{}][{}] Checksum mismatch for message at {}:{}. Received checksum: 0x{}, Computed checksum: 0x{}", new Object[]{this.topic, this.subscription, messageId.getLedgerId(), messageId.getEntryId(), Long.toHexString(checksum), Integer.toHexString(computedChecksum)});
            return false;
        }
        return true;
    }

    private void discardCorruptedMessage(PulsarApi.MessageIdData messageId, ClientCnx currentCnx, PulsarApi.CommandAck.ValidationError validationError) {
        log.error("[{}][{}] Discarding corrupted message at {}:{}", new Object[]{this.topic, this.subscription, messageId.getLedgerId(), messageId.getEntryId()});
        this.discardMessage(messageId, currentCnx, validationError);
    }

    private void discardMessage(PulsarApi.MessageIdData messageId, ClientCnx currentCnx, PulsarApi.CommandAck.ValidationError validationError) {
        ByteBuf cmd = Commands.newAck(this.consumerId, messageId.getLedgerId(), messageId.getEntryId(), null, PulsarApi.CommandAck.AckType.Individual, validationError, Collections.emptyMap());
        currentCnx.ctx().writeAndFlush(cmd, currentCnx.ctx().voidPromise());
        this.increaseAvailablePermits(currentCnx);
        this.stats.incrementNumReceiveFailed();
    }

    @Override
    String getHandlerName() {
        return this.subscription;
    }

    public boolean isConnected() {
        return this.getClientCnx() != null && this.getState() == HandlerState.State.Ready;
    }

    int getPartitionIndex() {
        return this.partitionIndex;
    }

    @Override
    public int getAvailablePermits() {
        return AVAILABLE_PERMITS_UPDATER.get(this);
    }

    @Override
    public int numMessagesInQueue() {
        return this.incomingMessages.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redeliverUnacknowledgedMessages() {
        ClientCnx cnx = this.cnx();
        if (this.isConnected() && cnx.getRemoteEndpointProtocolVersion() >= PulsarApi.ProtocolVersion.v2.getNumber()) {
            int currentSize = 0;
            ConsumerImpl consumerImpl = this;
            synchronized (consumerImpl) {
                currentSize = this.incomingMessages.size();
                this.incomingMessages.clear();
                INCOMING_MESSAGES_SIZE_UPDATER.set(this, 0L);
                this.unAckedMessageTracker.clear();
            }
            cnx.ctx().writeAndFlush(Commands.newRedeliverUnacknowledgedMessages(this.consumerId), cnx.ctx().voidPromise());
            if (currentSize > 0) {
                this.increaseAvailablePermits(cnx, currentSize);
            }
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] [{}] Redeliver unacked messages and send {} permits", new Object[]{this.subscription, this.topic, this.consumerName, currentSize});
            }
            return;
        }
        if (cnx == null || this.getState() == HandlerState.State.Connecting) {
            log.warn("[{}] Client Connection needs to be established for redelivery of unacknowledged messages", (Object)this);
        } else {
            log.warn("[{}] Reconnecting the client to redeliver the messages.", (Object)this);
            cnx.ctx().close();
        }
    }

    @Override
    public void redeliverUnacknowledgedMessages(Set<MessageId> messageIds) {
        if (messageIds.isEmpty()) {
            return;
        }
        Preconditions.checkArgument(messageIds.stream().findFirst().get() instanceof MessageIdImpl);
        if (this.conf.getSubscriptionType() != SubscriptionType.Shared && this.conf.getSubscriptionType() != SubscriptionType.Key_Shared) {
            this.redeliverUnacknowledgedMessages();
            return;
        }
        ClientCnx cnx = this.cnx();
        if (this.isConnected() && cnx.getRemoteEndpointProtocolVersion() >= PulsarApi.ProtocolVersion.v2.getNumber()) {
            int messagesFromQueue = this.removeExpiredMessagesFromQueue(messageIds);
            Iterable<List<List>> batches = Iterables.partition(messageIds.stream().map(messageId -> (MessageIdImpl)messageId).collect(Collectors.toSet()), 1000);
            PulsarApi.MessageIdData.Builder builder = PulsarApi.MessageIdData.newBuilder();
            batches.forEach(ids -> {
                List<PulsarApi.MessageIdData> messageIdDatas = ids.stream().filter(messageId -> !this.processPossibleToDLQ((MessageIdImpl)messageId)).map(messageId -> {
                    builder.setPartition(messageId.getPartitionIndex());
                    builder.setLedgerId(messageId.getLedgerId());
                    builder.setEntryId(messageId.getEntryId());
                    return builder.build();
                }).collect(Collectors.toList());
                if (!messageIdDatas.isEmpty()) {
                    ByteBuf cmd = Commands.newRedeliverUnacknowledgedMessages(this.consumerId, messageIdDatas);
                    cnx.ctx().writeAndFlush(cmd, cnx.ctx().voidPromise());
                    messageIdDatas.forEach(PulsarApi.MessageIdData::recycle);
                }
            });
            if (messagesFromQueue > 0) {
                this.increaseAvailablePermits(cnx, messagesFromQueue);
            }
            builder.recycle();
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] [{}] Redeliver unacked messages and increase {} permits", new Object[]{this.subscription, this.topic, this.consumerName, messagesFromQueue});
            }
            return;
        }
        if (cnx == null || this.getState() == HandlerState.State.Connecting) {
            log.warn("[{}] Client Connection needs to be established for redelivery of unacknowledged messages", (Object)this);
        } else {
            log.warn("[{}] Reconnecting the client to redeliver the messages.", (Object)this);
            cnx.ctx().close();
        }
    }

    @Override
    protected void completeOpBatchReceive(ConsumerBase.OpBatchReceive<T> op) {
        this.notifyPendingBatchReceivedCallBack(op);
    }

    private boolean processPossibleToDLQ(MessageIdImpl messageId) {
        List<MessageImpl<T>> deadLetterMessages = null;
        if (this.possibleSendToDeadLetterTopicMessages != null) {
            deadLetterMessages = messageId instanceof BatchMessageIdImpl ? this.possibleSendToDeadLetterTopicMessages.get(new MessageIdImpl(messageId.getLedgerId(), messageId.getEntryId(), this.getPartitionIndex())) : this.possibleSendToDeadLetterTopicMessages.get(messageId);
        }
        if (deadLetterMessages != null) {
            if (this.deadLetterProducer == null) {
                try {
                    this.deadLetterProducer = this.client.newProducer(this.schema).topic(this.deadLetterPolicy.getDeadLetterTopic()).blockIfQueueFull(false).create();
                }
                catch (Exception e) {
                    log.error("Create dead letter producer exception with topic: {}", (Object)this.deadLetterPolicy.getDeadLetterTopic(), (Object)e);
                }
            }
            if (this.deadLetterProducer != null) {
                try {
                    for (MessageImpl<T> message : deadLetterMessages) {
                        this.deadLetterProducer.newMessage().value(message.getValue()).properties(message.getProperties()).send();
                    }
                    this.acknowledge(messageId);
                    return true;
                }
                catch (Exception e) {
                    log.error("Send to dead letter topic exception with topic: {}, messageId: {}", new Object[]{this.deadLetterProducer.getTopic(), messageId, e});
                }
            }
        }
        return false;
    }

    public void seek(MessageId messageId) throws PulsarClientException {
        try {
            this.seekAsync(messageId).get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public void seek(long timestamp) throws PulsarClientException {
        try {
            this.seekAsync(timestamp).get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public CompletableFuture<Void> seekAsync(long timestamp) {
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException(String.format("The consumer %s was already closed when seeking the subscription %s of the topic %s to the timestamp %d", this.consumerName, this.subscription, this.topicName.toString(), timestamp)));
        }
        if (!this.isConnected()) {
            return FutureUtil.failedFuture(new PulsarClientException(String.format("The client is not connected to the broker when seeking the subscription %s of the topic %s to the timestamp %d", this.subscription, this.topicName.toString(), timestamp)));
        }
        CompletableFuture<Void> seekFuture = new CompletableFuture<Void>();
        long requestId = this.client.newRequestId();
        ByteBuf seek = Commands.newSeek(this.consumerId, requestId, timestamp);
        ClientCnx cnx = this.cnx();
        log.info("[{}][{}] Seek subscription to publish time {}", new Object[]{this.topic, this.subscription, timestamp});
        ((CompletableFuture)cnx.sendRequestWithId(seek, requestId).thenRun(() -> {
            log.info("[{}][{}] Successfully reset subscription to publish time {}", new Object[]{this.topic, this.subscription, timestamp});
            this.acknowledgmentsGroupingTracker.flushAndClean();
            this.seekMessageId = new BatchMessageIdImpl((MessageIdImpl)MessageId.earliest);
            this.duringSeek.set(true);
            this.lastDequeuedMessageId = MessageId.earliest;
            this.incomingMessages.clear();
            INCOMING_MESSAGES_SIZE_UPDATER.set(this, 0L);
            seekFuture.complete(null);
        })).exceptionally(e -> {
            log.error("[{}][{}] Failed to reset subscription: {}", new Object[]{this.topic, this.subscription, e.getCause().getMessage()});
            seekFuture.completeExceptionally(PulsarClientException.wrap((Throwable)e.getCause(), (String)String.format("Failed to seek the subscription %s of the topic %s to the timestamp %d", this.subscription, this.topicName.toString(), timestamp)));
            return null;
        });
        return seekFuture;
    }

    public CompletableFuture<Void> seekAsync(MessageId messageId) {
        MessageIdImpl msgId;
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException(String.format("The consumer %s was already closed when seeking the subscription %s of the topic %s to the message %s", this.consumerName, this.subscription, this.topicName.toString(), messageId.toString())));
        }
        if (!this.isConnected()) {
            return FutureUtil.failedFuture(new PulsarClientException(String.format("The client is not connected to the broker when seeking the subscription %s of the topic %s to the message %s", this.subscription, this.topicName.toString(), messageId.toString())));
        }
        CompletableFuture<Void> seekFuture = new CompletableFuture<Void>();
        long requestId = this.client.newRequestId();
        ByteBuf seek = null;
        if (messageId instanceof BatchMessageIdImpl) {
            msgId = (BatchMessageIdImpl)messageId;
            BitSetRecyclable ackSet = BitSetRecyclable.create();
            ackSet.set(0, ((BatchMessageIdImpl)msgId).getBatchSize());
            ackSet.clear(0, Math.max(((BatchMessageIdImpl)msgId).getBatchIndex(), 0));
            long[] ackSetArr = ackSet.toLongArray();
            ackSet.recycle();
            seek = Commands.newSeek(this.consumerId, requestId, msgId.getLedgerId(), msgId.getEntryId(), ackSetArr);
        } else {
            msgId = (MessageIdImpl)messageId;
            seek = Commands.newSeek(this.consumerId, requestId, msgId.getLedgerId(), msgId.getEntryId(), new long[0]);
        }
        ClientCnx cnx = this.cnx();
        log.info("[{}][{}] Seek subscription to message id {}", new Object[]{this.topic, this.subscription, messageId});
        ((CompletableFuture)cnx.sendRequestWithId(seek, requestId).thenRun(() -> {
            log.info("[{}][{}] Successfully reset subscription to message id {}", new Object[]{this.topic, this.subscription, messageId});
            this.acknowledgmentsGroupingTracker.flushAndClean();
            this.seekMessageId = new BatchMessageIdImpl((MessageIdImpl)messageId);
            this.duringSeek.set(true);
            this.lastDequeuedMessageId = MessageId.earliest;
            this.incomingMessages.clear();
            INCOMING_MESSAGES_SIZE_UPDATER.set(this, 0L);
            seekFuture.complete(null);
        })).exceptionally(e -> {
            log.error("[{}][{}] Failed to reset subscription: {}", new Object[]{this.topic, this.subscription, e.getCause().getMessage()});
            seekFuture.completeExceptionally(PulsarClientException.wrap((Throwable)e.getCause(), (String)String.format("Failed to seek the subscription %s of the topic %s to the message %s", this.subscription, this.topicName.toString(), messageId.toString())));
            return null;
        });
        return seekFuture;
    }

    public boolean hasMessageAvailable() throws PulsarClientException {
        try {
            return this.hasMessageAvailableAsync().get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public CompletableFuture<Boolean> hasMessageAvailableAsync() {
        CompletableFuture<Boolean> booleanFuture = new CompletableFuture<Boolean>();
        if (this.lastDequeuedMessageId == MessageId.earliest) {
            if (this.startMessageId.getLedgerId() == Long.MAX_VALUE && this.startMessageId.getEntryId() == Long.MAX_VALUE && this.startMessageId.partitionIndex == -1) {
                ((CompletableFuture)this.getLastMessageIdAsync().thenCompose(this::seekAsync)).whenComplete((ignore, e) -> {
                    if (e != null) {
                        log.error("[{}][{}] Failed getLastMessageId command", (Object)this.topic, (Object)this.subscription);
                        booleanFuture.completeExceptionally(e.getCause());
                    } else {
                        booleanFuture.complete(this.resetIncludeHead);
                    }
                });
                return booleanFuture;
            }
            if (this.hasMoreMessages(this.lastMessageIdInBroker, this.startMessageId, this.resetIncludeHead)) {
                booleanFuture.complete(true);
                return booleanFuture;
            }
            ((CompletableFuture)this.getLastMessageIdAsync().thenAccept(messageId -> {
                this.lastMessageIdInBroker = messageId;
                if (this.hasMoreMessages(this.lastMessageIdInBroker, this.startMessageId, this.resetIncludeHead)) {
                    booleanFuture.complete(true);
                } else {
                    booleanFuture.complete(false);
                }
            })).exceptionally(e -> {
                log.error("[{}][{}] Failed getLastMessageId command", (Object)this.topic, (Object)this.subscription);
                booleanFuture.completeExceptionally(e.getCause());
                return null;
            });
        } else {
            if (this.hasMoreMessages(this.lastMessageIdInBroker, this.lastDequeuedMessageId, false)) {
                booleanFuture.complete(true);
                return booleanFuture;
            }
            ((CompletableFuture)this.getLastMessageIdAsync().thenAccept(messageId -> {
                this.lastMessageIdInBroker = messageId;
                if (this.hasMoreMessages(this.lastMessageIdInBroker, this.lastDequeuedMessageId, false)) {
                    booleanFuture.complete(true);
                } else {
                    booleanFuture.complete(false);
                }
            })).exceptionally(e -> {
                log.error("[{}][{}] Failed getLastMessageId command", (Object)this.topic, (Object)this.subscription);
                booleanFuture.completeExceptionally(e.getCause());
                return null;
            });
        }
        return booleanFuture;
    }

    private boolean hasMoreMessages(MessageId lastMessageIdInBroker, MessageId messageId, boolean inclusive) {
        if (inclusive && lastMessageIdInBroker.compareTo((Object)messageId) >= 0 && ((MessageIdImpl)lastMessageIdInBroker).getEntryId() != -1L) {
            return true;
        }
        return !inclusive && lastMessageIdInBroker.compareTo((Object)messageId) > 0 && ((MessageIdImpl)lastMessageIdInBroker).getEntryId() != -1L;
    }

    @Override
    public CompletableFuture<MessageId> getLastMessageIdAsync() {
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            return FutureUtil.failedFuture((Throwable)new PulsarClientException.AlreadyClosedException(String.format("The consumer %s was already closed when the subscription %s of the topic %s getting the last message id", this.consumerName, this.subscription, this.topicName.toString())));
        }
        AtomicLong opTimeoutMs = new AtomicLong(this.client.getConfiguration().getOperationTimeoutMs());
        Backoff backoff = new BackoffBuilder().setInitialTime(100L, TimeUnit.MILLISECONDS).setMax(opTimeoutMs.get() * 2L, TimeUnit.MILLISECONDS).setMandatoryStop(0L, TimeUnit.MILLISECONDS).create();
        CompletableFuture<MessageId> getLastMessageIdFuture = new CompletableFuture<MessageId>();
        this.internalGetLastMessageIdAsync(backoff, opTimeoutMs, getLastMessageIdFuture);
        return getLastMessageIdFuture;
    }

    private void internalGetLastMessageIdAsync(Backoff backoff, AtomicLong remainingTime, CompletableFuture<MessageId> future) {
        ClientCnx cnx = this.cnx();
        if (this.isConnected() && cnx != null) {
            if (!Commands.peerSupportsGetLastMessageId(cnx.getRemoteEndpointProtocolVersion())) {
                future.completeExceptionally((Throwable)new PulsarClientException.NotSupportedException(String.format("The command `GetLastMessageId` is not supported for the protocol version %d. The consumer is %s, topic %s, subscription %s", cnx.getRemoteEndpointProtocolVersion(), this.consumerName, this.topicName.toString(), this.subscription)));
            }
            long requestId = this.client.newRequestId();
            ByteBuf getLastIdCmd = Commands.newGetLastMessageId(this.consumerId, requestId);
            log.info("[{}][{}] Get topic last message Id", (Object)this.topic, (Object)this.subscription);
            ((CompletableFuture)cnx.sendGetLastMessageId(getLastIdCmd, requestId).thenAccept(result -> {
                log.info("[{}][{}] Successfully getLastMessageId {}:{}", new Object[]{this.topic, this.subscription, result.getLedgerId(), result.getEntryId()});
                if (result.getBatchIndex() < 0) {
                    future.complete(new MessageIdImpl(result.getLedgerId(), result.getEntryId(), result.getPartition()));
                } else {
                    future.complete(new BatchMessageIdImpl(result.getLedgerId(), result.getEntryId(), result.getPartition(), result.getBatchIndex()));
                }
            })).exceptionally(e -> {
                log.error("[{}][{}] Failed getLastMessageId command", (Object)this.topic, (Object)this.subscription);
                future.completeExceptionally(PulsarClientException.wrap((Throwable)e.getCause(), (String)String.format("The subscription %s of the topic %s gets the last message id was failed", this.subscription, this.topicName.toString())));
                return null;
            });
        } else {
            long nextDelay = Math.min(backoff.next(), remainingTime.get());
            if (nextDelay <= 0L) {
                future.completeExceptionally((Throwable)new PulsarClientException.TimeoutException(String.format("The subscription %s of the topic %s could not get the last message id withing configured timeout", this.subscription, this.topicName.toString())));
                return;
            }
            ((ScheduledExecutorService)this.listenerExecutor).schedule(() -> {
                log.warn("[{}] [{}] Could not get connection while getLastMessageId -- Will try again in {} ms", new Object[]{this.topic, this.getHandlerName(), nextDelay});
                remainingTime.addAndGet(-nextDelay);
                this.internalGetLastMessageIdAsync(backoff, remainingTime, future);
            }, nextDelay, TimeUnit.MILLISECONDS);
        }
    }

    private MessageIdImpl getMessageIdImpl(Message<?> msg) {
        MessageIdImpl messageId = (MessageIdImpl)msg.getMessageId();
        if (messageId instanceof BatchMessageIdImpl) {
            messageId = new MessageIdImpl(messageId.getLedgerId(), messageId.getEntryId(), this.getPartitionIndex());
        }
        return messageId;
    }

    private boolean isMessageUndecryptable(PulsarApi.MessageMetadata msgMetadata) {
        return msgMetadata.getEncryptionKeysCount() > 0 && this.conf.getCryptoKeyReader() == null && this.conf.getCryptoFailureAction() == ConsumerCryptoFailureAction.CONSUME;
    }

    private Optional<EncryptionContext> createEncryptionContext(PulsarApi.MessageMetadata msgMetadata) {
        EncryptionContext encryptionCtx = null;
        if (msgMetadata.getEncryptionKeysCount() > 0) {
            encryptionCtx = new EncryptionContext();
            Map<String, EncryptionContext.EncryptionKey> keys = msgMetadata.getEncryptionKeysList().stream().collect(Collectors.toMap(PulsarApi.EncryptionKeys::getKey, e -> new EncryptionContext.EncryptionKey(e.getValue().toByteArray(), e.getMetadataList() != null ? e.getMetadataList().stream().collect(Collectors.toMap(PulsarApi.KeyValue::getKey, PulsarApi.KeyValue::getValue)) : null)));
            byte[] encParam = new byte[12];
            msgMetadata.getEncryptionParam().copyTo(encParam, 0);
            Optional<Object> batchSize = Optional.ofNullable(msgMetadata.hasNumMessagesInBatch() ? Integer.valueOf(msgMetadata.getNumMessagesInBatch()) : null);
            encryptionCtx.setKeys(keys);
            encryptionCtx.setParam(encParam);
            encryptionCtx.setAlgorithm(msgMetadata.getEncryptionAlgo());
            encryptionCtx.setCompressionType(CompressionCodecProvider.convertFromWireProtocol(msgMetadata.getCompression()));
            encryptionCtx.setUncompressedMessageSize(msgMetadata.getUncompressedSize());
            encryptionCtx.setBatchSize(batchSize);
        }
        return Optional.ofNullable(encryptionCtx);
    }

    private int removeExpiredMessagesFromQueue(Set<MessageId> messageIds) {
        int messagesFromQueue = 0;
        Message peek = (Message)this.incomingMessages.peek();
        if (peek != null) {
            MessageIdImpl messageId = this.getMessageIdImpl(peek);
            if (!messageIds.contains(messageId)) {
                return 0;
            }
            Message message = (Message)this.incomingMessages.poll();
            while (message != null) {
                INCOMING_MESSAGES_SIZE_UPDATER.addAndGet(this, -message.getData().length);
                ++messagesFromQueue;
                MessageIdImpl id = this.getMessageIdImpl(message);
                if (!messageIds.contains(id)) {
                    messageIds.add(id);
                    break;
                }
                message = (Message)this.incomingMessages.poll();
            }
        }
        return messagesFromQueue;
    }

    public ConsumerStats getStats() {
        return this.stats;
    }

    void setTerminated() {
        log.info("[{}] [{}] [{}] Consumer has reached the end of topic", new Object[]{this.subscription, this.topic, this.consumerName});
        this.hasReachedEndOfTopic = true;
        if (this.listener != null) {
            this.listener.reachedEndOfTopic((Consumer)this);
        }
    }

    public boolean hasReachedEndOfTopic() {
        return this.hasReachedEndOfTopic;
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.subscription, this.consumerName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConsumerImpl)) {
            return false;
        }
        ConsumerImpl consumer = (ConsumerImpl)o;
        return this.consumerId == consumer.consumerId;
    }

    ClientCnx cnx() {
        return this.connectionHandler.cnx();
    }

    void resetBackoff() {
        this.connectionHandler.resetBackoff();
    }

    void connectionClosed(ClientCnx cnx) {
        this.connectionHandler.connectionClosed(cnx);
    }

    @VisibleForTesting
    public ClientCnx getClientCnx() {
        return this.connectionHandler.cnx();
    }

    void setClientCnx(ClientCnx clientCnx) {
        ClientCnx previousClientCnx;
        if (clientCnx != null) {
            this.connectionHandler.setClientCnx(clientCnx);
            clientCnx.registerConsumer(this.consumerId, this);
        }
        if ((previousClientCnx = this.clientCnxUsedForConsumerRegistration.getAndSet(clientCnx)) != null && previousClientCnx != clientCnx) {
            previousClientCnx.removeConsumer(this.consumerId);
        }
    }

    void deregisterFromClientCnx() {
        this.setClientCnx(null);
    }

    void reconnectLater(Throwable exception) {
        this.connectionHandler.reconnectLater(exception);
    }

    void grabCnx() {
        this.connectionHandler.grabCnx();
    }

    public String getTopicNameWithoutPartition() {
        return this.topicNameWithoutPartition;
    }

    private void removeOldestPendingChunkedMessage() {
        ChunkedMessageCtx chunkedMsgCtx = null;
        String firstPendingMsgUuid = null;
        while (chunkedMsgCtx == null && !this.pendingChunckedMessageUuidQueue.isEmpty()) {
            firstPendingMsgUuid = (String)this.pendingChunckedMessageUuidQueue.poll();
            chunkedMsgCtx = StringUtils.isNotBlank(firstPendingMsgUuid) ? this.chunkedMessagesMap.get(firstPendingMsgUuid) : null;
        }
        this.removeChunkMessage(firstPendingMsgUuid, chunkedMsgCtx, this.autoAckOldestChunkedMessageOnQueueFull);
    }

    protected void removeExpireIncompleteChunkedMessages() {
        String messageUUID;
        if (this.expireTimeOfIncompleteChunkedMessageMillis <= 0L) {
            return;
        }
        ChunkedMessageCtx chunkedMsgCtx = null;
        while ((messageUUID = (String)this.pendingChunckedMessageUuidQueue.peek()) != null) {
            ChunkedMessageCtx chunkedMessageCtx = chunkedMsgCtx = StringUtils.isNotBlank(messageUUID) ? this.chunkedMessagesMap.get(messageUUID) : null;
            if (chunkedMsgCtx != null && System.currentTimeMillis() > chunkedMsgCtx.receivedTime + this.expireTimeOfIncompleteChunkedMessageMillis) {
                this.pendingChunckedMessageUuidQueue.remove(messageUUID);
                this.removeChunkMessage(messageUUID, chunkedMsgCtx, true);
                continue;
            }
            return;
        }
    }

    private void removeChunkMessage(String msgUUID, ChunkedMessageCtx chunkedMsgCtx, boolean autoAck) {
        if (chunkedMsgCtx == null) {
            return;
        }
        this.chunkedMessagesMap.remove(msgUUID);
        if (chunkedMsgCtx.chunkedMessageIds != null) {
            for (MessageIdImpl msgId : chunkedMsgCtx.chunkedMessageIds) {
                if (msgId == null) continue;
                if (autoAck) {
                    log.info("Removing chunk message-id {}", (Object)msgId);
                    this.doAcknowledge(msgId, PulsarApi.CommandAck.AckType.Individual, Collections.emptyMap(), null);
                    continue;
                }
                this.trackMessage(msgId);
            }
        }
        if (chunkedMsgCtx.chunkedMsgBuffer != null) {
            chunkedMsgCtx.chunkedMsgBuffer.release();
        }
        chunkedMsgCtx.recycle();
        --this.pendingChunckedMessageCount;
    }

    static class ChunkedMessageCtx {
        protected int totalChunks = -1;
        protected ByteBuf chunkedMsgBuffer;
        protected int lastChunkedMessageId = -1;
        protected MessageIdImpl[] chunkedMessageIds;
        protected long receivedTime = 0L;
        private final Recycler.Handle<ChunkedMessageCtx> recyclerHandle;
        private static final Recycler<ChunkedMessageCtx> RECYCLER = new Recycler<ChunkedMessageCtx>(){

            @Override
            protected ChunkedMessageCtx newObject(Recycler.Handle<ChunkedMessageCtx> handle) {
                return new ChunkedMessageCtx(handle);
            }
        };

        static ChunkedMessageCtx get(int numChunksFromMsg, ByteBuf chunkedMsgBuffer) {
            ChunkedMessageCtx ctx = RECYCLER.get();
            ctx.totalChunks = numChunksFromMsg;
            ctx.chunkedMsgBuffer = chunkedMsgBuffer;
            ctx.chunkedMessageIds = new MessageIdImpl[numChunksFromMsg];
            ctx.receivedTime = System.currentTimeMillis();
            return ctx;
        }

        private ChunkedMessageCtx(Recycler.Handle<ChunkedMessageCtx> recyclerHandle) {
            this.recyclerHandle = recyclerHandle;
        }

        public void recycle() {
            this.totalChunks = -1;
            this.chunkedMsgBuffer = null;
            this.lastChunkedMessageId = -1;
            this.recyclerHandle.recycle(this);
        }
    }
}

