/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ConsumerInterceptor;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerInterceptors<T>
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ConsumerInterceptors.class);
    private final List<ConsumerInterceptor<T>> interceptors;

    public ConsumerInterceptors(List<ConsumerInterceptor<T>> interceptors) {
        this.interceptors = interceptors;
    }

    public Message<T> beforeConsume(Consumer<T> consumer, Message<T> message) {
        Message interceptorMessage = message;
        int interceptorsSize = this.interceptors.size();
        for (int i = 0; i < interceptorsSize; ++i) {
            try {
                interceptorMessage = this.interceptors.get(i).beforeConsume(consumer, interceptorMessage);
                continue;
            }
            catch (Throwable e) {
                if (consumer != null) {
                    log.warn("Error executing interceptor beforeConsume callback topic: {} consumerName: {}", new Object[]{consumer.getTopic(), consumer.getConsumerName(), e});
                    continue;
                }
                log.warn("Error executing interceptor beforeConsume callback", e);
            }
        }
        return interceptorMessage;
    }

    public void onAcknowledge(Consumer<T> consumer, MessageId messageId, Throwable exception) {
        int interceptorsSize = this.interceptors.size();
        for (int i = 0; i < interceptorsSize; ++i) {
            try {
                this.interceptors.get(i).onAcknowledge(consumer, messageId, exception);
                continue;
            }
            catch (Throwable e) {
                log.warn("Error executing interceptor onAcknowledge callback ", e);
            }
        }
    }

    public void onAcknowledgeCumulative(Consumer<T> consumer, MessageId messageId, Throwable exception) {
        int interceptorsSize = this.interceptors.size();
        for (int i = 0; i < interceptorsSize; ++i) {
            try {
                this.interceptors.get(i).onAcknowledgeCumulative(consumer, messageId, exception);
                continue;
            }
            catch (Throwable e) {
                log.warn("Error executing interceptor onAcknowledgeCumulative callback ", e);
            }
        }
    }

    public void onNegativeAcksSend(Consumer<T> consumer, Set<MessageId> messageIds) {
        int interceptorsSize = this.interceptors.size();
        for (int i = 0; i < interceptorsSize; ++i) {
            try {
                this.interceptors.get(i).onNegativeAcksSend(consumer, messageIds);
                continue;
            }
            catch (Throwable e) {
                log.warn("Error executing interceptor onNegativeAcksSend callback", e);
            }
        }
    }

    public void onAckTimeoutSend(Consumer<T> consumer, Set<MessageId> messageIds) {
        int interceptorsSize = this.interceptors.size();
        for (int i = 0; i < interceptorsSize; ++i) {
            try {
                this.interceptors.get(i).onAckTimeoutSend(consumer, messageIds);
                continue;
            }
            catch (Throwable e) {
                log.warn("Error executing interceptor onAckTimeoutSend callback", e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        int interceptorsSize = this.interceptors.size();
        for (int i = 0; i < interceptorsSize; ++i) {
            try {
                this.interceptors.get(i).close();
                continue;
            }
            catch (Throwable e) {
                log.error("Fail to close consumer interceptor ", e);
            }
        }
    }
}

