/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.compression;

import io.airlift.compress.snappy.SnappyCompressor;
import io.airlift.compress.snappy.SnappyDecompressor;
import io.airlift.compress.snappy.SnappyRawCompressor;
import io.airlift.compress.snappy.SnappyRawDecompressor;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.common.compression.AirliftUtils;
import org.apache.pulsar.common.compression.CompressionCodec;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.util.concurrent.FastThreadLocal;

public class CompressionCodecSnappy
implements CompressionCodec {
    private static final FastThreadLocal<short[]> SNAPPY_TABLE = new FastThreadLocal<short[]>(){

        @Override
        protected short[] initialValue() throws Exception {
            return new short[16384];
        }
    };
    private static final FastThreadLocal<SnappyCompressor> SNAPPY_COMPRESSOR = new FastThreadLocal<SnappyCompressor>(){

        @Override
        protected SnappyCompressor initialValue() throws Exception {
            return new SnappyCompressor();
        }
    };
    private static final FastThreadLocal<SnappyDecompressor> SNAPPY_DECOMPRESSOR = new FastThreadLocal<SnappyDecompressor>(){

        @Override
        protected SnappyDecompressor initialValue() throws Exception {
            return new SnappyDecompressor();
        }
    };

    @Override
    public ByteBuf encode(ByteBuf source) {
        int compressedLength;
        int uncompressedLength = source.readableBytes();
        int maxLength = SnappyRawCompressor.maxCompressedLength((int)uncompressedLength);
        ByteBuf target = PulsarByteBufAllocator.DEFAULT.buffer(maxLength, maxLength);
        if (source.hasMemoryAddress() && target.hasMemoryAddress()) {
            compressedLength = SnappyRawCompressor.compress(null, (long)(source.memoryAddress() + (long)source.readerIndex()), (long)(source.memoryAddress() + (long)source.writerIndex()), null, (long)target.memoryAddress(), (long)(target.memoryAddress() + (long)maxLength), (short[])SNAPPY_TABLE.get());
        } else {
            ByteBuffer sourceNio = source.nioBuffer(source.readerIndex(), source.readableBytes());
            ByteBuffer targetNio = target.nioBuffer(0, maxLength);
            SNAPPY_COMPRESSOR.get().compress(sourceNio, targetNio);
            compressedLength = targetNio.position();
        }
        target.writerIndex(compressedLength);
        return target;
    }

    @Override
    public ByteBuf decode(ByteBuf encoded, int uncompressedLength) throws IOException {
        ByteBuf uncompressed = PulsarByteBufAllocator.DEFAULT.buffer(uncompressedLength, uncompressedLength);
        if (encoded.hasMemoryAddress() && uncompressed.hasMemoryAddress()) {
            SnappyRawDecompressor.decompress(null, (long)(encoded.memoryAddress() + (long)encoded.readerIndex()), (long)(encoded.memoryAddress() + (long)encoded.writerIndex()), null, (long)uncompressed.memoryAddress(), (long)(uncompressed.memoryAddress() + (long)uncompressedLength));
        } else {
            ByteBuffer uncompressedNio = uncompressed.nioBuffer(0, uncompressedLength);
            ByteBuffer encodedNio = encoded.nioBuffer(encoded.readerIndex(), encoded.readableBytes());
            encodedNio = AirliftUtils.ensureAirliftSupported(encodedNio, uncompressedLength);
            SNAPPY_DECOMPRESSOR.get().decompress(encodedNio, uncompressedNio);
        }
        uncompressed.writerIndex(uncompressedLength);
        return uncompressed;
    }
}

