/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.io.InputStream;
import org.apache.pulsar.client.api.schema.SchemaInfoProvider;
import org.apache.pulsar.client.api.schema.SchemaReader;
import org.apache.pulsar.client.api.schema.SchemaWriter;
import org.apache.pulsar.client.impl.schema.AbstractSchema;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.ByteBufInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStructSchema<T>
extends AbstractSchema<T> {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractStructSchema.class);
    protected final SchemaInfo schemaInfo;
    protected SchemaReader<T> reader;
    protected SchemaWriter<T> writer;
    protected SchemaInfoProvider schemaInfoProvider;

    public AbstractStructSchema(SchemaInfo schemaInfo) {
        this.schemaInfo = schemaInfo;
    }

    public byte[] encode(T message) {
        return this.writer.write(message);
    }

    public T decode(byte[] bytes) {
        return (T)this.reader.read(bytes);
    }

    public T decode(byte[] bytes, byte[] schemaVersion) {
        return (T)this.reader.read(bytes, schemaVersion);
    }

    @Override
    public T decode(ByteBuf byteBuf) {
        return (T)this.reader.read((InputStream)new ByteBufInputStream(byteBuf));
    }

    @Override
    public T decode(ByteBuf byteBuf, byte[] schemaVersion) {
        return (T)this.reader.read((InputStream)new ByteBufInputStream(byteBuf), schemaVersion);
    }

    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    public void setSchemaInfoProvider(SchemaInfoProvider schemaInfoProvider) {
        if (this.reader != null) {
            this.reader.setSchemaInfoProvider(schemaInfoProvider);
        }
    }

    protected void setWriter(SchemaWriter<T> writer) {
        this.writer = writer;
    }

    protected void setReader(SchemaReader<T> reader) {
        this.reader = reader;
    }

    protected SchemaReader<T> getReader() {
        return this.reader;
    }
}

