/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;

class CompletableFutureCancellationHandler {
    private volatile boolean cancelled;
    private volatile Runnable cancelAction;
    private final AtomicBoolean cancelHandled = new AtomicBoolean();

    CompletableFutureCancellationHandler() {
    }

    public <T> CompletableFuture<T> createFuture() {
        CompletableFuture future = new CompletableFuture();
        this.attachToFuture(future);
        return future;
    }

    public <T> void attachToFuture(CompletableFuture<T> future) {
        future.whenComplete((BiConsumer)this.whenCompleteFunction());
    }

    public void setCancelAction(Runnable cancelAction) {
        if (this.cancelAction != null) {
            throw new IllegalStateException("cancelAction can only be set once.");
        }
        this.cancelAction = Objects.requireNonNull(cancelAction);
        this.runCancelActionOnceIfCancelled();
    }

    private <T> BiConsumer<? super T, ? super Throwable> whenCompleteFunction() {
        return (t, throwable) -> {
            if (throwable instanceof CancellationException || throwable instanceof TimeoutException) {
                this.cancelled = true;
            }
            this.runCancelActionOnceIfCancelled();
        };
    }

    private void runCancelActionOnceIfCancelled() {
        if (this.cancelled && this.cancelAction != null && this.cancelHandled.compareAndSet(false, true)) {
            this.cancelAction.run();
        }
    }
}

