/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.io.IOException;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.BatchMessageAcker;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.client.impl.TopicMessageIdImpl;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.util.protobuf.ByteBufCodedInputStream;
import org.apache.pulsar.common.util.protobuf.ByteBufCodedOutputStream;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.ComparisonChain;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;
import org.apache.pulsar.shaded.com.google.protobuf.v241.UninitializedMessageException;

public class MessageIdImpl
implements MessageId {
    protected final long ledgerId;
    protected final long entryId;
    protected final int partitionIndex;

    private MessageIdImpl() {
        this(-1L, -1L, -1);
    }

    public MessageIdImpl(long ledgerId, long entryId, int partitionIndex) {
        this.ledgerId = ledgerId;
        this.entryId = entryId;
        this.partitionIndex = partitionIndex;
    }

    public long getLedgerId() {
        return this.ledgerId;
    }

    public long getEntryId() {
        return this.entryId;
    }

    public int getPartitionIndex() {
        return this.partitionIndex;
    }

    public int hashCode() {
        return (int)(31L * (this.ledgerId + 31L * this.entryId) + (long)this.partitionIndex);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BatchMessageIdImpl) {
            BatchMessageIdImpl other = (BatchMessageIdImpl)obj;
            return other.equals(this);
        }
        if (obj instanceof MessageIdImpl) {
            MessageIdImpl other = (MessageIdImpl)obj;
            return this.ledgerId == other.ledgerId && this.entryId == other.entryId && this.partitionIndex == other.partitionIndex;
        }
        if (obj instanceof TopicMessageIdImpl) {
            return this.equals(((TopicMessageIdImpl)obj).getInnerMessageId());
        }
        return false;
    }

    public String toString() {
        return "" + this.ledgerId + ':' + this.entryId + ':' + this.partitionIndex;
    }

    public static MessageId fromByteArray(byte[] data) throws IOException {
        PulsarApi.MessageIdData idData;
        Preconditions.checkNotNull(data);
        ByteBufCodedInputStream inputStream = ByteBufCodedInputStream.get(Unpooled.wrappedBuffer(data, 0, data.length));
        PulsarApi.MessageIdData.Builder builder = PulsarApi.MessageIdData.newBuilder();
        try {
            idData = builder.mergeFrom(inputStream, null).build();
        }
        catch (UninitializedMessageException e) {
            throw new IOException(e);
        }
        MessageIdImpl messageId = idData.hasBatchIndex() ? (idData.hasBatchSize() ? new BatchMessageIdImpl(idData.getLedgerId(), idData.getEntryId(), idData.getPartition(), idData.getBatchIndex(), idData.getBatchSize(), BatchMessageAcker.newAcker(idData.getBatchSize())) : new BatchMessageIdImpl(idData.getLedgerId(), idData.getEntryId(), idData.getPartition(), idData.getBatchIndex())) : new MessageIdImpl(idData.getLedgerId(), idData.getEntryId(), idData.getPartition());
        inputStream.recycle();
        builder.recycle();
        idData.recycle();
        return messageId;
    }

    public static MessageIdImpl convertToMessageIdImpl(MessageId messageId) {
        if (messageId instanceof BatchMessageIdImpl) {
            return (BatchMessageIdImpl)messageId;
        }
        if (messageId instanceof MessageIdImpl) {
            return (MessageIdImpl)messageId;
        }
        if (messageId instanceof TopicMessageIdImpl) {
            return MessageIdImpl.convertToMessageIdImpl(((TopicMessageIdImpl)messageId).getInnerMessageId());
        }
        return null;
    }

    public static MessageId fromByteArrayWithTopic(byte[] data, String topicName) throws IOException {
        return MessageIdImpl.fromByteArrayWithTopic(data, TopicName.get(topicName));
    }

    public static MessageId fromByteArrayWithTopic(byte[] data, TopicName topicName) throws IOException {
        PulsarApi.MessageIdData idData;
        Preconditions.checkNotNull(data);
        ByteBufCodedInputStream inputStream = ByteBufCodedInputStream.get(Unpooled.wrappedBuffer(data, 0, data.length));
        PulsarApi.MessageIdData.Builder builder = PulsarApi.MessageIdData.newBuilder();
        try {
            idData = builder.mergeFrom(inputStream, null).build();
        }
        catch (UninitializedMessageException e) {
            throw new IOException(e);
        }
        MessageId messageId = idData.hasBatchIndex() ? new BatchMessageIdImpl(idData.getLedgerId(), idData.getEntryId(), idData.getPartition(), idData.getBatchIndex(), idData.getBatchSize(), BatchMessageAcker.newAcker(idData.getBatchSize())) : new MessageIdImpl(idData.getLedgerId(), idData.getEntryId(), idData.getPartition());
        if (idData.getPartition() > -1 && topicName != null) {
            messageId = new TopicMessageIdImpl(topicName.getPartition(idData.getPartition()).toString(), topicName.toString(), messageId);
        }
        inputStream.recycle();
        builder.recycle();
        idData.recycle();
        return messageId;
    }

    protected byte[] toByteArray(int batchIndex, int batchSize) {
        PulsarApi.MessageIdData.Builder builder = PulsarApi.MessageIdData.newBuilder();
        builder.setLedgerId(this.ledgerId);
        builder.setEntryId(this.entryId);
        if (this.partitionIndex >= 0) {
            builder.setPartition(this.partitionIndex);
        }
        if (batchIndex != -1) {
            builder.setBatchIndex(batchIndex);
        }
        if (batchSize > -1) {
            builder.setBatchSize(batchSize);
        }
        PulsarApi.MessageIdData msgId = builder.build();
        int size = msgId.getSerializedSize();
        ByteBuf serialized = Unpooled.buffer(size, size);
        ByteBufCodedOutputStream stream = ByteBufCodedOutputStream.get(serialized);
        try {
            msgId.writeTo(stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        msgId.recycle();
        builder.recycle();
        stream.recycle();
        return serialized.array();
    }

    @Override
    public byte[] toByteArray() {
        return this.toByteArray(-1, 0);
    }

    @Override
    public int compareTo(MessageId o) {
        if (o instanceof BatchMessageIdImpl) {
            BatchMessageIdImpl other = (BatchMessageIdImpl)o;
            int res = ComparisonChain.start().compare(this.ledgerId, other.ledgerId).compare(this.entryId, other.entryId).compare(this.getPartitionIndex(), other.getPartitionIndex()).result();
            if (res == 0 && other.getBatchIndex() > -1) {
                return -1;
            }
            return res;
        }
        if (o instanceof MessageIdImpl) {
            MessageIdImpl other = (MessageIdImpl)o;
            return ComparisonChain.start().compare(this.ledgerId, other.ledgerId).compare(this.entryId, other.entryId).compare(this.getPartitionIndex(), other.getPartitionIndex()).result();
        }
        if (o instanceof TopicMessageIdImpl) {
            return this.compareTo(((TopicMessageIdImpl)o).getInnerMessageId());
        }
        throw new IllegalArgumentException("expected MessageIdImpl object. Got instance of " + o.getClass().getName());
    }
}

