/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util;

import java.util.concurrent.TimeUnit;

public final class RelativeTimeUtil {
    public static long parseRelativeTimeInSeconds(String relativeTime) {
        int timeUnit;
        if (relativeTime.isEmpty()) {
            throw new IllegalArgumentException("exipiry time cannot be empty");
        }
        int lastIndex = relativeTime.length() - 1;
        char lastChar = relativeTime.charAt(lastIndex);
        if (!Character.isAlphabetic(lastChar)) {
            timeUnit = 115;
            lastIndex = relativeTime.length();
        } else {
            timeUnit = Character.toLowerCase(lastChar);
        }
        long duration = Long.parseLong(relativeTime.substring(0, lastIndex));
        switch (timeUnit) {
            case 115: {
                return duration;
            }
            case 109: {
                return TimeUnit.MINUTES.toSeconds(duration);
            }
            case 104: {
                return TimeUnit.HOURS.toSeconds(duration);
            }
            case 100: {
                return TimeUnit.DAYS.toSeconds(duration);
            }
            case 119: {
                return 7L * TimeUnit.DAYS.toSeconds(duration);
            }
            case 121: {
                return 365L * TimeUnit.DAYS.toSeconds(duration);
            }
        }
        throw new IllegalArgumentException("Invalid time unit '" + lastChar + "'");
    }

    private RelativeTimeUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

