/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.transaction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.transaction.Transaction;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.client.impl.ConsumerImpl;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.transaction.TransactionCoordinatorClientImpl;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionImpl
implements Transaction {
    private static final Logger log = LoggerFactory.getLogger(TransactionImpl.class);
    private final PulsarClientImpl client;
    private final long transactionTimeoutMs;
    private final long txnIdLeastBits;
    private final long txnIdMostBits;
    private final Map<String, CompletableFuture<Void>> registerPartitionMap;
    private final Map<String, CompletableFuture<Void>> registerSubscriptionMap;
    private final TransactionCoordinatorClientImpl tcClient;
    private Map<ConsumerImpl<?>, Integer> cumulativeAckConsumers;
    private final ArrayList<CompletableFuture<MessageId>> sendFutureList;
    private final ArrayList<CompletableFuture<Void>> ackFutureList;

    TransactionImpl(PulsarClientImpl client, long transactionTimeoutMs, long txnIdLeastBits, long txnIdMostBits) {
        this.client = client;
        this.transactionTimeoutMs = transactionTimeoutMs;
        this.txnIdLeastBits = txnIdLeastBits;
        this.txnIdMostBits = txnIdMostBits;
        this.registerPartitionMap = new ConcurrentHashMap<String, CompletableFuture<Void>>();
        this.registerSubscriptionMap = new ConcurrentHashMap<String, CompletableFuture<Void>>();
        this.tcClient = client.getTcClient();
        this.sendFutureList = new ArrayList();
        this.ackFutureList = new ArrayList();
    }

    public synchronized CompletableFuture<Void> registerProducedTopic(String topic) {
        CompletableFuture completableFuture = new CompletableFuture();
        return this.registerPartitionMap.compute(topic, (key, future) -> {
            if (future != null) {
                return future.thenCompose(ignored -> CompletableFuture.completedFuture(null));
            }
            return this.tcClient.addPublishPartitionToTxnAsync(new TxnID(this.txnIdMostBits, this.txnIdLeastBits), Lists.newArrayList(topic)).thenCompose(ignored -> CompletableFuture.completedFuture(null));
        });
    }

    public synchronized void registerSendOp(CompletableFuture<MessageId> sendFuture) {
        this.sendFutureList.add(sendFuture);
    }

    public synchronized CompletableFuture<Void> registerAckedTopic(String topic, String subscription) {
        CompletableFuture completableFuture = new CompletableFuture();
        return this.registerSubscriptionMap.compute(topic, (key, future) -> {
            if (future != null) {
                return future.thenCompose(ignored -> CompletableFuture.completedFuture(null));
            }
            return this.tcClient.addSubscriptionToTxnAsync(new TxnID(this.txnIdMostBits, this.txnIdLeastBits), topic, subscription).thenCompose(ignored -> CompletableFuture.completedFuture(null));
        });
    }

    public synchronized void registerAckOp(CompletableFuture<Void> ackFuture) {
        this.ackFutureList.add(ackFuture);
    }

    public synchronized void registerCumulativeAckConsumer(ConsumerImpl<?> consumer) {
        if (this.cumulativeAckConsumers == null) {
            this.cumulativeAckConsumers = new HashMap();
        }
        this.cumulativeAckConsumers.put(consumer, 0);
    }

    @Override
    public CompletableFuture<Void> commit() {
        ArrayList sendMessageIdList = new ArrayList(this.sendFutureList.size());
        CompletableFuture<Void> commitFuture = new CompletableFuture<Void>();
        this.allOpComplete().whenComplete((v, e) -> {
            if (e != null) {
                this.abort().whenComplete((vx, ex) -> commitFuture.completeExceptionally((Throwable)e));
            } else {
                for (CompletableFuture<MessageId> future : this.sendFutureList) {
                    future.thenAccept(sendMessageIdList::add);
                }
                this.tcClient.commitAsync(new TxnID(this.txnIdMostBits, this.txnIdLeastBits), sendMessageIdList).whenComplete((vx, ex) -> {
                    if (ex != null) {
                        commitFuture.completeExceptionally((Throwable)ex);
                    } else {
                        commitFuture.complete((Void)vx);
                    }
                });
            }
        });
        return commitFuture;
    }

    @Override
    public CompletableFuture<Void> abort() {
        ArrayList sendMessageIdList = new ArrayList(this.sendFutureList.size());
        CompletableFuture<Void> abortFuture = new CompletableFuture<Void>();
        this.allOpComplete().whenComplete((v, e) -> {
            if (e != null) {
                log.error(e.getMessage());
            }
            for (CompletableFuture<MessageId> future : this.sendFutureList) {
                future.thenAccept(sendMessageIdList::add);
            }
            if (this.cumulativeAckConsumers != null) {
                this.cumulativeAckConsumers.forEach((consumer, integer) -> this.cumulativeAckConsumers.putIfAbsent((ConsumerImpl<?>)consumer, consumer.clearIncomingMessagesAndGetMessageNumber()));
            }
            this.tcClient.abortAsync(new TxnID(this.txnIdMostBits, this.txnIdLeastBits), sendMessageIdList).whenComplete((vx, ex) -> {
                if (this.cumulativeAckConsumers != null) {
                    this.cumulativeAckConsumers.forEach(ConsumerImpl::increaseAvailablePermits);
                    this.cumulativeAckConsumers.clear();
                }
                if (ex != null) {
                    abortFuture.completeExceptionally((Throwable)ex);
                } else {
                    abortFuture.complete(null);
                }
            });
        });
        return abortFuture;
    }

    private CompletableFuture<Void> allOpComplete() {
        ArrayList<CompletableFuture<Object>> futureList = new ArrayList<CompletableFuture<Object>>();
        futureList.addAll(this.sendFutureList);
        futureList.addAll(this.ackFutureList);
        return CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0]));
    }

    public PulsarClientImpl getClient() {
        return this.client;
    }

    public long getTransactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    public long getTxnIdLeastBits() {
        return this.txnIdLeastBits;
    }

    public long getTxnIdMostBits() {
        return this.txnIdMostBits;
    }

    public Map<String, CompletableFuture<Void>> getRegisterPartitionMap() {
        return this.registerPartitionMap;
    }

    public Map<String, CompletableFuture<Void>> getRegisterSubscriptionMap() {
        return this.registerSubscriptionMap;
    }

    public TransactionCoordinatorClientImpl getTcClient() {
        return this.tcClient;
    }

    public Map<ConsumerImpl<?>, Integer> getCumulativeAckConsumers() {
        return this.cumulativeAckConsumers;
    }

    public ArrayList<CompletableFuture<MessageId>> getSendFutureList() {
        return this.sendFutureList;
    }

    public ArrayList<CompletableFuture<Void>> getAckFutureList() {
        return this.ackFutureList;
    }
}

