/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.conf;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.pulsar.shade.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pulsar.shade.com.google.common.collect.Maps;
import org.apache.pulsar.shade.io.netty.util.concurrent.FastThreadLocal;

public final class ConfigurationDataUtils {
    private static final FastThreadLocal<ObjectMapper> mapper = new FastThreadLocal<ObjectMapper>(){

        @Override
        protected ObjectMapper initialValue() throws Exception {
            return ConfigurationDataUtils.create();
        }
    };

    public static ObjectMapper create() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        mapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper;
    }

    public static ObjectMapper getThreadLocal() {
        return mapper.get();
    }

    private ConfigurationDataUtils() {
    }

    public static <T> T loadData(Map<String, Object> config, T existingData, Class<T> dataCls) {
        ObjectMapper mapper = ConfigurationDataUtils.getThreadLocal();
        try {
            String existingConfigJson = mapper.writeValueAsString(existingData);
            Map existingConfig = mapper.readValue(existingConfigJson, Map.class);
            HashMap<String, Object> newConfig = Maps.newHashMap();
            newConfig.putAll(existingConfig);
            newConfig.putAll(config);
            String configJson = mapper.writeValueAsString(newConfig);
            return mapper.readValue(configJson, dataCls);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load config into existing configuration data", e);
        }
    }
}

