/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.common.util.affinity.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;

public final class NativeUtils {
    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"}, justification="work around for java 9: https://github.com/spotbugs/spotbugs/issues/493")
    public static void loadLibraryFromJar(String path) throws Exception {
        Preconditions.checkArgument(path.startsWith("/"), "absolute path must start with /");
        String[] parts = path.split("/");
        String filename = parts.length > 0 ? parts[parts.length - 1] : null;
        File dir = File.createTempFile("native", "");
        if (!dir.mkdir()) {
            throw new IOException("Failed to create temp directory " + dir.getAbsolutePath());
        }
        dir.deleteOnExit();
        File temp = new File(dir, filename);
        temp.deleteOnExit();
        byte[] buffer = new byte[1024];
        try (InputStream input = NativeUtils.class.getResourceAsStream(path);
             FileOutputStream out = new FileOutputStream(temp);){
            int read;
            if (input == null) {
                throw new FileNotFoundException("Couldn't find file into jar " + path);
            }
            while ((read = input.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
            }
        }
        if (!temp.exists()) {
            throw new FileNotFoundException("Failed to copy file from jar at " + temp.getAbsolutePath());
        }
        System.load(temp.getAbsolutePath());
    }

    private NativeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

