/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.TypedMessageBuilder;
import org.apache.pulsar.client.api.schema.KeyValueSchema;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.client.impl.ProducerBase;
import org.apache.pulsar.client.impl.transaction.TransactionImpl;
import org.apache.pulsar.client.util.TypeCheckUtil;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.schema.KeyValueEncodingType;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;

public class TypedMessageBuilderImpl<T>
implements TypedMessageBuilder<T> {
    private static final long serialVersionUID = 0L;
    private static final ByteBuffer EMPTY_CONTENT = ByteBuffer.allocate(0);
    private final transient ProducerBase<?> producer;
    private final transient MessageMetadata msgMetadata = new MessageMetadata();
    private final transient Schema<T> schema;
    private transient ByteBuffer content;
    private final transient TransactionImpl txn;

    public TypedMessageBuilderImpl(ProducerBase<?> producer, Schema<T> schema) {
        this(producer, schema, null);
    }

    public TypedMessageBuilderImpl(ProducerBase<?> producer, Schema<T> schema, TransactionImpl txn) {
        this.producer = producer;
        this.schema = schema;
        this.content = EMPTY_CONTENT;
        this.txn = txn;
    }

    private long beforeSend() {
        if (this.txn == null) {
            return -1L;
        }
        this.msgMetadata.setTxnidLeastBits(this.txn.getTxnIdLeastBits());
        this.msgMetadata.setTxnidMostBits(this.txn.getTxnIdMostBits());
        return -1L;
    }

    public MessageId send() throws PulsarClientException {
        try {
            CompletableFuture<MessageId> sendFuture = this.sendAsync();
            if (!sendFuture.isDone()) {
                this.producer.triggerFlush();
            }
            return sendFuture.get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public CompletableFuture<MessageId> sendAsync() {
        CompletableFuture<MessageId> sendFuture;
        Message<T> message = this.getMessage();
        if (this.txn != null) {
            sendFuture = this.producer.internalSendWithTxnAsync(message, this.txn);
            this.txn.registerSendOp(sendFuture);
        } else {
            sendFuture = this.producer.internalSendAsync(message);
        }
        return sendFuture;
    }

    public TypedMessageBuilder<T> key(String key) {
        this.getKeyValueSchema().ifPresent(keyValueSchema -> Preconditions.checkArgument(keyValueSchema.getKeyValueEncodingType() != KeyValueEncodingType.SEPARATED, "This method is not allowed to set keys when in encoding type is SEPARATED"));
        if (key == null) {
            this.msgMetadata.setNullPartitionKey(true);
            return this;
        }
        this.msgMetadata.setPartitionKey(key);
        this.msgMetadata.setPartitionKeyB64Encoded(false);
        return this;
    }

    public TypedMessageBuilder<T> keyBytes(byte[] key) {
        this.getKeyValueSchema().ifPresent(keyValueSchema -> Preconditions.checkArgument(keyValueSchema.getKeyValueEncodingType() != KeyValueEncodingType.SEPARATED, "This method is not allowed to set keys when in encoding type is SEPARATED"));
        if (key == null) {
            this.msgMetadata.setNullPartitionKey(true);
            return this;
        }
        this.msgMetadata.setPartitionKey(Base64.getEncoder().encodeToString(key));
        this.msgMetadata.setPartitionKeyB64Encoded(true);
        return this;
    }

    public TypedMessageBuilder<T> orderingKey(byte[] orderingKey) {
        this.msgMetadata.setOrderingKey(orderingKey);
        return this;
    }

    public TypedMessageBuilder<T> value(T value) {
        if (value == null) {
            this.msgMetadata.setNullValue(true);
            return this;
        }
        return this.getKeyValueSchema().map(keyValueSchema -> {
            if (keyValueSchema.getKeyValueEncodingType() == KeyValueEncodingType.SEPARATED) {
                this.setSeparateKeyValue(value, (KeyValueSchema)keyValueSchema);
                return this;
            }
            return null;
        }).orElseGet(() -> {
            this.content = ByteBuffer.wrap(this.schema.encode(value));
            return this;
        });
    }

    public TypedMessageBuilder<T> property(String name, String value) {
        Preconditions.checkArgument(name != null, "Need Non-Null name");
        Preconditions.checkArgument(value != null, "Need Non-Null value for name: " + name);
        this.msgMetadata.addProperty().setKey(name).setValue(value);
        return this;
    }

    public TypedMessageBuilder<T> properties(Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            Preconditions.checkArgument(entry.getKey() != null, "Need Non-Null key");
            Preconditions.checkArgument(entry.getValue() != null, "Need Non-Null value for key: " + entry.getKey());
            this.msgMetadata.addProperty().setKey(entry.getKey()).setValue(entry.getValue());
        }
        return this;
    }

    public TypedMessageBuilder<T> eventTime(long timestamp) {
        Preconditions.checkArgument(timestamp > 0L, "Invalid timestamp : '%s'", timestamp);
        this.msgMetadata.setEventTime(timestamp);
        return this;
    }

    public TypedMessageBuilder<T> sequenceId(long sequenceId) {
        Preconditions.checkArgument(sequenceId >= 0L);
        this.msgMetadata.setSequenceId(sequenceId);
        return this;
    }

    public TypedMessageBuilder<T> replicationClusters(List<String> clusters) {
        Preconditions.checkNotNull(clusters);
        this.msgMetadata.clearReplicateTo();
        this.msgMetadata.addAllReplicateTos(clusters);
        return this;
    }

    public TypedMessageBuilder<T> disableReplication() {
        this.msgMetadata.clearReplicateTo();
        this.msgMetadata.addReplicateTo("__local__");
        return this;
    }

    public TypedMessageBuilder<T> deliverAfter(long delay, TimeUnit unit) {
        return this.deliverAt(System.currentTimeMillis() + unit.toMillis(delay));
    }

    public TypedMessageBuilder<T> deliverAt(long timestamp) {
        this.msgMetadata.setDeliverAtTime(timestamp);
        return this;
    }

    public TypedMessageBuilder<T> loadConf(Map<String, Object> config) {
        config.forEach((key, value) -> {
            switch (key) {
                case "key": {
                    this.key(TypeCheckUtil.checkType(value, String.class));
                    break;
                }
                case "properties": {
                    this.properties(TypeCheckUtil.checkType(value, Map.class));
                    break;
                }
                case "eventTime": {
                    this.eventTime(TypeCheckUtil.checkType(value, Long.class));
                    break;
                }
                case "sequenceId": {
                    this.sequenceId(TypeCheckUtil.checkType(value, Long.class));
                    break;
                }
                case "replicationClusters": {
                    this.replicationClusters(TypeCheckUtil.checkType(value, List.class));
                    break;
                }
                case "disableReplication": {
                    boolean disableReplication = TypeCheckUtil.checkType(value, Boolean.class);
                    if (!disableReplication) break;
                    this.disableReplication();
                    break;
                }
                case "deliverAfterSeconds": {
                    this.deliverAfter(TypeCheckUtil.checkType(value, Long.class), TimeUnit.SECONDS);
                    break;
                }
                case "deliverAt": {
                    this.deliverAt(TypeCheckUtil.checkType(value, Long.class));
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid message config key '" + key + "'");
                }
            }
        });
        return this;
    }

    public MessageMetadata getMetadataBuilder() {
        return this.msgMetadata;
    }

    public Message<T> getMessage() {
        this.beforeSend();
        return MessageImpl.create(this.msgMetadata, this.content, this.schema, this.producer != null ? this.producer.getTopic() : null);
    }

    public long getPublishTime() {
        return this.msgMetadata.getPublishTime();
    }

    public boolean hasKey() {
        return this.msgMetadata.hasPartitionKey();
    }

    public String getKey() {
        return this.msgMetadata.getPartitionKey();
    }

    public ByteBuffer getContent() {
        return this.content;
    }

    private Optional<KeyValueSchema<?, ?>> getKeyValueSchema() {
        if (this.schema.getSchemaInfo() != null && this.schema.getSchemaInfo().getType() == SchemaType.KEY_VALUE && this.schema instanceof KeyValueSchema) {
            return Optional.of((KeyValueSchema)this.schema);
        }
        return Optional.empty();
    }

    private <K, V> void setSeparateKeyValue(T value, KeyValueSchema<K, V> keyValueSchema) {
        Preconditions.checkArgument(value instanceof KeyValue);
        KeyValue keyValue = (KeyValue)value;
        if (keyValue.getKey() != null) {
            this.msgMetadata.setPartitionKey(Base64.getEncoder().encodeToString(keyValueSchema.getKeySchema().encode(keyValue.getKey())));
            this.msgMetadata.setPartitionKeyB64Encoded(true);
        } else {
            this.msgMetadata.setNullPartitionKey(true);
        }
        if (keyValue.getValue() != null) {
            this.content = ByteBuffer.wrap(keyValueSchema.getValueSchema().encode(keyValue.getValue()));
        } else {
            this.msgMetadata.setNullValue(true);
        }
    }
}

