/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api.transaction;

import java.io.IOException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.common.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class TransactionCoordinatorClientException
extends IOException {
    public TransactionCoordinatorClientException(Throwable t2) {
        super(t2);
    }

    public TransactionCoordinatorClientException(String message) {
        super(message);
    }

    public static TransactionCoordinatorClientException unwrap(Throwable t2) {
        if (t2 instanceof TransactionCoordinatorClientException) {
            return (TransactionCoordinatorClientException)t2;
        }
        if (t2 instanceof RuntimeException) {
            throw (RuntimeException)t2;
        }
        if (t2 instanceof InterruptedException) {
            Thread.currentThread().interrupt();
            return new TransactionCoordinatorClientException(t2);
        }
        if (t2 instanceof CoordinatorNotFoundException) {
            return (CoordinatorNotFoundException)t2;
        }
        if (t2 instanceof InvalidTxnStatusException) {
            return (InvalidTxnStatusException)t2;
        }
        if (t2 instanceof ExecutionException | t2 instanceof CompletionException) {
            return TransactionCoordinatorClientException.unwrap(t2.getCause());
        }
        return new TransactionCoordinatorClientException(t2);
    }

    public static class CoordinatorNotFoundException
    extends TransactionCoordinatorClientException {
        public CoordinatorNotFoundException(String message) {
            super(message);
        }
    }

    public static class InvalidTxnStatusException
    extends TransactionCoordinatorClientException {
        public InvalidTxnStatusException(String message) {
            super(message);
        }

        public InvalidTxnStatusException(String txnId, String actualState, String expectState) {
            super("[" + txnId + "] with unexpected state : " + actualState + ", expect " + expectState + " state!");
        }
    }

    public static class MetaStoreHandlerNotReadyException
    extends TransactionCoordinatorClientException {
        public MetaStoreHandlerNotReadyException(long tcId) {
            super("Transaction meta store handler for transaction meta store {} not ready now.");
        }

        public MetaStoreHandlerNotReadyException(String message) {
            super(message);
        }
    }

    public static class MetaStoreHandlerNotExistsException
    extends TransactionCoordinatorClientException {
        public MetaStoreHandlerNotExistsException(long tcId) {
            super("Transaction meta store handler for transaction meta store {} not exists.");
        }

        public MetaStoreHandlerNotExistsException(String message) {
            super(message);
        }
    }

    public static class TransactionNotFoundException
    extends TransactionCoordinatorClientException {
        public TransactionNotFoundException(String message) {
            super(message);
        }
    }

    public static class CoordinatorClientStateException
    extends TransactionCoordinatorClientException {
        public CoordinatorClientStateException() {
            super("Unexpected state for transaction metadata client.");
        }

        public CoordinatorClientStateException(String message) {
            super(message);
        }
    }
}

