/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.yahoo.sketches.quantiles;

import java.util.Arrays;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.DoublesSketch;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.Util;

class DoublesPmfCdfImpl {
    DoublesPmfCdfImpl() {
    }

    static double[] getPMFOrCDF(DoublesSketch sketch, double[] splitPoints, boolean isCDF) {
        long[] counters = DoublesPmfCdfImpl.internalBuildHistogram(sketch, splitPoints);
        int numCounters = counters.length;
        double[] result = new double[numCounters];
        double n = sketch.getN();
        long subtotal = 0L;
        if (isCDF) {
            for (int j = 0; j < numCounters; ++j) {
                long count = counters[j];
                result[j] = (double)(subtotal += count) / n;
            }
        } else {
            for (int j = 0; j < numCounters; ++j) {
                long count = counters[j];
                subtotal += count;
                result[j] = (double)count / n;
            }
        }
        assert ((double)subtotal == n);
        return result;
    }

    static long[] internalBuildHistogram(DoublesSketch sketch, double[] splitPoints) {
        long myBitPattern;
        double[] levelsArr;
        double[] baseBuffer = levelsArr = sketch.getCombinedBuffer();
        int bbCount = sketch.getBaseBufferCount();
        Util.validateValues(splitPoints);
        int numSplitPoints = splitPoints.length;
        int numCounters = numSplitPoints + 1;
        long[] counters = new long[numCounters];
        long weight = 1L;
        if (numSplitPoints < 50) {
            DoublesPmfCdfImpl.bilinearTimeIncrementHistogramCounters(baseBuffer, 0, bbCount, weight, splitPoints, counters);
        } else {
            Arrays.sort(baseBuffer, 0, bbCount);
            DoublesPmfCdfImpl.linearTimeIncrementHistogramCounters(baseBuffer, 0, bbCount, weight, splitPoints, counters);
        }
        int k = sketch.getK();
        assert (myBitPattern == sketch.getN() / (2L * (long)k));
        int lvl = 0;
        for (myBitPattern = sketch.getBitPattern(); myBitPattern != 0L; myBitPattern >>>= 1) {
            weight += weight;
            if ((myBitPattern & 1L) > 0L) {
                DoublesPmfCdfImpl.linearTimeIncrementHistogramCounters(levelsArr, (2 + lvl) * k, k, weight, splitPoints, counters);
            }
            ++lvl;
        }
        return counters;
    }

    static void bilinearTimeIncrementHistogramCounters(double[] samples, int offset, int numSamples, long weight, double[] splitPoints, long[] counters) {
        assert (splitPoints.length + 1 == counters.length);
        for (int i = 0; i < numSamples; ++i) {
            double splitpoint;
            double sample = samples[i + offset];
            int j = 0;
            for (j = 0; j < splitPoints.length && !(sample < (splitpoint = splitPoints[j])); ++j) {
            }
            assert (j < counters.length);
            int n = j;
            counters[n] = counters[n] + weight;
        }
    }

    static void linearTimeIncrementHistogramCounters(double[] samples, int offset, int numSamples, long weight, double[] splitPoints, long[] counters) {
        int i = 0;
        int j = 0;
        while (i < numSamples && j < splitPoints.length) {
            if (samples[i + offset] < splitPoints[j]) {
                int n = j;
                counters[n] = counters[n] + weight;
                ++i;
                continue;
            }
            ++j;
        }
        if (j == splitPoints.length) {
            int n = j;
            counters[n] = counters[n] + weight * (long)(numSamples - i);
        }
    }
}

