/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import org.apache.pulsar.client.admin.Lookup;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.lookup.data.LookupData;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;

public class LookupImpl
extends BaseResource
implements Lookup {
    private final WebTarget v2lookup;
    private final boolean useTls;

    public LookupImpl(WebTarget web, Authentication auth, boolean useTls, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.useTls = useTls;
        this.v2lookup = web.path("/lookup/v2");
    }

    @Override
    public String lookupTopic(String topic) throws PulsarAdminException {
        TopicName topicName = TopicName.get(topic);
        String prefix = topicName.isV2() ? "/topic" : "/destination";
        WebTarget target = this.v2lookup.path(prefix).path(topicName.getLookupName());
        try {
            return this.doTopicLookup(target);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public String getBundleRange(String topic) throws PulsarAdminException {
        TopicName topicName = TopicName.get(topic);
        String prefix = topicName.isV2() ? "/topic" : "/destination";
        WebTarget target = this.v2lookup.path(prefix).path(topicName.getLookupName()).path("bundle");
        try {
            return this.request(target).get(String.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    private String doTopicLookup(WebTarget lookupResource) throws PulsarAdminException {
        LookupData lookupData = this.request(lookupResource).get(LookupData.class);
        if (this.useTls) {
            return lookupData.getBrokerUrlTls();
        }
        return lookupData.getBrokerUrl();
    }
}

