/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.ConsumerCryptoFailureAction;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.client.api.ReaderBuilder;
import org.apache.pulsar.client.api.ReaderListener;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.conf.ConfigurationDataUtils;
import org.apache.pulsar.client.impl.conf.ReaderConfigurationData;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;

public class ReaderBuilderImpl<T>
implements ReaderBuilder<T> {
    private final PulsarClientImpl client;
    private ReaderConfigurationData<T> conf;
    private final Schema<T> schema;

    public ReaderBuilderImpl(PulsarClientImpl client, Schema<T> schema) {
        this(client, new ReaderConfigurationData(), schema);
    }

    private ReaderBuilderImpl(PulsarClientImpl client, ReaderConfigurationData<T> conf, Schema<T> schema) {
        this.client = client;
        this.conf = conf;
        this.schema = schema;
    }

    public ReaderBuilder<T> clone() {
        return new ReaderBuilderImpl<T>(this.client, this.conf.clone(), this.schema);
    }

    public Reader<T> create() throws PulsarClientException {
        try {
            return this.createAsync().get();
        }
        catch (Exception e) {
            throw PulsarClientException.unwrap((Throwable)e);
        }
    }

    public CompletableFuture<Reader<T>> createAsync() {
        if (this.conf.getTopicName() == null) {
            return FutureUtil.failedFuture(new IllegalArgumentException("Topic name must be set on the reader builder"));
        }
        if (this.conf.getStartMessageId() == null) {
            return FutureUtil.failedFuture(new IllegalArgumentException("Start message id must be set on the reader builder"));
        }
        return this.client.createReaderAsync(this.conf, this.schema);
    }

    public ReaderBuilder<T> loadConf(Map<String, Object> config) {
        MessageId startMessageId = this.conf.getStartMessageId();
        this.conf = ConfigurationDataUtils.loadData(config, this.conf, ReaderConfigurationData.class);
        this.conf.setStartMessageId(startMessageId);
        return this;
    }

    public ReaderBuilder<T> topic(String topicName) {
        this.conf.setTopicName(StringUtils.trim(topicName));
        return this;
    }

    public ReaderBuilder<T> startMessageId(MessageId startMessageId) {
        this.conf.setStartMessageId(startMessageId);
        return this;
    }

    public ReaderBuilder<T> startMessageFromRollbackDuration(long rollbackDuration, TimeUnit timeunit) {
        this.conf.setStartMessageFromRollbackDurationInSec(timeunit.toSeconds(rollbackDuration));
        return this;
    }

    public ReaderBuilder<T> startMessageIdInclusive() {
        this.conf.setResetIncludeHead(true);
        return this;
    }

    public ReaderBuilder<T> readerListener(ReaderListener<T> readerListener) {
        this.conf.setReaderListener(readerListener);
        return this;
    }

    public ReaderBuilder<T> cryptoKeyReader(CryptoKeyReader cryptoKeyReader) {
        this.conf.setCryptoKeyReader(cryptoKeyReader);
        return this;
    }

    public ReaderBuilder<T> cryptoFailureAction(ConsumerCryptoFailureAction action) {
        this.conf.setCryptoFailureAction(action);
        return this;
    }

    public ReaderBuilder<T> receiverQueueSize(int receiverQueueSize) {
        this.conf.setReceiverQueueSize(receiverQueueSize);
        return this;
    }

    public ReaderBuilder<T> readerName(String readerName) {
        this.conf.setReaderName(readerName);
        return this;
    }

    public ReaderBuilder<T> subscriptionRolePrefix(String subscriptionRolePrefix) {
        this.conf.setSubscriptionRolePrefix(subscriptionRolePrefix);
        return this;
    }

    public ReaderBuilder<T> readCompacted(boolean readCompacted) {
        this.conf.setReadCompacted(readCompacted);
        return this;
    }

    public PulsarClientImpl getClient() {
        return this.client;
    }

    public ReaderConfigurationData<T> getConf() {
        return this.conf;
    }

    public Schema<T> getSchema() {
        return this.schema;
    }
}

