/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.apache.pulsar.shade.com.google.common.base.MoreObjects;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;

@ApiModel(value="ClusterData", description="The configuration data for a cluster")
public class ClusterData {
    @ApiModelProperty(name="serviceUrl", value="The HTTP rest service URL (for admin operations)", example="http://pulsar.example.com:8080")
    private String serviceUrl;
    @ApiModelProperty(name="serviceUrlTls", value="The HTTPS rest service URL (for admin operations)", example="https://pulsar.example.com:8443")
    private String serviceUrlTls;
    @ApiModelProperty(name="brokerServiceUrl", value="The broker service url (for produce and consume operations)", example="pulsar://pulsar.example.com:6650")
    private String brokerServiceUrl;
    @ApiModelProperty(name="brokerServiceUrlTls", value="The secured broker service url (for produce and consume operations)", example="pulsar+ssl://pulsar.example.com:6651")
    private String brokerServiceUrlTls;
    @ApiModelProperty(name="peerClusterNames", value="A set of peer cluster names")
    private LinkedHashSet<String> peerClusterNames;

    public ClusterData() {
    }

    public ClusterData(String serviceUrl) {
        this(serviceUrl, "");
    }

    public ClusterData(String serviceUrl, String serviceUrlTls) {
        this.serviceUrl = serviceUrl;
        this.serviceUrlTls = serviceUrlTls;
    }

    public ClusterData(String serviceUrl, String serviceUrlTls, String brokerServiceUrl, String brokerServiceUrlTls) {
        this.serviceUrl = serviceUrl;
        this.serviceUrlTls = serviceUrlTls;
        this.brokerServiceUrl = brokerServiceUrl;
        this.brokerServiceUrlTls = brokerServiceUrlTls;
    }

    public void update(ClusterData other) {
        Preconditions.checkNotNull(other);
        this.serviceUrl = other.serviceUrl;
        this.serviceUrlTls = other.serviceUrlTls;
        this.brokerServiceUrl = other.brokerServiceUrl;
        this.brokerServiceUrlTls = other.brokerServiceUrlTls;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getServiceUrlTls() {
        return this.serviceUrlTls;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public void setServiceUrlTls(String serviceUrlTls) {
        this.serviceUrlTls = serviceUrlTls;
    }

    public String getBrokerServiceUrl() {
        return this.brokerServiceUrl;
    }

    public void setBrokerServiceUrl(String brokerServiceUrl) {
        this.brokerServiceUrl = brokerServiceUrl;
    }

    public String getBrokerServiceUrlTls() {
        return this.brokerServiceUrlTls;
    }

    public void setBrokerServiceUrlTls(String brokerServiceUrlTls) {
        this.brokerServiceUrlTls = brokerServiceUrlTls;
    }

    public LinkedHashSet<String> getPeerClusterNames() {
        return this.peerClusterNames;
    }

    public void setPeerClusterNames(LinkedHashSet<String> peerClusterNames) {
        this.peerClusterNames = peerClusterNames;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClusterData) {
            ClusterData other = (ClusterData)obj;
            return Objects.equals(this.serviceUrl, other.serviceUrl) && Objects.equals(this.serviceUrlTls, other.serviceUrlTls) && Objects.equals(this.brokerServiceUrl, other.brokerServiceUrl) && Objects.equals(this.brokerServiceUrlTls, other.brokerServiceUrlTls);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.toString());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("serviceUrl", this.serviceUrl).add("serviceUrlTls", this.serviceUrlTls).add("brokerServiceUrl", this.brokerServiceUrl).add("brokerServiceUrlTls", this.brokerServiceUrlTls).add("peerClusterNames", this.peerClusterNames).toString();
    }
}

