package org.apache.pulsar.common.api.proto;
public final class CommandCloseProducer {
	private long producerId;
	private static final int _PRODUCER_ID_FIELD_NUMBER = 1;
	private static final int _PRODUCER_ID_TAG = (_PRODUCER_ID_FIELD_NUMBER << LightProtoCodec.TAG_TYPE_BITS)
			| LightProtoCodec.WIRETYPE_VARINT;
	private static final int _PRODUCER_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(_PRODUCER_ID_TAG);
	private static final int _PRODUCER_ID_MASK = 1 << (0 % 32);
	public boolean hasProducerId() {
		return (_bitField0 & _PRODUCER_ID_MASK) != 0;
	}
	public long getProducerId() {
		if (!hasProducerId()) {
			throw new IllegalStateException("Field 'producer_id' is not set");
		}
		return producerId;
	}
	public CommandCloseProducer setProducerId(long producerId) {
		this.producerId = producerId;
		_bitField0 |= _PRODUCER_ID_MASK;
		_cachedSize = -1;
		return this;
	}
	public CommandCloseProducer clearProducerId() {
		_bitField0 &= ~_PRODUCER_ID_MASK;
		return this;
	}

	private long requestId;
	private static final int _REQUEST_ID_FIELD_NUMBER = 2;
	private static final int _REQUEST_ID_TAG = (_REQUEST_ID_FIELD_NUMBER << LightProtoCodec.TAG_TYPE_BITS)
			| LightProtoCodec.WIRETYPE_VARINT;
	private static final int _REQUEST_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(_REQUEST_ID_TAG);
	private static final int _REQUEST_ID_MASK = 1 << (1 % 32);
	public boolean hasRequestId() {
		return (_bitField0 & _REQUEST_ID_MASK) != 0;
	}
	public long getRequestId() {
		if (!hasRequestId()) {
			throw new IllegalStateException("Field 'request_id' is not set");
		}
		return requestId;
	}
	public CommandCloseProducer setRequestId(long requestId) {
		this.requestId = requestId;
		_bitField0 |= _REQUEST_ID_MASK;
		_cachedSize = -1;
		return this;
	}
	public CommandCloseProducer clearRequestId() {
		_bitField0 &= ~_REQUEST_ID_MASK;
		return this;
	}

	private String assignedBrokerServiceUrl;
	private int _assignedBrokerServiceUrlBufferIdx = -1;
	private int _assignedBrokerServiceUrlBufferLen = -1;
	private static final int _ASSIGNED_BROKER_SERVICE_URL_FIELD_NUMBER = 3;
	private static final int _ASSIGNED_BROKER_SERVICE_URL_TAG = (_ASSIGNED_BROKER_SERVICE_URL_FIELD_NUMBER << LightProtoCodec.TAG_TYPE_BITS)
			| LightProtoCodec.WIRETYPE_LENGTH_DELIMITED;
	private static final int _ASSIGNED_BROKER_SERVICE_URL_TAG_SIZE = LightProtoCodec
			.computeVarIntSize(_ASSIGNED_BROKER_SERVICE_URL_TAG);
	private static final int _ASSIGNED_BROKER_SERVICE_URL_MASK = 1 << (2 % 32);
	public boolean hasAssignedBrokerServiceUrl() {
		return (_bitField0 & _ASSIGNED_BROKER_SERVICE_URL_MASK) != 0;
	}
	public String getAssignedBrokerServiceUrl() {
		if (!hasAssignedBrokerServiceUrl()) {
			throw new IllegalStateException("Field 'assignedBrokerServiceUrl' is not set");
		}
		if (assignedBrokerServiceUrl == null) {
			assignedBrokerServiceUrl = LightProtoCodec.readString(_parsedBuffer, _assignedBrokerServiceUrlBufferIdx,
					_assignedBrokerServiceUrlBufferLen);
		}
		return assignedBrokerServiceUrl;
	}
	public CommandCloseProducer setAssignedBrokerServiceUrl(String assignedBrokerServiceUrl) {
		this.assignedBrokerServiceUrl = assignedBrokerServiceUrl;
		_bitField0 |= _ASSIGNED_BROKER_SERVICE_URL_MASK;
		_assignedBrokerServiceUrlBufferIdx = -1;
		_assignedBrokerServiceUrlBufferLen = LightProtoCodec.computeStringUTF8Size(assignedBrokerServiceUrl);
		_cachedSize = -1;
		return this;
	}
	public CommandCloseProducer clearAssignedBrokerServiceUrl() {
		_bitField0 &= ~_ASSIGNED_BROKER_SERVICE_URL_MASK;
		assignedBrokerServiceUrl = null;
		_assignedBrokerServiceUrlBufferIdx = -1;
		_assignedBrokerServiceUrlBufferLen = -1;
		return this;
	}

	private String assignedBrokerServiceUrlTls;
	private int _assignedBrokerServiceUrlTlsBufferIdx = -1;
	private int _assignedBrokerServiceUrlTlsBufferLen = -1;
	private static final int _ASSIGNED_BROKER_SERVICE_URL_TLS_FIELD_NUMBER = 4;
	private static final int _ASSIGNED_BROKER_SERVICE_URL_TLS_TAG = (_ASSIGNED_BROKER_SERVICE_URL_TLS_FIELD_NUMBER << LightProtoCodec.TAG_TYPE_BITS)
			| LightProtoCodec.WIRETYPE_LENGTH_DELIMITED;
	private static final int _ASSIGNED_BROKER_SERVICE_URL_TLS_TAG_SIZE = LightProtoCodec
			.computeVarIntSize(_ASSIGNED_BROKER_SERVICE_URL_TLS_TAG);
	private static final int _ASSIGNED_BROKER_SERVICE_URL_TLS_MASK = 1 << (3 % 32);
	public boolean hasAssignedBrokerServiceUrlTls() {
		return (_bitField0 & _ASSIGNED_BROKER_SERVICE_URL_TLS_MASK) != 0;
	}
	public String getAssignedBrokerServiceUrlTls() {
		if (!hasAssignedBrokerServiceUrlTls()) {
			throw new IllegalStateException("Field 'assignedBrokerServiceUrlTls' is not set");
		}
		if (assignedBrokerServiceUrlTls == null) {
			assignedBrokerServiceUrlTls = LightProtoCodec.readString(_parsedBuffer,
					_assignedBrokerServiceUrlTlsBufferIdx, _assignedBrokerServiceUrlTlsBufferLen);
		}
		return assignedBrokerServiceUrlTls;
	}
	public CommandCloseProducer setAssignedBrokerServiceUrlTls(String assignedBrokerServiceUrlTls) {
		this.assignedBrokerServiceUrlTls = assignedBrokerServiceUrlTls;
		_bitField0 |= _ASSIGNED_BROKER_SERVICE_URL_TLS_MASK;
		_assignedBrokerServiceUrlTlsBufferIdx = -1;
		_assignedBrokerServiceUrlTlsBufferLen = LightProtoCodec.computeStringUTF8Size(assignedBrokerServiceUrlTls);
		_cachedSize = -1;
		return this;
	}
	public CommandCloseProducer clearAssignedBrokerServiceUrlTls() {
		_bitField0 &= ~_ASSIGNED_BROKER_SERVICE_URL_TLS_MASK;
		assignedBrokerServiceUrlTls = null;
		_assignedBrokerServiceUrlTlsBufferIdx = -1;
		_assignedBrokerServiceUrlTlsBufferLen = -1;
		return this;
	}

	private int _bitField0;
	private static final int _REQUIRED_FIELDS_MASK0 = 0 | _PRODUCER_ID_MASK | _REQUEST_ID_MASK;
	public int writeTo(org.apache.pulsar.shade.io.netty.buffer.ByteBuf _b) {
		checkRequiredFields();
		int _writeIdx = _b.writerIndex();
		LightProtoCodec.writeVarInt(_b, _PRODUCER_ID_TAG);
		LightProtoCodec.writeVarInt64(_b, producerId);
		LightProtoCodec.writeVarInt(_b, _REQUEST_ID_TAG);
		LightProtoCodec.writeVarInt64(_b, requestId);
		if (hasAssignedBrokerServiceUrl()) {
			LightProtoCodec.writeVarInt(_b, _ASSIGNED_BROKER_SERVICE_URL_TAG);
			LightProtoCodec.writeVarInt(_b, _assignedBrokerServiceUrlBufferLen);
			if (_assignedBrokerServiceUrlBufferIdx == -1) {
				LightProtoCodec.writeString(_b, assignedBrokerServiceUrl, _assignedBrokerServiceUrlBufferLen);
			} else {
				_parsedBuffer.getBytes(_assignedBrokerServiceUrlBufferIdx, _b, _assignedBrokerServiceUrlBufferLen);
			}
		}
		if (hasAssignedBrokerServiceUrlTls()) {
			LightProtoCodec.writeVarInt(_b, _ASSIGNED_BROKER_SERVICE_URL_TLS_TAG);
			LightProtoCodec.writeVarInt(_b, _assignedBrokerServiceUrlTlsBufferLen);
			if (_assignedBrokerServiceUrlTlsBufferIdx == -1) {
				LightProtoCodec.writeString(_b, assignedBrokerServiceUrlTls, _assignedBrokerServiceUrlTlsBufferLen);
			} else {
				_parsedBuffer.getBytes(_assignedBrokerServiceUrlTlsBufferIdx, _b,
						_assignedBrokerServiceUrlTlsBufferLen);
			}
		}
		return (_b.writerIndex() - _writeIdx);
	}
	public int getSerializedSize() {
		if (_cachedSize > -1) {
			return _cachedSize;
		}

		int _size = 0;
		_size += _PRODUCER_ID_TAG_SIZE;
		_size += LightProtoCodec.computeVarInt64Size(producerId);
		_size += _REQUEST_ID_TAG_SIZE;
		_size += LightProtoCodec.computeVarInt64Size(requestId);
		if (hasAssignedBrokerServiceUrl()) {
			_size += _ASSIGNED_BROKER_SERVICE_URL_TAG_SIZE;
			_size += LightProtoCodec.computeVarIntSize(_assignedBrokerServiceUrlBufferLen);
			_size += _assignedBrokerServiceUrlBufferLen;
		}
		if (hasAssignedBrokerServiceUrlTls()) {
			_size += _ASSIGNED_BROKER_SERVICE_URL_TLS_TAG_SIZE;
			_size += LightProtoCodec.computeVarIntSize(_assignedBrokerServiceUrlTlsBufferLen);
			_size += _assignedBrokerServiceUrlTlsBufferLen;
		}
		_cachedSize = _size;
		return _size;
	}
	public void parseFrom(org.apache.pulsar.shade.io.netty.buffer.ByteBuf _buffer, int _size) {
		clear();
		int _endIdx = _buffer.readerIndex() + _size;
		while (_buffer.readerIndex() < _endIdx) {
			int _tag = LightProtoCodec.readVarInt(_buffer);
			switch (_tag) {
				case _PRODUCER_ID_TAG :
					_bitField0 |= _PRODUCER_ID_MASK;
					producerId = LightProtoCodec.readVarInt64(_buffer);
					break;
				case _REQUEST_ID_TAG :
					_bitField0 |= _REQUEST_ID_MASK;
					requestId = LightProtoCodec.readVarInt64(_buffer);
					break;
				case _ASSIGNED_BROKER_SERVICE_URL_TAG :
					_bitField0 |= _ASSIGNED_BROKER_SERVICE_URL_MASK;
					_assignedBrokerServiceUrlBufferLen = LightProtoCodec.readVarInt(_buffer);
					_assignedBrokerServiceUrlBufferIdx = _buffer.readerIndex();
					_buffer.skipBytes(_assignedBrokerServiceUrlBufferLen);
					break;
				case _ASSIGNED_BROKER_SERVICE_URL_TLS_TAG :
					_bitField0 |= _ASSIGNED_BROKER_SERVICE_URL_TLS_MASK;
					_assignedBrokerServiceUrlTlsBufferLen = LightProtoCodec.readVarInt(_buffer);
					_assignedBrokerServiceUrlTlsBufferIdx = _buffer.readerIndex();
					_buffer.skipBytes(_assignedBrokerServiceUrlTlsBufferLen);
					break;
				default :
					LightProtoCodec.skipUnknownField(_tag, _buffer);
			}
		}
		checkRequiredFields();
		_parsedBuffer = _buffer;
	}
	private void checkRequiredFields() {
		if ((_bitField0 & _REQUIRED_FIELDS_MASK0) != _REQUIRED_FIELDS_MASK0) {
			throw new IllegalStateException("Some required fields are missing");
		}
	}
	public CommandCloseProducer clear() {
		assignedBrokerServiceUrl = null;
		_assignedBrokerServiceUrlBufferIdx = -1;
		_assignedBrokerServiceUrlBufferLen = -1;
		assignedBrokerServiceUrlTls = null;
		_assignedBrokerServiceUrlTlsBufferIdx = -1;
		_assignedBrokerServiceUrlTlsBufferLen = -1;
		_parsedBuffer = null;
		_cachedSize = -1;
		_bitField0 = 0;
		return this;
	}
	public CommandCloseProducer copyFrom(CommandCloseProducer _other) {
		_cachedSize = -1;
		if (_other.hasProducerId()) {
			setProducerId(_other.producerId);
		}
		if (_other.hasRequestId()) {
			setRequestId(_other.requestId);
		}
		if (_other.hasAssignedBrokerServiceUrl()) {
			setAssignedBrokerServiceUrl(_other.getAssignedBrokerServiceUrl());
		}
		if (_other.hasAssignedBrokerServiceUrlTls()) {
			setAssignedBrokerServiceUrlTls(_other.getAssignedBrokerServiceUrlTls());
		}
		return this;
	}
	public byte[] toByteArray() {
		byte[] a = new byte[getSerializedSize()];
		io.netty.buffer.ByteBuf b = io.netty.buffer.Unpooled.wrappedBuffer(a).writerIndex(0);
		this.writeTo(b);
		return a;
	}
	public void parseFrom(byte[] a) {
		io.netty.buffer.ByteBuf b = io.netty.buffer.Unpooled.wrappedBuffer(a);
		this.parseFrom(b, b.readableBytes());
	}
	private int _cachedSize;

	private org.apache.pulsar.shade.io.netty.buffer.ByteBuf _parsedBuffer;

}
