package org.apache.pulsar.shade.org.checkerframework.checker.lock.qual;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.pulsar.shade.org.checkerframework.framework.qual.InvisibleQualifier;
import org.apache.pulsar.shade.org.checkerframework.framework.qual.SubtypeOf;

/**
 * Indicates that an expression is used as a lock and the lock is known to be held on the current
 * thread.
 *
 * <p>This annotation may not be written in source code; it is an implementation detail of the
 * checker.
 *
 * @see LockPossiblyHeld
 * @checker_framework.manual #lock-checker Lock Checker
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({})
@SubtypeOf(LockPossiblyHeld.class) // This is the bottom type in this hierarchy
@InvisibleQualifier
public @interface LockHeld {}
