/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.auth;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.naming.AuthenticationException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.pulsar.common.api.AuthData;
import org.apache.pulsar.common.sasl.KerberosName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarSaslClient {
    private static final Logger log = LoggerFactory.getLogger(PulsarSaslClient.class);
    private final SaslClient saslClient;
    private final Subject clientSubject;

    public PulsarSaslClient(String serverHostname, String serverType, Subject subject) throws SaslException {
        Preconditions.checkArgument((subject != null ? 1 : 0) != 0, (Object)"Cannot create SASL client with NULL JAAS subject");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)serverHostname) ? 1 : 0) != 0, (Object)"Cannot create SASL client with NUll server name");
        if (!serverType.equals("broker") && !serverType.equals("proxy")) {
            log.warn("The server type {} is not recommended", (Object)serverType);
        }
        String serverPrincipal = serverType.toLowerCase() + "/" + serverHostname;
        this.clientSubject = subject;
        if (this.clientSubject.getPrincipals().isEmpty()) {
            throw new SaslException("Cannot create SASL client with empty JAAS subject principal");
        }
        Object[] principals = this.clientSubject.getPrincipals().toArray();
        Principal clientPrincipal = (Principal)principals[0];
        KerberosName clientKerberosName = new KerberosName(clientPrincipal.getName());
        KerberosName serviceKerberosName = new KerberosName(serverPrincipal + "@" + clientKerberosName.getRealm());
        final String serviceName = serviceKerberosName.getServiceName();
        final String serviceHostname = serviceKerberosName.getHostName();
        final String clientPrincipalName = clientKerberosName.toString();
        log.info("Using JAAS/SASL/GSSAPI auth to connect to server Principal {},", (Object)serverPrincipal);
        try {
            this.saslClient = Subject.doAs(this.clientSubject, new PrivilegedExceptionAction<SaslClient>(){

                @Override
                public SaslClient run() throws SaslException {
                    String[] mechs = new String[]{"GSSAPI"};
                    return Sasl.createSaslClient(mechs, clientPrincipalName, serviceName, serviceHostname, null, new ClientCallbackHandler());
                }
            });
        }
        catch (PrivilegedActionException err) {
            log.error("GSSAPI client error", err.getCause());
            throw new SaslException("error while booting GSSAPI client", err.getCause());
        }
        if (this.saslClient == null) {
            throw new SaslException("Cannot create JVM SASL Client");
        }
    }

    public AuthData evaluateChallenge(final AuthData saslToken) throws AuthenticationException {
        if (saslToken == null) {
            throw new AuthenticationException("saslToken is null");
        }
        try {
            if (this.clientSubject != null) {
                byte[] retval = Subject.doAs(this.clientSubject, new PrivilegedExceptionAction<byte[]>(){

                    @Override
                    public byte[] run() throws SaslException {
                        return PulsarSaslClient.this.saslClient.evaluateChallenge(saslToken.getBytes());
                    }
                });
                return AuthData.of((byte[])retval);
            }
            return AuthData.of((byte[])this.saslClient.evaluateChallenge(saslToken.getBytes()));
        }
        catch (Exception e) {
            log.error("SASL error", e.getCause());
            throw new AuthenticationException("SASL/JAAS error" + e.getCause());
        }
    }

    public boolean hasInitialResponse() {
        return this.saslClient.hasInitialResponse();
    }

    public boolean isComplete() {
        return this.saslClient.isComplete();
    }

    static class ClientCallbackHandler
    implements CallbackHandler {
        ClientCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (!(callback instanceof AuthorizeCallback)) {
                    throw new UnsupportedCallbackException(callback, "Unrecognized SASL GSSAPI Client Callback.");
                }
                this.handleAuthorizeCallback((AuthorizeCallback)callback);
            }
        }

        private void handleAuthorizeCallback(AuthorizeCallback ac) {
            String authzid;
            String authid = ac.getAuthenticationID();
            if (authid.equals(authzid = ac.getAuthorizationID())) {
                ac.setAuthorized(true);
            } else {
                ac.setAuthorized(false);
            }
            if (ac.isAuthorized()) {
                ac.setAuthorizedID(authzid);
            }
            log.info("Successfully authenticated. authenticationID: {};  authorizationID: {}.", (Object)authid, (Object)authzid);
        }
    }
}

