/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.reactive.client.adapter;

import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.impl.Murmur3Hash32;
import org.apache.pulsar.reactive.client.api.MessageGroupingFunction;

public class DefaultMessageGroupingFunction
implements MessageGroupingFunction {
    private static byte[] getMessageKeyBytes(Message<?> message) {
        byte[] keyBytes = null;
        if (message.hasOrderingKey()) {
            keyBytes = message.getOrderingKey();
        } else if (message.hasKey()) {
            keyBytes = message.getKeyBytes();
        }
        if (keyBytes == null || keyBytes.length == 0) {
            keyBytes = message.getMessageId().toByteArray();
        }
        return keyBytes;
    }

    public int resolveProcessingGroup(Message<?> message, int numberOfGroups) {
        byte[] keyBytes = DefaultMessageGroupingFunction.getMessageKeyBytes(message);
        int keyHash = Murmur3Hash32.getInstance().makeHash(keyBytes);
        return keyHash % numberOfGroups;
    }
}

