/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.reactive.client.internal.adapter;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.pulsar.client.api.PulsarClientException;
import reactor.core.publisher.Mono;

final class PulsarFutureAdapter {
    private volatile boolean cancelled;
    private volatile CompletableFuture<?> futureReference;

    private PulsarFutureAdapter() {
    }

    static <T> Mono<T> adaptPulsarFuture(Supplier<? extends CompletableFuture<T>> futureSupplier) {
        return Mono.defer(() -> new PulsarFutureAdapter().toMono(futureSupplier));
    }

    private static void handleException(boolean cancelled, Throwable e) {
        if (cancelled) {
            PulsarFutureAdapter.rethrowIfRelevantException(e);
        } else {
            PulsarFutureAdapter.sneakyThrow(e);
        }
    }

    private static boolean isAlreadyClosedCause(Throwable e) {
        return e instanceof PulsarClientException.AlreadyClosedException || e.getCause() instanceof PulsarClientException.AlreadyClosedException;
    }

    private static void rethrowIfRelevantException(Throwable e) {
        if (!PulsarFutureAdapter.isAlreadyClosedCause(e) && !(e instanceof CancellationException)) {
            PulsarFutureAdapter.sneakyThrow(e);
        }
    }

    private static <E extends Throwable> void sneakyThrow(Throwable e) throws E {
        throw e;
    }

    <T> Mono<? extends T> toMono(Supplier<? extends CompletableFuture<T>> futureSupplier) {
        return Mono.fromFuture(() -> this.createFuture(futureSupplier)).doOnCancel(this::doOnCancel);
    }

    private <T> CompletableFuture<T> createFuture(Supplier<? extends CompletableFuture<T>> futureSupplier) {
        try {
            CompletableFuture<T> future = futureSupplier.get();
            this.futureReference = future;
            return future.exceptionally(ex -> {
                PulsarFutureAdapter.handleException(this.cancelled, ex);
                return null;
            });
        }
        catch (Exception ex2) {
            PulsarFutureAdapter.handleException(this.cancelled, ex2);
            return CompletableFuture.completedFuture(null);
        }
    }

    private void doOnCancel() {
        this.cancelled = true;
        CompletableFuture<?> future = this.futureReference;
        if (future != null) {
            future.cancel(false);
        }
    }
}

