/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.reactive.client.internal.adapter;

import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.reactive.client.adapter.ProducerCacheProvider;
import org.apache.pulsar.reactive.client.adapter.ProducerCacheProviderFactory;
import org.apache.pulsar.reactive.client.api.ReactiveMessageSenderCache;
import org.apache.pulsar.reactive.client.api.ReactivePulsarClient;
import org.apache.pulsar.reactive.client.internal.adapter.ConcurrentHashMapProducerCacheProvider;
import org.apache.pulsar.reactive.client.internal.adapter.ProducerCache;
import org.apache.pulsar.reactive.client.internal.adapter.PulsarFutureAdapter;
import org.apache.pulsar.reactive.client.internal.adapter.ReactivePulsarResourceAdapter;
import org.apache.pulsar.reactive.client.internal.adapter.ReactivePulsarResourceAdapterPulsarClient;
import reactor.core.publisher.Mono;

public final class AdapterImplementationFactory {
    private static final ProducerCacheProviderFactory PRODUCER_CACHE_PROVIDER_FACTORY;

    private AdapterImplementationFactory() {
    }

    public static ReactivePulsarClient createReactivePulsarClient(Supplier<PulsarClient> pulsarClientSupplier) {
        return new ReactivePulsarResourceAdapterPulsarClient(new ReactivePulsarResourceAdapter(pulsarClientSupplier));
    }

    public static <T> Mono<T> adaptPulsarFuture(Supplier<? extends CompletableFuture<T>> futureSupplier) {
        return PulsarFutureAdapter.adaptPulsarFuture(futureSupplier);
    }

    public static ReactiveMessageSenderCache createCache(ProducerCacheProvider producerCacheProvider) {
        return new ProducerCache(producerCacheProvider);
    }

    public static ReactiveMessageSenderCache createCache() {
        return new ProducerCache(PRODUCER_CACHE_PROVIDER_FACTORY != null ? (ProducerCacheProvider)PRODUCER_CACHE_PROVIDER_FACTORY.get() : new ConcurrentHashMapProducerCacheProvider());
    }

    static {
        Iterator<ProducerCacheProviderFactory> iterator = ServiceLoader.load(ProducerCacheProviderFactory.class).iterator();
        PRODUCER_CACHE_PROVIDER_FACTORY = iterator.hasNext() ? iterator.next() : null;
    }
}

