/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.google.common.annotations.VisibleForTesting;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.admin.cli.CmdBookies;
import org.apache.pulsar.admin.cli.CmdBrokerStats;
import org.apache.pulsar.admin.cli.CmdBrokers;
import org.apache.pulsar.admin.cli.CmdClusters;
import org.apache.pulsar.admin.cli.CmdFunctionWorker;
import org.apache.pulsar.admin.cli.CmdFunctions;
import org.apache.pulsar.admin.cli.CmdGenerateDocument;
import org.apache.pulsar.admin.cli.CmdNamespaceIsolationPolicy;
import org.apache.pulsar.admin.cli.CmdNamespaces;
import org.apache.pulsar.admin.cli.CmdNonPersistentTopics;
import org.apache.pulsar.admin.cli.CmdPackages;
import org.apache.pulsar.admin.cli.CmdPersistentTopics;
import org.apache.pulsar.admin.cli.CmdProxyStats;
import org.apache.pulsar.admin.cli.CmdResourceGroups;
import org.apache.pulsar.admin.cli.CmdResourceQuotas;
import org.apache.pulsar.admin.cli.CmdSchemas;
import org.apache.pulsar.admin.cli.CmdSinks;
import org.apache.pulsar.admin.cli.CmdSources;
import org.apache.pulsar.admin.cli.CmdTenants;
import org.apache.pulsar.admin.cli.CmdTopicPolicies;
import org.apache.pulsar.admin.cli.CmdTopics;
import org.apache.pulsar.admin.cli.CmdTransactions;
import org.apache.pulsar.admin.cli.CustomCommandsUtils;
import org.apache.pulsar.admin.cli.PulsarAdminPropertiesProvider;
import org.apache.pulsar.admin.cli.PulsarAdminSupplier;
import org.apache.pulsar.admin.cli.PulsarVersionProvider;
import org.apache.pulsar.admin.cli.extensions.CommandExecutionContext;
import org.apache.pulsar.admin.cli.extensions.CustomCommandFactory;
import org.apache.pulsar.admin.cli.extensions.CustomCommandGroup;
import org.apache.pulsar.admin.cli.utils.CustomCommandFactoryProvider;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminBuilder;
import org.apache.pulsar.common.util.ShutdownUtil;
import org.apache.pulsar.internal.CommandHook;
import org.apache.pulsar.internal.CommanderFactory;
import picocli.CommandLine;

@CommandLine.Command(name="pulsar-admin", scope=CommandLine.ScopeType.INHERIT, mixinStandardHelpOptions=true, showDefaultValues=true, versionProvider=PulsarVersionProvider.class)
public class PulsarAdminTool
implements CommandHook {
    protected static boolean allowSystemExit = true;
    private static int lastExitCode = Integer.MIN_VALUE;
    protected List<CustomCommandFactory> customCommandFactories;
    protected Map<String, Class<?>> commandMap;
    protected final CommandLine commander;
    @CommandLine.ArgGroup(heading="Options:%n", exclusive=false)
    protected RootParams rootParams = new RootParams();
    protected PulsarAdminSupplier pulsarAdminSupplier;
    private PulsarAdminPropertiesProvider pulsarAdminPropertiesProvider;

    public PulsarAdminTool(Properties properties) throws Exception {
        System.setProperty("picocli.version.name.0", "-v");
        this.commander = CommanderFactory.createRootCommanderWithHook(this, (CommandLine.IDefaultValueProvider)this.pulsarAdminPropertiesProvider);
        this.pulsarAdminSupplier = new PulsarAdminSupplier(PulsarAdminTool.createAdminBuilderFromProperties(properties), this.rootParams);
        this.initCommander(properties);
    }

    private static PulsarAdminBuilder createAdminBuilderFromProperties(Properties properties) {
        boolean useKeyStoreTls = Boolean.parseBoolean(properties.getProperty("useKeyStoreTls", "false"));
        String tlsTrustStoreType = properties.getProperty("tlsTrustStoreType", "JKS");
        String tlsTrustStorePath = properties.getProperty("tlsTrustStorePath");
        String tlsTrustStorePassword = properties.getProperty("tlsTrustStorePassword");
        String tlsKeyStoreType = properties.getProperty("tlsKeyStoreType", "JKS");
        String tlsKeyStorePath = properties.getProperty("tlsKeyStorePath");
        String tlsKeyStorePassword = properties.getProperty("tlsKeyStorePassword");
        String tlsKeyFilePath = properties.getProperty("tlsKeyFilePath");
        String tlsCertificateFilePath = properties.getProperty("tlsCertificateFilePath");
        boolean tlsAllowInsecureConnection = Boolean.parseBoolean(properties.getProperty("tlsAllowInsecureConnection", "false"));
        boolean tlsEnableHostnameVerification = Boolean.parseBoolean(properties.getProperty("tlsEnableHostnameVerification", "false"));
        String tlsTrustCertsFilePath = properties.getProperty("tlsTrustCertsFilePath");
        return PulsarAdmin.builder().allowTlsInsecureConnection(tlsAllowInsecureConnection).enableTlsHostnameVerification(tlsEnableHostnameVerification).tlsTrustCertsFilePath(tlsTrustCertsFilePath).useKeyStoreTls(useKeyStoreTls).tlsTrustStoreType(tlsTrustStoreType).tlsTrustStorePath(tlsTrustStorePath).tlsTrustStorePassword(tlsTrustStorePassword).tlsKeyStoreType(tlsKeyStoreType).tlsKeyStorePath(tlsKeyStorePath).tlsKeyStorePassword(tlsKeyStorePassword).tlsKeyFilePath(tlsKeyFilePath).tlsCertificateFilePath(tlsCertificateFilePath);
    }

    /*
     * WARNING - void declaration
     */
    private void setupCommands(final Properties properties) {
        try {
            for (Map.Entry<String, Class<?>> entry : this.commandMap.entrySet()) {
                Object o = entry.getValue().getConstructor(Supplier.class).newInstance(this.pulsarAdminSupplier);
                this.addCommand(entry.getKey(), o);
            }
            CommandExecutionContext context = new CommandExecutionContext(){

                public PulsarAdmin getPulsarAdmin() {
                    return PulsarAdminTool.this.pulsarAdminSupplier.get();
                }

                public Properties getConfiguration() {
                    return properties;
                }
            };
            for (CustomCommandFactory factory : this.customCommandFactories) {
                List customCommandGroups = factory.commandGroups(context);
                for (CustomCommandGroup group : customCommandGroups) {
                    Object generated = CustomCommandsUtils.generateCliCommand(group, context, this.pulsarAdminSupplier);
                    this.addCommand(group.name(), generated);
                }
            }
        }
        catch (Exception e) {
            void var3_8;
            if (e instanceof InvocationTargetException && null != e.getCause()) {
                Throwable throwable = e.getCause();
            } else {
                Exception exception = e;
            }
            System.err.println(var3_8.getClass() + ": " + var3_8.getMessage());
            System.exit(1);
        }
    }

    private void addCommand(String name, Object o) throws Exception {
        if (o instanceof CmdBase) {
            this.commander.addSubcommand(name, (Object)((CmdBase)o).getCommander());
        } else {
            this.commander.addSubcommand(o);
        }
    }

    protected boolean run(String[] args) {
        return this.commander.execute(args) == 0;
    }

    public static void main(String[] args) throws Exception {
        PulsarAdminTool.execute(args);
    }

    @VisibleForTesting
    public static PulsarAdminTool execute(String[] args) throws Exception {
        PulsarAdminTool tool;
        lastExitCode = 0;
        if (args.length == 0) {
            System.out.println("Usage: pulsar-admin CONF_FILE_PATH [options] [command] [command options]");
            PulsarAdminTool.exit(0);
            return null;
        }
        String configFile = args[0];
        Properties properties = new Properties();
        if (configFile != null) {
            try (FileInputStream fis = new FileInputStream(configFile);){
                properties.load(fis);
            }
        }
        if ((tool = new PulsarAdminTool(properties)).run(args = Arrays.copyOfRange(args, 1, args.length))) {
            PulsarAdminTool.exit(0);
        } else {
            PulsarAdminTool.exit(1);
        }
        return tool;
    }

    private static void exit(int code) {
        lastExitCode = code;
        if (allowSystemExit) {
            ShutdownUtil.triggerImmediateForcefulShutdown((int)code, (boolean)false);
        } else {
            System.out.println("Exit code is " + code + " (System.exit not called, as we are in test mode)");
        }
    }

    static void setAllowSystemExit(boolean allowSystemExit) {
        PulsarAdminTool.allowSystemExit = allowSystemExit;
    }

    static int getLastExitCode() {
        return lastExitCode;
    }

    @VisibleForTesting
    static void resetLastExitCode() {
        lastExitCode = Integer.MIN_VALUE;
    }

    @Override
    public int preRun() {
        if (StringUtils.isBlank((CharSequence)this.rootParams.serviceUrl)) {
            this.commander.getErr().println("Can't find any admin url to use");
            return 1;
        }
        this.pulsarAdminSupplier.rootParamsUpdated(this.rootParams);
        return 0;
    }

    private void initCommander(Properties properties) throws IOException {
        this.customCommandFactories = CustomCommandFactoryProvider.createCustomCommandFactories(properties);
        this.pulsarAdminPropertiesProvider = PulsarAdminPropertiesProvider.create(properties);
        this.commander.setDefaultValueProvider((CommandLine.IDefaultValueProvider)this.pulsarAdminPropertiesProvider);
        this.commandMap = new HashMap();
        this.commandMap.put("clusters", CmdClusters.class);
        this.commandMap.put("ns-isolation-policy", CmdNamespaceIsolationPolicy.class);
        this.commandMap.put("brokers", CmdBrokers.class);
        this.commandMap.put("broker-stats", CmdBrokerStats.class);
        this.commandMap.put("tenants", CmdTenants.class);
        this.commandMap.put("resourcegroups", CmdResourceGroups.class);
        this.commandMap.put("properties", CmdTenants.CmdProperties.class);
        this.commandMap.put("namespaces", CmdNamespaces.class);
        this.commandMap.put("topics", CmdTopics.class);
        this.commandMap.put("topicPolicies", CmdTopicPolicies.class);
        this.commandMap.put("schemas", CmdSchemas.class);
        this.commandMap.put("bookies", CmdBookies.class);
        this.commandMap.put("persistent", CmdPersistentTopics.class);
        this.commandMap.put("non-persistent", CmdNonPersistentTopics.class);
        this.commandMap.put("resource-quotas", CmdResourceQuotas.class);
        this.commandMap.put("proxy-stats", CmdProxyStats.class);
        this.commandMap.put("functions", CmdFunctions.class);
        this.commandMap.put("functions-worker", CmdFunctionWorker.class);
        this.commandMap.put("sources", CmdSources.class);
        this.commandMap.put("sinks", CmdSinks.class);
        this.commandMap.put("documents", CmdGenerateDocument.class);
        this.commandMap.put("packages", CmdPackages.class);
        this.commandMap.put("transactions", CmdTransactions.class);
        this.setupCommands(properties);
    }

    @VisibleForTesting
    public PulsarAdminSupplier getPulsarAdminSupplier() {
        return this.pulsarAdminSupplier;
    }

    protected void setCommandName(String name) {
        this.commander.setCommandName(name);
    }

    protected String getAdminUrl() {
        return this.pulsarAdminPropertiesProvider.getAdminUrl();
    }

    public static class RootParams {
        @CommandLine.Option(names={"--admin-url"}, description={"Admin Service URL to which to connect."}, descriptionKey="webServiceUrl")
        String serviceUrl = null;
        @CommandLine.Option(names={"--auth-plugin"}, description={"Authentication plugin class name."}, descriptionKey="authPlugin")
        String authPluginClassName = null;
        @CommandLine.Option(names={"--request-timeout"}, description={"Request time out in seconds for the pulsar admin client for any request"})
        int requestTimeout = 300;
        @CommandLine.Option(names={"--auth-params"}, descriptionKey="authParams", description={"Authentication parameters, whose format is determined by the implementation of method `configure` in authentication plugin class, for example \"key1:val1,key2:val2\" or \"{\"key1\":\"val1\",\"key2\":\"val2\"}\"."})
        String authParams = null;
        @CommandLine.Option(names={"--tls-allow-insecure"}, description={"Allow TLS insecure connection"})
        Boolean tlsAllowInsecureConnection;
        @CommandLine.Option(names={"--tls-trust-cert-path"}, description={"Allow TLS trust cert file path"})
        String tlsTrustCertsFilePath;
        @CommandLine.Option(names={"--tls-enable-hostname-verification"}, description={"Enable TLS common name verification"})
        Boolean tlsEnableHostnameVerification;
        @CommandLine.Option(names={"--tls-provider"}, description={"Set up TLS provider. When TLS authentication with CACert is used, the valid value is either OPENSSL or JDK. When TLS authentication with KeyStore is used, available options can be SunJSSE, Conscrypt and so on."}, descriptionKey="webserviceTlsProvider")
        String tlsProvider;

        @Generated
        public String getServiceUrl() {
            return this.serviceUrl;
        }

        @Generated
        public String getAuthPluginClassName() {
            return this.authPluginClassName;
        }

        @Generated
        public int getRequestTimeout() {
            return this.requestTimeout;
        }

        @Generated
        public String getAuthParams() {
            return this.authParams;
        }

        @Generated
        public Boolean getTlsAllowInsecureConnection() {
            return this.tlsAllowInsecureConnection;
        }

        @Generated
        public String getTlsTrustCertsFilePath() {
            return this.tlsTrustCertsFilePath;
        }

        @Generated
        public Boolean getTlsEnableHostnameVerification() {
            return this.tlsEnableHostnameVerification;
        }

        @Generated
        public String getTlsProvider() {
            return this.tlsProvider;
        }
    }
}

