/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.impl;

import com.google.common.base.Objects;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.policies.AutoFailoverPolicy;
import org.apache.pulsar.common.policies.NamespaceIsolationPolicy;
import org.apache.pulsar.common.policies.data.BrokerStatus;
import org.apache.pulsar.common.policies.data.NamespaceIsolationData;
import org.apache.pulsar.common.policies.impl.AutoFailoverPolicyFactory;

public class NamespaceIsolationPolicyImpl
implements NamespaceIsolationPolicy {
    private List<String> namespaces;
    private List<String> primary;
    private List<String> secondary;
    private AutoFailoverPolicy auto_failover_policy;

    private boolean matchNamespaces(String fqnn) {
        for (String nsRegex : this.namespaces) {
            if (!fqnn.matches(nsRegex)) continue;
            return true;
        }
        return false;
    }

    private List<URL> getMatchedBrokers(List<String> brkRegexList, List<URL> availableBrokers) {
        ArrayList<URL> matchedBrokers = new ArrayList<URL>();
        for (URL brokerUrl : availableBrokers) {
            if (!this.matchesBrokerRegex(brkRegexList, brokerUrl.getHost())) continue;
            matchedBrokers.add(brokerUrl);
        }
        return matchedBrokers;
    }

    public NamespaceIsolationPolicyImpl(NamespaceIsolationData policyData) {
        this.namespaces = policyData.namespaces;
        this.primary = policyData.primary;
        this.secondary = policyData.secondary;
        this.auto_failover_policy = AutoFailoverPolicyFactory.create(policyData.auto_failover_policy);
    }

    @Override
    public List<String> getPrimaryBrokers() {
        return this.primary;
    }

    @Override
    public List<String> getSecondaryBrokers() {
        return this.secondary;
    }

    @Override
    public List<URL> findPrimaryBrokers(List<URL> availableBrokers, NamespaceName namespace) {
        if (!this.matchNamespaces(namespace.toString())) {
            throw new IllegalArgumentException("Namespace " + namespace.toString() + " does not match policy");
        }
        return this.getMatchedBrokers(this.primary, availableBrokers);
    }

    @Override
    public List<URL> findSecondaryBrokers(List<URL> availableBrokers, NamespaceName namespace) {
        if (!this.matchNamespaces(namespace.toString())) {
            throw new IllegalArgumentException("Namespace " + namespace.toString() + " does not match policy");
        }
        return this.getMatchedBrokers(this.secondary, availableBrokers);
    }

    @Override
    public boolean shouldFallback(SortedSet<BrokerStatus> primaryBrokers) {
        return false;
    }

    private boolean matchesBrokerRegex(List<String> brkRegexList, String broker) {
        for (String brkRegex : brkRegexList) {
            if (!broker.matches(brkRegex)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPrimaryBroker(String broker) {
        return this.matchesBrokerRegex(this.primary, broker);
    }

    @Override
    public boolean isSecondaryBroker(String broker) {
        return this.matchesBrokerRegex(this.secondary, broker);
    }

    public boolean equals(Object obj) {
        if (obj instanceof NamespaceIsolationPolicyImpl) {
            NamespaceIsolationPolicyImpl other = (NamespaceIsolationPolicyImpl)obj;
            return Objects.equal(this.namespaces, other.namespaces) && Objects.equal(this.primary, other.primary) && Objects.equal(this.secondary, other.secondary) && Objects.equal((Object)this.auto_failover_policy, (Object)other.auto_failover_policy);
        }
        return false;
    }

    @Override
    public SortedSet<BrokerStatus> getAvailablePrimaryBrokers(SortedSet<BrokerStatus> primaryCandidates) {
        TreeSet<BrokerStatus> availablePrimaries = new TreeSet<BrokerStatus>();
        for (BrokerStatus status : primaryCandidates) {
            if (!this.auto_failover_policy.isBrokerAvailable(status)) continue;
            availablePrimaries.add(status);
        }
        return availablePrimaries;
    }

    @Override
    public boolean shouldFailover(SortedSet<BrokerStatus> brokerStatus) {
        return this.auto_failover_policy.shouldFailoverToSecondary(brokerStatus);
    }

    @Override
    public boolean shouldFailover(int totalPrimaryResourceUnits) {
        return this.auto_failover_policy.shouldFailoverToSecondary(totalPrimaryResourceUnits);
    }

    @Override
    public boolean isPrimaryBrokerAvailable(BrokerStatus brkStatus) {
        return this.isPrimaryBroker(brkStatus.getBrokerAddress()) && this.auto_failover_policy.isBrokerAvailable(brkStatus);
    }

    public String toString() {
        return String.format("namespaces=%s primary=%s secondary=%s auto_failover_policy=%s", this.namespaces, this.primary, this.secondary, this.auto_failover_policy);
    }
}

