/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.stats;

import com.google.common.collect.Lists;
import io.netty.buffer.PoolArenaMetric;
import io.netty.buffer.PoolChunkListMetric;
import io.netty.buffer.PoolChunkMetric;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.util.internal.PlatformDependent;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.pulsar.common.stats.Metrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.SharedSecrets;
import sun.misc.VM;

public class JvmMetrics {
    private volatile long accumulatedYoungGcCount = 0L;
    private volatile long currentYoungGcCount = 0L;
    private volatile long accumulatedYoungGcTime = 0L;
    private volatile long currentYoungGcTime = 0L;
    private volatile long accumulatedOldGcCount = 0L;
    private volatile long currentOldGcCount = 0L;
    private volatile long accumulatedOldGcTime = 0L;
    private volatile long currentOldGcTime = 0L;
    private static final Logger log = LoggerFactory.getLogger(JvmMetrics.class);
    private static Field directMemoryUsage = null;
    private final String componentName;
    private static ObjectName youngGenName;
    private static ObjectName oldGenName;

    public JvmMetrics(ScheduledExecutorService executor, String componentName) {
        if (executor != null) {
            executor.scheduleAtFixedRate(this::updateGcStats, 0L, 1L, TimeUnit.MINUTES);
        }
        this.componentName = componentName;
    }

    public List<Metrics> generate() {
        Metrics m = this.createMetrics();
        Runtime r = Runtime.getRuntime();
        m.put("jvm_heap_used", r.totalMemory() - r.freeMemory());
        m.put("jvm_max_memory", r.maxMemory());
        m.put("jvm_total_memory", r.totalMemory());
        m.put("jvm_direct_memory_used", JvmMetrics.getJvmDirectMemoryUsed());
        m.put("jvm_max_direct_memory", VM.maxDirectMemory());
        m.put("jvm_thread_cnt", this.getThreadCount());
        m.put("jvm_gc_young_pause", this.currentYoungGcTime);
        m.put("jvm_gc_young_count", this.currentYoungGcCount);
        m.put("jvm_gc_old_pause", this.currentOldGcTime);
        m.put("jvm_gc_old_count", this.currentOldGcCount);
        long totalAllocated = 0L;
        long totalUsed = 0L;
        for (PoolArenaMetric arena : PooledByteBufAllocator.DEFAULT.directArenas()) {
            for (PoolChunkListMetric list : arena.chunkLists()) {
                for (PoolChunkMetric chunk : list) {
                    int size = chunk.chunkSize();
                    int used = size - chunk.freeBytes();
                    totalAllocated += (long)size;
                    totalUsed += (long)used;
                }
            }
        }
        m.put(this.componentName + "_default_pool_allocated", totalAllocated);
        m.put(this.componentName + "_default_pool_used", totalUsed);
        return Lists.newArrayList((Object[])new Metrics[]{m});
    }

    public static long getJvmDirectMemoryUsed() {
        block3: {
            if (directMemoryUsage != null) {
                try {
                    return ((AtomicLong)directMemoryUsage.get(null)).get();
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug("Failed to get netty-direct-memory used count {}", (Object)e.getMessage());
                }
            }
        }
        return SharedSecrets.getJavaNioAccess().getDirectBufferPool().getMemoryUsed();
    }

    private void updateGcStats() {
        MBeanServer s = ManagementFactory.getPlatformMBeanServer();
        try {
            long newValueYoungGcCount = (Long)s.getAttribute(youngGenName, "CollectionCount");
            long newValueYoungGcTime = (Long)s.getAttribute(youngGenName, "CollectionTime");
            this.currentYoungGcCount = newValueYoungGcCount - this.accumulatedYoungGcCount;
            this.currentYoungGcTime = newValueYoungGcTime - this.accumulatedYoungGcTime;
            this.accumulatedYoungGcCount = newValueYoungGcCount;
            this.accumulatedYoungGcTime = newValueYoungGcTime;
            long newValueOldGcCount = (Long)s.getAttribute(oldGenName, "CollectionCount");
            long newValueOldGcTime = (Long)s.getAttribute(oldGenName, "CollectionTime");
            this.currentOldGcCount = newValueOldGcCount - this.accumulatedOldGcCount;
            this.currentOldGcTime = newValueOldGcTime - this.accumulatedOldGcTime;
            this.accumulatedOldGcCount = newValueOldGcCount;
            this.accumulatedOldGcTime = newValueOldGcTime;
        }
        catch (Exception e) {
            log.error("Failed to collect GC stats: {}", (Object)e.getMessage());
        }
    }

    private long getThreadCount() {
        ThreadGroup parentThreadGroup = Thread.currentThread().getThreadGroup();
        while (parentThreadGroup.getParent() != null) {
            parentThreadGroup = parentThreadGroup.getParent();
        }
        return parentThreadGroup.activeCount();
    }

    private Metrics createMetrics() {
        return this.createMetrics(Collections.singletonMap("metric", "jvm_metrics"));
    }

    private Metrics createMetrics(Map<String, String> dimensionMap) {
        return Metrics.create(dimensionMap);
    }

    static {
        try {
            directMemoryUsage = PlatformDependent.class.getDeclaredField("DIRECT_MEMORY_COUNTER");
            directMemoryUsage.setAccessible(true);
        }
        catch (Exception e) {
            log.warn("Failed to access netty DIRECT_MEMORY_COUNTER field {}", (Object)e.getMessage());
        }
        youngGenName = null;
        oldGenName = null;
        try {
            youngGenName = new ObjectName("java.lang:type=GarbageCollector,name=G1 Young Generation");
            oldGenName = new ObjectName("java.lang:type=GarbageCollector,name=G1 Old Generation");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
    }
}

