/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.compression;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.pulsar.common.compression.CompressionCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xerial.snappy.Snappy;

public class CompressionCodecSnappy
implements CompressionCodec {
    private static final Logger log = LoggerFactory.getLogger(CompressionCodecSnappy.class);

    @Override
    public ByteBuf encode(ByteBuf source) {
        int uncompressedLength = source.readableBytes();
        int maxLength = Snappy.maxCompressedLength((int)uncompressedLength);
        ByteBuffer sourceNio = source.nioBuffer(source.readerIndex(), source.readableBytes());
        ByteBuf target = PooledByteBufAllocator.DEFAULT.buffer(maxLength, maxLength);
        ByteBuffer targetNio = target.nioBuffer(0, maxLength);
        int compressedLength = 0;
        try {
            compressedLength = Snappy.compress((ByteBuffer)sourceNio, (ByteBuffer)targetNio);
        }
        catch (IOException e) {
            log.error("Failed to compress to Snappy: {}", (Object)e.getMessage());
        }
        target.writerIndex(compressedLength);
        return target;
    }

    @Override
    public ByteBuf decode(ByteBuf encoded, int uncompressedLength) throws IOException {
        ByteBuf uncompressed = PooledByteBufAllocator.DEFAULT.buffer(uncompressedLength, uncompressedLength);
        ByteBuffer uncompressedNio = uncompressed.nioBuffer(0, uncompressedLength);
        ByteBuffer encodedNio = encoded.nioBuffer(encoded.readerIndex(), encoded.readableBytes());
        Snappy.uncompress((ByteBuffer)encodedNio, (ByteBuffer)uncompressedNio);
        uncompressed.writerIndex(uncompressedLength);
        return uncompressed;
    }
}

