/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.pulsar.common.policies.data.AuthPolicies;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SchemaAutoUpdateCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.common.policies.data.SubscriptionAuthMode;

public class Policies {
    public final AuthPolicies auth_policies = new AuthPolicies();
    public Set<String> replication_clusters = Sets.newHashSet();
    public BundlesData bundles;
    public Map<BacklogQuota.BacklogQuotaType, BacklogQuota> backlog_quota_map = Maps.newHashMap();
    public Map<String, DispatchRate> topicDispatchRate = Maps.newHashMap();
    public Map<String, DispatchRate> subscriptionDispatchRate = Maps.newHashMap();
    public Map<String, DispatchRate> replicatorDispatchRate = Maps.newHashMap();
    public Map<String, SubscribeRate> clusterSubscribeRate = Maps.newHashMap();
    public PersistencePolicies persistence = null;
    public Boolean deduplicationEnabled = null;
    public Map<String, PublishRate> publishMaxMessageRate = Maps.newHashMap();
    public Map<String, Integer> latency_stats_sample_rate = Maps.newHashMap();
    public int message_ttl_in_seconds = 0;
    public RetentionPolicies retention_policies = null;
    public boolean deleted = false;
    public String antiAffinityGroup;
    public static final String FIRST_BOUNDARY = "0x00000000";
    public static final String LAST_BOUNDARY = "0xffffffff";
    public boolean encryption_required = false;
    public SubscriptionAuthMode subscription_auth_mode = SubscriptionAuthMode.None;
    public int max_producers_per_topic = 0;
    public int max_consumers_per_topic = 0;
    public int max_consumers_per_subscription = 0;
    public long compaction_threshold = 0L;
    public long offload_threshold = -1L;
    public Long offload_deletion_lag_ms = null;
    @Deprecated
    public SchemaAutoUpdateCompatibilityStrategy schema_auto_update_compatibility_strategy = SchemaAutoUpdateCompatibilityStrategy.Full;
    public SchemaCompatibilityStrategy schema_compatibility_strategy = SchemaCompatibilityStrategy.UNDEFINED;
    public boolean is_allow_auto_update_schema = true;
    public boolean schema_validation_enforced = false;

    public int hashCode() {
        return Objects.hash(new Object[]{this.auth_policies, this.replication_clusters, this.backlog_quota_map, this.publishMaxMessageRate, this.topicDispatchRate, this.subscriptionDispatchRate, this.replicatorDispatchRate, this.clusterSubscribeRate, this.deduplicationEnabled, this.persistence, this.bundles, this.latency_stats_sample_rate, this.message_ttl_in_seconds, this.retention_policies, this.encryption_required, this.subscription_auth_mode, this.antiAffinityGroup, this.max_producers_per_topic, this.max_consumers_per_topic, this.max_consumers_per_subscription, this.compaction_threshold, this.offload_threshold, this.offload_deletion_lag_ms, this.schema_auto_update_compatibility_strategy, this.schema_validation_enforced, this.schema_compatibility_strategy, this.is_allow_auto_update_schema});
    }

    public boolean equals(Object obj) {
        if (obj instanceof Policies) {
            Policies other = (Policies)obj;
            return Objects.equals(this.auth_policies, other.auth_policies) && Objects.equals(this.replication_clusters, other.replication_clusters) && Objects.equals(this.backlog_quota_map, other.backlog_quota_map) && Objects.equals(this.topicDispatchRate, other.topicDispatchRate) && Objects.equals(this.subscriptionDispatchRate, other.subscriptionDispatchRate) && Objects.equals(this.replicatorDispatchRate, other.replicatorDispatchRate) && Objects.equals(this.clusterSubscribeRate, other.clusterSubscribeRate) && Objects.equals(this.publishMaxMessageRate, other.publishMaxMessageRate) && Objects.equals(this.deduplicationEnabled, other.deduplicationEnabled) && Objects.equals(this.persistence, other.persistence) && Objects.equals(this.bundles, other.bundles) && Objects.equals(this.latency_stats_sample_rate, other.latency_stats_sample_rate) && Objects.equals(this.message_ttl_in_seconds, other.message_ttl_in_seconds) && Objects.equals(this.retention_policies, other.retention_policies) && Objects.equals(this.encryption_required, other.encryption_required) && Objects.equals((Object)this.subscription_auth_mode, (Object)other.subscription_auth_mode) && Objects.equals(this.antiAffinityGroup, other.antiAffinityGroup) && this.max_producers_per_topic == other.max_producers_per_topic && this.max_consumers_per_topic == other.max_consumers_per_topic && this.max_consumers_per_subscription == other.max_consumers_per_subscription && this.compaction_threshold == other.compaction_threshold && this.offload_threshold == other.offload_threshold && this.offload_deletion_lag_ms == other.offload_deletion_lag_ms && this.schema_auto_update_compatibility_strategy == other.schema_auto_update_compatibility_strategy && this.schema_validation_enforced == other.schema_validation_enforced && this.schema_compatibility_strategy == other.schema_compatibility_strategy && this.is_allow_auto_update_schema == other.is_allow_auto_update_schema;
        }
        return false;
    }

    public static BundlesData defaultBundle() {
        BundlesData bundle = new BundlesData(1);
        ArrayList boundaries = Lists.newArrayList();
        boundaries.add(FIRST_BOUNDARY);
        boundaries.add(LAST_BOUNDARY);
        bundle.setBoundaries(boundaries);
        return bundle;
    }

    public static void setStorageQuota(Policies polices, BacklogQuota quota) {
        if (polices == null) {
            return;
        }
        polices.backlog_quota_map.put(BacklogQuota.BacklogQuotaType.destination_storage, quota);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("auth_policies", (Object)this.auth_policies).add("replication_clusters", this.replication_clusters).add("bundles", (Object)this.bundles).add("backlog_quota_map", this.backlog_quota_map).add("persistence", (Object)this.persistence).add("deduplicationEnabled", (Object)this.deduplicationEnabled).add("topicDispatchRate", this.topicDispatchRate).add("subscriptionDispatchRate", this.subscriptionDispatchRate).add("replicatorDispatchRate", this.replicatorDispatchRate).add("clusterSubscribeRate", this.clusterSubscribeRate).add("publishMaxMessageRate", this.publishMaxMessageRate).add("latency_stats_sample_rate", this.latency_stats_sample_rate).add("antiAffinityGroup", (Object)this.antiAffinityGroup).add("message_ttl_in_seconds", this.message_ttl_in_seconds).add("retention_policies", (Object)this.retention_policies).add("deleted", this.deleted).add("encryption_required", this.encryption_required).add("subscription_auth_mode", (Object)this.subscription_auth_mode).add("max_producers_per_topic", this.max_producers_per_topic).add("max_consumers_per_topic", this.max_consumers_per_topic).add("max_consumers_per_subscription", this.max_consumers_per_topic).add("compaction_threshold", this.compaction_threshold).add("offload_threshold", this.offload_threshold).add("offload_deletion_lag_ms", (Object)this.offload_deletion_lag_ms).add("schema_auto_update_compatibility_strategy", (Object)this.schema_auto_update_compatibility_strategy).add("schema_validation_enforced", this.schema_validation_enforced).add("schema_compatibility_Strategy", (Object)this.schema_compatibility_strategy).add("is_allow_auto_update_Schema", this.is_allow_auto_update_schema).toString();
    }
}

