/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Objects;

public class ResourceQuota {
    private double msgRateIn = 0.0;
    private double msgRateOut = 0.0;
    private double bandwidthIn = 0.0;
    private double bandwidthOut = 0.0;
    private double memory = 0.0;
    private boolean dynamic = true;

    public void setMsgRateIn(double msgRateIn) {
        this.msgRateIn = msgRateIn;
    }

    public double getMsgRateIn() {
        return this.msgRateIn;
    }

    public void setMsgRateOut(double msgRateOut) {
        this.msgRateOut = msgRateOut;
    }

    public double getMsgRateOut() {
        return this.msgRateOut;
    }

    public void setBandwidthIn(double bandwidthIn) {
        this.bandwidthIn = bandwidthIn;
    }

    public double getBandwidthIn() {
        return this.bandwidthIn;
    }

    public void setBandwidthOut(double bandwidthOut) {
        this.bandwidthOut = bandwidthOut;
    }

    public double getBandwidthOut() {
        return this.bandwidthOut;
    }

    public void setMemory(double memory) {
        this.memory = memory;
    }

    public double getMemory() {
        return this.memory;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public boolean getDynamic() {
        return this.dynamic;
    }

    @JsonIgnore
    public boolean isValid() {
        return this.msgRateIn > 0.0 && this.msgRateOut > 0.0 && this.bandwidthIn > 0.0 && this.bandwidthOut > 0.0 && this.memory > 0.0;
    }

    public void add(ResourceQuota quota) {
        this.msgRateIn += quota.msgRateIn;
        this.msgRateOut += quota.msgRateOut;
        this.bandwidthIn += quota.bandwidthIn;
        this.bandwidthOut += quota.bandwidthOut;
        this.memory += quota.memory;
    }

    public void substract(ResourceQuota quota) {
        this.msgRateIn -= quota.msgRateIn;
        this.msgRateOut -= quota.msgRateOut;
        this.bandwidthIn -= quota.bandwidthIn;
        this.bandwidthOut -= quota.bandwidthOut;
        this.memory -= quota.memory;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.msgRateIn, this.msgRateOut, this.bandwidthIn, this.bandwidthOut, this.memory, this.dynamic});
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResourceQuota) {
            ResourceQuota other = (ResourceQuota)obj;
            return Objects.equal((Object)this.msgRateIn, (Object)other.msgRateIn) && Objects.equal((Object)this.msgRateOut, (Object)other.msgRateOut) && Objects.equal((Object)this.bandwidthIn, (Object)other.bandwidthIn) && Objects.equal((Object)this.bandwidthOut, (Object)other.bandwidthOut) && Objects.equal((Object)this.memory, (Object)other.memory) && Objects.equal((Object)this.dynamic, (Object)other.dynamic);
        }
        return false;
    }
}

