/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.pulsar.common.policies.data.PublisherStats;
import org.apache.pulsar.common.policies.data.ReplicatorStats;
import org.apache.pulsar.common.policies.data.SubscriptionStats;

public class TopicStats {
    private int count;
    public double msgRateIn;
    public double msgThroughputIn;
    public double msgRateOut;
    public double msgThroughputOut;
    public double averageMsgSize;
    public long storageSize;
    public long backlogSize;
    public List<PublisherStats> publishers = Lists.newArrayList();
    public Map<String, SubscriptionStats> subscriptions = Maps.newHashMap();
    public Map<String, ReplicatorStats> replication = Maps.newTreeMap();
    public String deduplicationStatus;
    public long bytesInCounter;
    public long msgInCounter;

    public void reset() {
        this.count = 0;
        this.msgRateIn = 0.0;
        this.msgThroughputIn = 0.0;
        this.msgRateOut = 0.0;
        this.msgThroughputOut = 0.0;
        this.averageMsgSize = 0.0;
        this.storageSize = 0L;
        this.backlogSize = 0L;
        this.bytesInCounter = 0L;
        this.msgInCounter = 0L;
        this.publishers.clear();
        this.subscriptions.clear();
        this.replication.clear();
        this.deduplicationStatus = null;
    }

    public TopicStats add(TopicStats stats) {
        int i;
        double newAverageMsgSize;
        Preconditions.checkNotNull((Object)stats);
        ++this.count;
        this.msgRateIn += stats.msgRateIn;
        this.msgThroughputIn += stats.msgThroughputIn;
        this.msgRateOut += stats.msgRateOut;
        this.msgThroughputOut += stats.msgThroughputOut;
        this.bytesInCounter += stats.bytesInCounter;
        this.msgInCounter += stats.msgInCounter;
        this.averageMsgSize = newAverageMsgSize = (this.averageMsgSize * (double)(this.count - 1) + stats.averageMsgSize) / (double)this.count;
        this.storageSize += stats.storageSize;
        this.backlogSize += stats.backlogSize;
        if (this.publishers.size() != stats.publishers.size()) {
            for (i = 0; i < stats.publishers.size(); ++i) {
                PublisherStats publisherStats = new PublisherStats();
                this.publishers.add(publisherStats.add(stats.publishers.get(i)));
            }
        } else {
            for (i = 0; i < stats.publishers.size(); ++i) {
                this.publishers.get(i).add(stats.publishers.get(i));
            }
        }
        if (this.subscriptions.size() != stats.subscriptions.size()) {
            for (String subscription : stats.subscriptions.keySet()) {
                SubscriptionStats subscriptionStats = new SubscriptionStats();
                this.subscriptions.put(subscription, subscriptionStats.add(stats.subscriptions.get(subscription)));
            }
        } else {
            for (String subscription : stats.subscriptions.keySet()) {
                this.subscriptions.get(subscription).add(stats.subscriptions.get(subscription));
            }
        }
        if (this.replication.size() != stats.replication.size()) {
            for (String repl : stats.replication.keySet()) {
                ReplicatorStats replStats = new ReplicatorStats();
                this.replication.put(repl, replStats.add(stats.replication.get(repl)));
            }
        } else {
            for (String repl : stats.replication.keySet()) {
                this.replication.get(repl).add(stats.replication.get(repl));
            }
        }
        return this;
    }
}

