/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.com.scurrilous.circe.checksum;

import java.util.EnumSet;
import org.apache.pulsar.functions.runtime.shaded.com.scurrilous.circe.Hash;
import org.apache.pulsar.functions.runtime.shaded.com.scurrilous.circe.HashParameters;
import org.apache.pulsar.functions.runtime.shaded.com.scurrilous.circe.HashSupport;
import org.apache.pulsar.functions.runtime.shaded.com.scurrilous.circe.StatelessHash;
import org.apache.pulsar.functions.runtime.shaded.com.scurrilous.circe.crc.Sse42Crc32C;
import org.apache.pulsar.functions.runtime.shaded.com.scurrilous.circe.impl.AbstractHashProvider;
import org.apache.pulsar.functions.runtime.shaded.com.scurrilous.circe.params.CrcParameters;

public final class Crc32cSse42Provider
extends AbstractHashProvider<HashParameters> {
    private static final int[] DEFAULT_CHUNK = new int[]{4096, 512, 64};

    public Crc32cSse42Provider() {
        super(HashParameters.class);
    }

    @Override
    protected EnumSet<HashSupport> querySupportTyped(HashParameters params) {
        if (Crc32cSse42Provider.isCrc32C(params) && Sse42Crc32C.isSupported()) {
            return EnumSet.allOf(HashSupport.class);
        }
        return EnumSet.noneOf(HashSupport.class);
    }

    @Override
    protected Hash get(HashParameters params, EnumSet<HashSupport> required) {
        if (Crc32cSse42Provider.isCrc32C(params) && Sse42Crc32C.isSupported()) {
            return this.getCacheable(params, required);
        }
        throw new UnsupportedOperationException();
    }

    private static boolean isCrc32C(HashParameters params) {
        return params.equals(CrcParameters.CRC32C);
    }

    @Override
    protected StatelessHash createCacheable(HashParameters params, EnumSet<HashSupport> required) {
        return new Sse42Crc32C(DEFAULT_CHUNK);
    }
}

