/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.impl.options;

import org.apache.pulsar.functions.runtime.shaded.io.netty.util.Recycler;
import org.apache.pulsar.functions.runtime.shaded.io.netty.util.ReferenceCountUtil;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.impl.options.DeleteOptionImpl;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.options.DeleteOption;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.options.DeleteOptionBuilder;

class DeleteOptionBuilderImpl<K>
implements DeleteOptionBuilder<K> {
    private final Recycler.Handle<DeleteOptionBuilderImpl<K>> handle;
    private final Recycler<DeleteOptionImpl<K>> optionRecycler;
    private boolean prevKv;
    private K endKey;

    static <K> DeleteOptionBuilderImpl<K> create(Recycler<DeleteOptionBuilderImpl<K>> buildRecyler) {
        return buildRecyler.get();
    }

    DeleteOptionBuilderImpl(Recycler.Handle<DeleteOptionBuilderImpl<K>> handle, Recycler<DeleteOptionImpl<K>> optionRecycler) {
        this.handle = handle;
        this.optionRecycler = optionRecycler;
    }

    @Override
    public DeleteOptionBuilderImpl<K> endKey(K endKey) {
        ReferenceCountUtil.release(this.endKey);
        this.endKey = ReferenceCountUtil.retain(endKey);
        return this;
    }

    @Override
    public DeleteOption<K> build() {
        try {
            DeleteOptionImpl<K> option = DeleteOptionImpl.create(this.optionRecycler);
            option.set(this);
            DeleteOptionImpl<K> deleteOptionImpl = option;
            return deleteOptionImpl;
        }
        finally {
            this.recycle();
        }
    }

    private void recycle() {
        this.prevKv = false;
        ReferenceCountUtil.release(this.endKey);
        this.endKey = null;
        this.handle.recycle(this);
    }

    @Override
    public DeleteOptionBuilderImpl<K> prevKv(boolean prevKv) {
        this.prevKv = prevKv;
        return this;
    }

    Recycler.Handle<DeleteOptionBuilderImpl<K>> handle() {
        return this.handle;
    }

    Recycler<DeleteOptionImpl<K>> optionRecycler() {
        return this.optionRecycler;
    }

    boolean prevKv() {
        return this.prevKv;
    }

    K endKey() {
        return this.endKey;
    }
}

