/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.util.concurrent.ForwardingListeningExecutorService;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.util.concurrent.ListenableFuture;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.util.concurrent.ListenableScheduledFuture;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.util.concurrent.ListeningScheduledExecutorService;
import org.apache.pulsar.functions.runtime.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util.BoundedScheduledExecutorService;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util.SingleThreadSafeScheduledExecutorService;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.StatsLogger;

public class OrderedScheduler
extends OrderedExecutor
implements ScheduledExecutorService {
    public static SchedulerBuilder newSchedulerBuilder() {
        return new SchedulerBuilder();
    }

    private OrderedScheduler(String baseName, int numThreads, ThreadFactory threadFactory, StatsLogger statsLogger, boolean traceTaskExecution, boolean preserveMdcForTaskExecution, long warnTimeMicroSec, int maxTasksInQueue, boolean enableThreadScopedMetrics) {
        super(baseName, numThreads, threadFactory, statsLogger, traceTaskExecution, preserveMdcForTaskExecution, warnTimeMicroSec, maxTasksInQueue, false, enableThreadScopedMetrics);
    }

    @Override
    protected ExecutorService createSingleThreadExecutor(ThreadFactory factory) {
        return new BoundedScheduledExecutorService(new SingleThreadSafeScheduledExecutorService(factory), this.maxTasksInQueue);
    }

    @Override
    protected ListeningScheduledExecutorService getBoundedExecutor(ExecutorService executor) {
        return new BoundedScheduledExecutorService((ScheduledThreadPoolExecutor)executor, this.maxTasksInQueue);
    }

    @Override
    protected ListeningScheduledExecutorService addExecutorDecorators(ExecutorService executor) {
        if (!(executor instanceof ListeningScheduledExecutorService)) {
            executor = new BoundedScheduledExecutorService((ScheduledThreadPoolExecutor)executor, 0);
        }
        return new OrderedSchedulerDecoratedThread((ListeningScheduledExecutorService)executor);
    }

    @Override
    public ListeningScheduledExecutorService chooseThread() {
        return (ListeningScheduledExecutorService)super.chooseThread();
    }

    @Override
    public ListeningScheduledExecutorService chooseThread(Object orderingKey) {
        return (ListeningScheduledExecutorService)super.chooseThread(orderingKey);
    }

    @Override
    public ListeningScheduledExecutorService chooseThread(long orderingKey) {
        return (ListeningScheduledExecutorService)super.chooseThread(orderingKey);
    }

    public <T> ListenableFuture<T> submitOrdered(Object orderingKey, Callable<T> callable) {
        return this.chooseThread(orderingKey).submit((Callable)callable);
    }

    public ScheduledFuture<?> scheduleOrdered(Object orderingKey, Runnable command, long delay, TimeUnit unit) {
        return this.chooseThread(orderingKey).schedule(command, delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRateOrdered(Object orderingKey, Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.chooseThread(orderingKey).scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelayOrdered(Object orderingKey, Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.chooseThread(orderingKey).scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.chooseThread().schedule(command, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.chooseThread().schedule((Callable)callable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.chooseThread().scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.chooseThread().scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    class OrderedSchedulerDecoratedThread
    extends ForwardingListeningExecutorService
    implements ListeningScheduledExecutorService {
        private final ListeningScheduledExecutorService delegate;

        private OrderedSchedulerDecoratedThread(ListeningScheduledExecutorService delegate) {
            this.delegate = delegate;
        }

        @Override
        protected ListeningExecutorService delegate() {
            return this.delegate;
        }

        @Override
        public ListenableScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            return this.delegate.schedule(OrderedScheduler.this.timedRunnable(command), delay, unit);
        }

        @Override
        public <V> ListenableScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            return this.delegate.schedule((Callable)OrderedScheduler.this.timedCallable(callable), delay, unit);
        }

        @Override
        public ListenableScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            return this.delegate.scheduleAtFixedRate(OrderedScheduler.this.timedRunnable(command), initialDelay, period, unit);
        }

        @Override
        public ListenableScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return this.delegate.scheduleAtFixedRate(OrderedScheduler.this.timedRunnable(command), initialDelay, delay, unit);
        }

        @Override
        public <T> ListenableFuture<T> submit(Callable<T> task) {
            return super.submit((Callable)OrderedScheduler.this.timedCallable(task));
        }

        @Override
        public ListenableFuture<?> submit(Runnable task) {
            return super.submit(OrderedScheduler.this.timedRunnable(task));
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return super.invokeAll(OrderedScheduler.this.timedCallables(tasks));
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return super.invokeAll(OrderedScheduler.this.timedCallables(tasks), timeout, unit);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return super.invokeAny(OrderedScheduler.this.timedCallables(tasks));
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return super.invokeAny(OrderedScheduler.this.timedCallables(tasks), timeout, unit);
        }

        @Override
        public <T> ListenableFuture<T> submit(Runnable task, T result) {
            return super.submit(OrderedScheduler.this.timedRunnable(task), (Object)result);
        }

        @Override
        public void execute(Runnable command) {
            super.execute(OrderedScheduler.this.timedRunnable(command));
        }
    }

    public static class SchedulerBuilder
    extends OrderedExecutor.AbstractBuilder<OrderedScheduler> {
        @Override
        public OrderedScheduler build() {
            if (null == this.threadFactory) {
                this.threadFactory = new DefaultThreadFactory(this.name);
            }
            return new OrderedScheduler(this.name, this.numThreads, this.threadFactory, this.statsLogger, this.traceTaskExecution, this.preserveMdcForTaskExecution, this.warnTimeMicroSec, this.maxTasksInQueue, this.enableThreadScopedMetrics);
        }
    }
}

