/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.utils;

import org.apache.pulsar.common.functions.Resources;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Preconditions;

public class ResourceConfigUtils {
    public static void validate(Resources resources) {
        Double cpu = resources.getCpu();
        Long ram = resources.getRam();
        Long disk = resources.getDisk();
        Preconditions.checkArgument(cpu == null || cpu > 0.0, "The cpu allocation for the function must be positive");
        Preconditions.checkArgument(ram == null || ram > 0L, "The ram allocation for the function must be positive");
        Preconditions.checkArgument(disk == null || disk > 0L, "The disk allocation for the function must be positive");
    }

    public static Resources merge(Resources existingResources, Resources newResources) {
        Resources mergedResources = existingResources != null ? existingResources.toBuilder().build() : new Resources();
        if (newResources.getCpu() != null) {
            mergedResources.setCpu(newResources.getCpu());
        }
        if (newResources.getRam() != null) {
            mergedResources.setRam(newResources.getRam());
        }
        if (newResources.getDisk() != null) {
            mergedResources.setDisk(newResources.getDisk());
        }
        return mergedResources;
    }
}

