/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.pulsar.common.io.ConfigFieldDefinition;
import org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.functions.runtime.thread.ThreadRuntimeFactory;
import org.apache.pulsar.functions.utils.io.Connector;
import org.apache.pulsar.functions.utils.io.ConnectorUtils;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorsManager
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ConnectorsManager.class);
    private volatile TreeMap<String, Connector> connectors;

    @VisibleForTesting
    public ConnectorsManager() {
        this.connectors = new TreeMap();
    }

    public ConnectorsManager(WorkerConfig workerConfig) throws IOException {
        this.connectors = ConnectorsManager.createConnectors(workerConfig);
    }

    private static TreeMap<String, Connector> createConnectors(WorkerConfig workerConfig) throws IOException {
        boolean enableClassloading = workerConfig.getEnableClassloadingOfBuiltinFiles() != false || ThreadRuntimeFactory.class.getName().equals(workerConfig.getFunctionRuntimeFactoryClassName());
        return ConnectorUtils.searchForConnectors(workerConfig.getConnectorsDirectory(), workerConfig.getNarExtractionDirectory(), enableClassloading);
    }

    @VisibleForTesting
    public void addConnector(String connectorType, Connector connector) {
        this.connectors.put(connectorType, connector);
    }

    public Connector getConnector(String connectorType) {
        return this.connectors.get(connectorType);
    }

    public ConnectorDefinition getConnectorDefinition(String connectorType) {
        return this.connectors.get(connectorType).getConnectorDefinition();
    }

    public List<ConnectorDefinition> getConnectorDefinitions() {
        return this.connectors.values().stream().map(connector -> connector.getConnectorDefinition()).collect(Collectors.toList());
    }

    public Path getSourceArchive(String sourceType) {
        return this.connectors.get(sourceType).getArchivePath();
    }

    public List<ConfigFieldDefinition> getSourceConfigDefinition(String sourceType) {
        return this.connectors.get(sourceType).getSourceConfigFieldDefinitions();
    }

    public List<ConfigFieldDefinition> getSinkConfigDefinition(String sinkType) {
        return this.connectors.get(sinkType).getSinkConfigFieldDefinitions();
    }

    public Path getSinkArchive(String sinkType) {
        return this.connectors.get(sinkType).getArchivePath();
    }

    public void reloadConnectors(WorkerConfig workerConfig) throws IOException {
        TreeMap<String, Connector> oldConnectors = this.connectors;
        this.connectors = ConnectorsManager.createConnectors(workerConfig);
        this.closeConnectors(oldConnectors);
    }

    @Override
    public void close() {
        this.closeConnectors(this.connectors);
    }

    private void closeConnectors(TreeMap<String, Connector> connectorMap) {
        connectorMap.values().forEach(connector -> {
            try {
                connector.close();
            }
            catch (Exception e) {
                log.warn("Failed to close connector", (Throwable)e);
            }
        });
        connectorMap.clear();
    }

    public TreeMap<String, Connector> getConnectors() {
        return this.connectors;
    }
}

