/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.bookie.rackawareness;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.bookie.rackawareness.BookieRackAffinityMapping;
import org.apache.pulsar.bookie.rackawareness.ConfigurationStringUtil;
import org.apache.pulsar.common.policies.data.BookiesRackConfiguration;
import org.apache.pulsar.common.policies.data.EnsemblePlacementPolicyConfig;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.collect.Sets;
import org.apache.pulsar.functions.runtime.shaded.io.netty.util.HashedWheelTimer;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.BKException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.RackawareEnsemblePlacementPolicy;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.RackawareEnsemblePlacementPolicyImpl;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.feature.FeatureProvider;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.exceptions.MetadataException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.net.DNSToSwitchMapping;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.BookieAddressResolver;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.tuple.MutablePair;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.metadata.api.MetadataCache;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsolatedBookieEnsemblePlacementPolicy
extends RackawareEnsemblePlacementPolicy {
    private static final Logger log = LoggerFactory.getLogger(IsolatedBookieEnsemblePlacementPolicy.class);
    public static final String ISOLATION_BOOKIE_GROUPS = "isolationBookieGroups";
    public static final String SECONDARY_ISOLATION_BOOKIE_GROUPS = "secondaryIsolationBookieGroups";
    private ImmutablePair<Set<String>, Set<String>> defaultIsolationGroups;
    private MetadataCache<BookiesRackConfiguration> bookieMappingCache;
    private static final String PULSAR_SYSTEM_TOPIC_ISOLATION_GROUP = "*";
    private volatile BookiesRackConfiguration cachedRackConfiguration = null;

    @Override
    public RackawareEnsemblePlacementPolicyImpl initialize(ClientConfiguration conf, Optional<DNSToSwitchMapping> optionalDnsResolver, HashedWheelTimer timer, FeatureProvider featureProvider, StatsLogger statsLogger, BookieAddressResolver bookieAddressResolver) {
        String secondaryIsolationGroupsString;
        MetadataStore store;
        try {
            store = BookieRackAffinityMapping.getMetadataStore(conf);
        }
        catch (MetadataException e2) {
            throw new RuntimeException("METADATA_STORE_INSTANCE failed initialized");
        }
        HashSet primaryIsolationGroups = new HashSet();
        HashSet secondaryIsolationGroups = new HashSet();
        if (conf.getProperty(ISOLATION_BOOKIE_GROUPS) != null) {
            String isolationGroupsString = ConfigurationStringUtil.castToString(conf.getProperty(ISOLATION_BOOKIE_GROUPS));
            if (!isolationGroupsString.isEmpty()) {
                Collections.addAll(primaryIsolationGroups, isolationGroupsString.split(","));
            }
            this.bookieMappingCache = store.getMetadataCache(BookiesRackConfiguration.class);
            ((CompletableFuture)this.bookieMappingCache.get("/bookies").thenAccept(opt -> opt.ifPresent(bookiesRackConfiguration -> {
                this.cachedRackConfiguration = bookiesRackConfiguration;
            }))).exceptionally(e -> {
                log.warn("Failed to load bookies rack configuration while initialize the PlacementPolicy.");
                return null;
            });
        }
        if (conf.getProperty(SECONDARY_ISOLATION_BOOKIE_GROUPS) != null && !(secondaryIsolationGroupsString = ConfigurationStringUtil.castToString(conf.getProperty(SECONDARY_ISOLATION_BOOKIE_GROUPS))).isEmpty()) {
            Collections.addAll(secondaryIsolationGroups, secondaryIsolationGroupsString.split(","));
        }
        this.defaultIsolationGroups = ImmutablePair.of(primaryIsolationGroups, secondaryIsolationGroups);
        return super.initialize(conf, (Optional)optionalDnsResolver, timer, featureProvider, statsLogger, bookieAddressResolver);
    }

    @Override
    public EnsemblePlacementPolicy.PlacementResult<List<BookieId>> newEnsemble(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, Set<BookieId> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        if (excludeBookies == null) {
            excludeBookies = new HashSet<BookieId>();
        }
        excludeBookies.addAll(this.getExcludedBookies(ensembleSize, customMetadata));
        return super.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, customMetadata, excludeBookies);
    }

    @Override
    public EnsemblePlacementPolicy.PlacementResult<BookieId> replaceBookie(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, List<BookieId> currentEnsemble, BookieId bookieToReplace, Set<BookieId> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        if (excludeBookies == null) {
            excludeBookies = new HashSet<BookieId>();
        }
        excludeBookies.addAll(this.getExcludedBookies(ensembleSize, customMetadata));
        return super.replaceBookie(ensembleSize, writeQuorumSize, ackQuorumSize, customMetadata, currentEnsemble, bookieToReplace, excludeBookies);
    }

    private Set<BookieId> getExcludedBookies(int ensembleSize, Map<String, byte[]> customMetadata) {
        Set<BookieId> excludedBookies;
        Optional<EnsemblePlacementPolicyConfig> ensemblePlacementPolicyConfig = IsolatedBookieEnsemblePlacementPolicy.getEnsemblePlacementPolicyConfig(customMetadata);
        if (ensemblePlacementPolicyConfig.isPresent()) {
            EnsemblePlacementPolicyConfig config = ensemblePlacementPolicyConfig.get();
            Pair<Set<String>, Set<String>> groups = IsolatedBookieEnsemblePlacementPolicy.getIsolationGroup(config);
            excludedBookies = this.getExcludedBookiesWithIsolationGroups(ensembleSize, groups);
        } else {
            excludedBookies = this.getExcludedBookiesWithIsolationGroups(ensembleSize, this.defaultIsolationGroups);
        }
        return excludedBookies;
    }

    private static Optional<EnsemblePlacementPolicyConfig> getEnsemblePlacementPolicyConfig(Map<String, byte[]> customMetadata) {
        byte[] ensemblePlacementPolicyConfigData = customMetadata.get("EnsemblePlacementPolicyConfig");
        if (ensemblePlacementPolicyConfigData != null) {
            try {
                return Optional.ofNullable(EnsemblePlacementPolicyConfig.decode(ensemblePlacementPolicyConfigData));
            }
            catch (EnsemblePlacementPolicyConfig.ParseEnsemblePlacementPolicyConfigException e) {
                log.error("Failed to parse the ensemble placement policy config from the custom metadata", (Throwable)e);
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private static Pair<Set<String>, Set<String>> getIsolationGroup(EnsemblePlacementPolicyConfig ensemblePlacementPolicyConfig) {
        MutablePair<Set<String>, Set<String>> pair = new MutablePair<Set<String>, Set<String>>();
        String className = IsolatedBookieEnsemblePlacementPolicy.class.getName();
        if (ensemblePlacementPolicyConfig.getPolicyClass().getName().equals(className)) {
            Map<String, Object> properties = ensemblePlacementPolicyConfig.getProperties();
            String primaryIsolationGroupString = ConfigurationStringUtil.castToString(properties.getOrDefault(ISOLATION_BOOKIE_GROUPS, ""));
            String secondaryIsolationGroupString = ConfigurationStringUtil.castToString(properties.getOrDefault(SECONDARY_ISOLATION_BOOKIE_GROUPS, ""));
            if (!primaryIsolationGroupString.isEmpty()) {
                pair.setLeft(Sets.newHashSet(primaryIsolationGroupString.split(",")));
            } else {
                pair.setLeft(Collections.emptySet());
            }
            if (!secondaryIsolationGroupString.isEmpty()) {
                pair.setRight(Sets.newHashSet(secondaryIsolationGroupString.split(",")));
            } else {
                pair.setRight(Collections.emptySet());
            }
        }
        return pair;
    }

    @VisibleForTesting
    Set<BookieId> getExcludedBookiesWithIsolationGroups(int ensembleSize, Pair<Set<String>, Set<String>> isolationGroups) {
        HashSet<BookieId> excludedBookies;
        block16: {
            excludedBookies = new HashSet<BookieId>();
            if (isolationGroups != null && isolationGroups.getLeft().contains(PULSAR_SYSTEM_TOPIC_ISOLATION_GROUP)) {
                return excludedBookies;
            }
            try {
                if (this.bookieMappingCache == null) break block16;
                ((CompletableFuture)this.bookieMappingCache.get("/bookies").thenAccept(opt -> {
                    this.cachedRackConfiguration = opt.orElse(null);
                })).exceptionally(e -> {
                    log.warn("Failed to update the newest bookies rack config.");
                    return null;
                });
                BookiesRackConfiguration allGroupsBookieMapping = this.cachedRackConfiguration;
                if (allGroupsBookieMapping == null) {
                    log.debug("The bookies rack config is not available at now.");
                    return excludedBookies;
                }
                Set allGroups = allGroupsBookieMapping.keySet();
                int totalAvailableBookiesInPrimaryGroup = 0;
                Set<Object> primaryIsolationGroup = Collections.emptySet();
                Set<Object> secondaryIsolationGroup = Collections.emptySet();
                HashSet<BookieId> primaryGroupBookies = new HashSet<BookieId>();
                if (isolationGroups != null) {
                    primaryIsolationGroup = isolationGroups.getLeft();
                    secondaryIsolationGroup = isolationGroups.getRight();
                }
                for (String group : allGroups) {
                    Set bookiesInGroup = ((Map)allGroupsBookieMapping.get(group)).keySet();
                    if (!primaryIsolationGroup.contains(group)) {
                        Iterator iterator = bookiesInGroup.iterator();
                        while (iterator.hasNext()) {
                            String string = (String)iterator.next();
                            excludedBookies.add(BookieId.parse(string));
                        }
                        continue;
                    }
                    Iterator iterator = bookiesInGroup.iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        totalAvailableBookiesInPrimaryGroup += this.knownBookies.containsKey(BookieId.parse(string)) ? 1 : 0;
                        primaryGroupBookies.add(BookieId.parse(string));
                    }
                }
                HashSet<BookieId> otherGroupBookies = new HashSet<BookieId>(excludedBookies);
                HashSet nonRegionBookies = new HashSet(this.knownBookies.keySet());
                nonRegionBookies.removeAll(primaryGroupBookies);
                excludedBookies.addAll(nonRegionBookies);
                for (String string : primaryIsolationGroup) {
                    Map map = (Map)allGroupsBookieMapping.get(string);
                    if (map == null || map.isEmpty()) continue;
                    for (String bookieAddress : map.keySet()) {
                        excludedBookies.remove(BookieId.parse(bookieAddress));
                    }
                }
                int totalAvailableBookiesFromPrimaryAndSecondary = totalAvailableBookiesInPrimaryGroup;
                if (totalAvailableBookiesInPrimaryGroup < ensembleSize) {
                    log.info("Not found enough available-bookies from primary isolation group [{}], checking secondary group [{}]", primaryIsolationGroup, secondaryIsolationGroup);
                    for (String string : secondaryIsolationGroup) {
                        Map bookieGroup = (Map)allGroupsBookieMapping.get(string);
                        if (bookieGroup == null || bookieGroup.isEmpty()) continue;
                        for (String bookieAddress : bookieGroup.keySet()) {
                            excludedBookies.remove(BookieId.parse(bookieAddress));
                            ++totalAvailableBookiesFromPrimaryAndSecondary;
                        }
                    }
                }
                if (totalAvailableBookiesFromPrimaryAndSecondary < ensembleSize) {
                    log.info("Not found enough available-bookies from primary isolation group [{}] and secondary isolation group [{}], checking from non-region bookies", primaryIsolationGroup, secondaryIsolationGroup);
                    nonRegionBookies.removeAll(otherGroupBookies);
                    for (BookieId bookieId : nonRegionBookies) {
                        excludedBookies.remove(bookieId);
                    }
                }
            }
            catch (Exception e2) {
                log.warn("Error getting bookie isolation info from metadata store: {}", (Object)e2.getMessage());
            }
        }
        return excludedBookies;
    }
}

