/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.protocol;

import org.apache.pulsar.functions.runtime.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.Unpooled;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.ChannelHandler;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.ChannelOutboundHandlerAdapter;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.ChannelPromise;
import org.apache.pulsar.functions.runtime.shaded.io.netty.util.AbstractReferenceCounted;
import org.apache.pulsar.functions.runtime.shaded.io.netty.util.Recycler;
import org.apache.pulsar.functions.runtime.shaded.io.netty.util.ReferenceCountUtil;
import org.apache.pulsar.functions.runtime.shaded.io.netty.util.ReferenceCounted;

public final class ByteBufPair
extends AbstractReferenceCounted {
    private ByteBuf b1;
    private ByteBuf b2;
    private final Recycler.Handle<ByteBufPair> recyclerHandle;
    private static final Recycler<ByteBufPair> RECYCLER = new Recycler<ByteBufPair>(){

        @Override
        protected ByteBufPair newObject(Recycler.Handle<ByteBufPair> handle) {
            return new ByteBufPair(handle);
        }
    };
    public static final Encoder ENCODER = new Encoder();
    public static final CopyingEncoder COPYING_ENCODER = new CopyingEncoder();

    private ByteBufPair(Recycler.Handle<ByteBufPair> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    public static ByteBufPair get(ByteBuf b1, ByteBuf b2) {
        ByteBufPair buf = RECYCLER.get();
        buf.setRefCnt(1);
        buf.b1 = b1;
        buf.b2 = b2;
        return buf;
    }

    public ByteBuf getFirst() {
        return this.b1;
    }

    public ByteBuf getSecond() {
        return this.b2;
    }

    public int readableBytes() {
        return this.b1.readableBytes() + this.b2.readableBytes();
    }

    @VisibleForTesting
    public static ByteBuf coalesce(ByteBufPair pair) {
        ByteBuf b = Unpooled.buffer(pair.readableBytes());
        b.writeBytes(pair.b1, pair.b1.readerIndex(), pair.b1.readableBytes());
        b.writeBytes(pair.b2, pair.b2.readerIndex(), pair.b2.readableBytes());
        return b;
    }

    @Override
    protected void deallocate() {
        this.b1.release();
        this.b2.release();
        this.b2 = null;
        this.b1 = null;
        this.recyclerHandle.recycle(this);
    }

    @Override
    public ReferenceCounted touch(Object hint) {
        this.b1.touch(hint);
        this.b2.touch(hint);
        return this;
    }

    @ChannelHandler.Sharable
    public static class Encoder
    extends ChannelOutboundHandlerAdapter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            if (msg instanceof ByteBufPair) {
                ByteBufPair b = (ByteBufPair)msg;
                try {
                    ctx.write(b.getFirst().retainedDuplicate(), ctx.voidPromise());
                    ctx.write(b.getSecond().retainedDuplicate(), promise);
                }
                finally {
                    ReferenceCountUtil.safeRelease(b);
                }
            } else {
                ctx.write(msg, promise);
            }
        }
    }

    @ChannelHandler.Sharable
    public static class CopyingEncoder
    extends ChannelOutboundHandlerAdapter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            if (msg instanceof ByteBufPair) {
                ByteBufPair b = (ByteBufPair)msg;
                try {
                    ctx.write(b.getFirst().copy(), ctx.voidPromise());
                    ctx.write(b.getSecond().copy(), promise);
                }
                finally {
                    ReferenceCountUtil.safeRelease(b);
                }
            } else {
                ctx.write(msg, promise);
            }
        }
    }
}

