/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.slogger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.slogger.Sloggable;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.slogger.SloggableAccumulator;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.slogger.Slogger;

public abstract class AbstractSlogger
implements Slogger,
Iterable<Object> {
    private static final int MAX_DEPTH = 3;
    private List<String> parentCtx;
    private ThreadLocal<List<Object>> kvs = new ThreadLocal<List<Object>>(){

        @Override
        protected List<Object> initialValue() {
            return new ArrayList<Object>();
        }
    };
    private ThreadLocal<List<Object>> flattenedTls = ThreadLocal.withInitial(ArrayList::new);
    private final ThreadLocal<CtxIterator> iterator = new ThreadLocal<CtxIterator>(){

        @Override
        protected CtxIterator initialValue() {
            return new CtxIterator();
        }
    };

    protected AbstractSlogger(Iterable<Object> parentCtx) {
        ArrayList flattened = new ArrayList();
        AbstractSlogger.flattenKeyValues(parentCtx.iterator(), (k, v) -> {
            flattened.add(k);
            flattened.add(v);
        });
        this.parentCtx = Collections.unmodifiableList(flattened);
    }

    protected abstract Slogger newSlogger(Optional<Class<?>> var1, Iterable<Object> var2);

    protected abstract void doLog(Level var1, Enum<?> var2, String var3, Throwable var4, List<Object> var5);

    private void flattenAndLog(Level level, Enum<?> event, String message, Throwable throwable) {
        List<Object> flattened = this.flattenedTls.get();
        flattened.clear();
        this.flattenKeyValues(this::addToFlattened);
        this.doLog(level, event, message, throwable, flattened);
    }

    @Override
    public void info(String message) {
        this.flattenAndLog(Level.INFO, null, message, null);
    }

    @Override
    public void info(String message, Throwable cause) {
        this.flattenAndLog(Level.INFO, null, message, cause);
    }

    @Override
    public void info(Enum<?> event) {
        this.flattenAndLog(Level.INFO, event, null, null);
    }

    @Override
    public void info(Enum<?> event, Throwable cause) {
        this.flattenAndLog(Level.INFO, event, null, cause);
    }

    @Override
    public void warn(String message) {
        this.flattenAndLog(Level.WARN, null, message, null);
    }

    @Override
    public void warn(String message, Throwable cause) {
        this.flattenAndLog(Level.WARN, null, message, cause);
    }

    @Override
    public void warn(Enum<?> event) {
        this.flattenAndLog(Level.WARN, event, null, null);
    }

    @Override
    public void warn(Enum<?> event, Throwable cause) {
        this.flattenAndLog(Level.WARN, event, null, cause);
    }

    @Override
    public void error(String message) {
        this.flattenAndLog(Level.ERROR, null, message, null);
    }

    @Override
    public void error(String message, Throwable cause) {
        this.flattenAndLog(Level.ERROR, null, message, cause);
    }

    @Override
    public void error(Enum<?> event) {
        this.flattenAndLog(Level.ERROR, event, null, null);
    }

    @Override
    public void error(Enum<?> event, Throwable cause) {
        this.flattenAndLog(Level.ERROR, event, null, cause);
    }

    @Override
    public Slogger ctx() {
        try {
            Slogger slogger = this.newSlogger(Optional.empty(), this);
            return slogger;
        }
        finally {
            this.kvs.get().clear();
        }
    }

    @Override
    public Slogger ctx(Class<?> clazz) {
        try {
            Slogger slogger = this.newSlogger(Optional.of(clazz), this);
            return slogger;
        }
        finally {
            this.kvs.get().clear();
        }
    }

    @Override
    public Iterator<Object> iterator() {
        CtxIterator iterator = this.iterator.get();
        iterator.reset();
        return iterator;
    }

    protected void clearCurrentCtx() {
        this.kvs.get().clear();
    }

    private void addToFlattened(String key, String value) {
        this.flattenedTls.get().add(key);
        this.flattenedTls.get().add(value);
    }

    protected void flattenKeyValues(BiConsumer<String, String> consumer) {
        Iterator<Object> iter = this.iterator();
        try {
            AbstractSlogger.flattenKeyValues(iter, consumer);
        }
        finally {
            this.kvs.get().clear();
        }
    }

    public static void flattenKeyValues(Iterator<Object> iter, BiConsumer<String, String> consumer) {
        while (iter.hasNext()) {
            String key = iter.next().toString();
            if (!iter.hasNext()) {
                return;
            }
            Object value = iter.next();
            if (value instanceof Sloggable) {
                AbstractSlogger.addWithPrefix(key, (Sloggable)value, consumer, 0);
                continue;
            }
            if (value.getClass().isArray()) {
                consumer.accept(key, AbstractSlogger.arrayToString(value));
                continue;
            }
            consumer.accept(key, value.toString());
        }
    }

    @Override
    public Slogger kv(Object key, Object value) {
        this.kvs.get().add(key);
        this.kvs.get().add(value);
        return this;
    }

    private static void addWithPrefix(final String prefix, Sloggable value, final BiConsumer<String, String> consumer, final int depth) {
        value.log(new SloggableAccumulator(){

            @Override
            public SloggableAccumulator kv(Object key, Object value) {
                if (value instanceof Sloggable && depth < 3) {
                    AbstractSlogger.addWithPrefix(prefix + "." + key.toString(), (Sloggable)value, consumer, depth + 1);
                } else if (value.getClass().isArray()) {
                    consumer.accept(prefix + "." + key.toString(), AbstractSlogger.arrayToString(value));
                } else {
                    consumer.accept(prefix + "." + key.toString(), value.toString());
                }
                return this;
            }
        });
    }

    private static String arrayToString(Object o) {
        if (o instanceof long[]) {
            return Arrays.toString((long[])o);
        }
        if (o instanceof int[]) {
            return Arrays.toString((int[])o);
        }
        if (o instanceof short[]) {
            return Arrays.toString((short[])o);
        }
        if (o instanceof char[]) {
            return Arrays.toString((char[])o);
        }
        if (o instanceof byte[]) {
            return Arrays.toString((byte[])o);
        }
        if (o instanceof boolean[]) {
            return Arrays.toString((boolean[])o);
        }
        if (o instanceof float[]) {
            return Arrays.toString((float[])o);
        }
        if (o instanceof double[]) {
            return Arrays.toString((double[])o);
        }
        if (o instanceof Object[]) {
            return Arrays.toString((Object[])o);
        }
        return o.toString();
    }

    class CtxIterator
    implements Iterator<Object> {
        int index = 0;

        CtxIterator() {
        }

        private void reset() {
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < AbstractSlogger.this.parentCtx.size() + ((List)AbstractSlogger.this.kvs.get()).size();
        }

        @Override
        public Object next() {
            int i;
            if ((i = this.index++) < AbstractSlogger.this.parentCtx.size()) {
                return AbstractSlogger.this.parentCtx.get(i);
            }
            return ((List)AbstractSlogger.this.kvs.get()).get(i -= AbstractSlogger.this.parentCtx.size());
        }
    }

    public static enum Level {
        INFO,
        WARN,
        ERROR;

    }
}

